/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.ActivityInstanceFilterAttributes;
import com.ibm.bpe.clientmodel.query.ProcessInstanceFilterAttributes;
import com.ibm.bpe.util.UnicodeUtilities;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TaskTemplateFilterAttributes
extends BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    public static final String TYPE = HTMQueryConstants.TASKTEMPLATE_ENITITYTYPE;
    public static final String ID_COLUMN_NAME = "TKTID";
    public static final String CONTAINMENT_COLUMN_NAME = "CONTAINMENT_CTX_ID";
    private static Map validAttributes = new HashMap();

    public TaskTemplateFilterAttributes() {
        super(TYPE, validAttributes);
    }

    public BPCQueryFilterAttributes getNewInstance() {
        return new TaskTemplateFilterAttributes();
    }

    public StringBuffer getWhereFilterCondition() {
        CharSequence charSequence;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAttribute("taskTemplateName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"TASK_TEMPL.NAME", (Object)this.getAttribute("taskTemplateName")));
        }
        if (this.getAttribute("tktid") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK_TEMPL.TKTID IN (" + QueryUtils.convertToIDStringList((String)((String)this.getAttribute("tktid"))) + ") "));
        }
        if (this.getAttribute("taskTemplateDisplayName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getWhereDisplayName());
        }
        String string = null;
        if (this.getAttribute("kinds") != null) {
            string = QueryUtils.convertToStringList((String[])((String[])this.getAttribute("kinds")));
        } else if (this.isEntityFilter()) {
            string = TaskTemplateFilterAttributes.getKindsDefault();
        }
        if (string != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK_TEMPL.KIND IN (" + string + ")"));
        }
        if (this.isEntityFilter() && (string == null || string != null && string.indexOf(Integer.toString(105)) != -1)) {
            charSequence = new StringBuffer(75);
            ((StringBuffer)charSequence).append("TASK_TEMPL.KIND = 105");
            QueryUtils.addConditionToWhereClause((StringBuffer)charSequence, (String)"AND", (String)"TASK_TEMPL.IS_INLINE = 1");
            QueryUtils.encloseCondition((StringBuffer)charSequence);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("NOT " + ((StringBuffer)charSequence).toString()));
        }
        if (this.getAttribute("states") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK_TEMPL.STATE IN (" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("states"))) + ")"));
        }
        if (this.getAttribute("applicationName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"TASK_TEMPL.APPLIC_NAME", (Object)this.getAttribute("applicationName")));
        }
        if (this.getAttribute("namespace") != null) {
            charSequence = UnicodeUtilities.namespaceEncode((String)this.getAttribute("namespace").toString());
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getEqualStringCondition((String)"TASK_TEMPL.NAMESPACE", (String)charSequence));
        }
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("validFrom", "TASK_TEMPL.VALID_FROM", 0));
        if (this.getAttribute("validFromAfterFirst") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK_TEMPL.VALID_FROM = (SELECT MIN(VALID_FROM) FROM TASK_TEMPL WHERE NAME=TASK_TEMPL.NAME AND VALID_FROM >= " + QueryUtils.convertToTSString((String)((String)this.getAttribute("validFromAfterFirst"))) + ")"));
        }
        if (this.getAttribute("validFromBeforeLast") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK_TEMPL.VALID_FROM = (SELECT MAX(VALID_FROM) FROM TASK_TEMPL WHERE NAME=TASK_TEMPL.NAME AND NAMESPACE = TASK_TEMPL.NAMESPACE AND VALID_FROM <= " + QueryUtils.convertToTSString((String)((String)this.getAttribute("validFromBeforeLast"))) + ")"));
        }
        if (this.getAttribute("containmentContextIds") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK_TEMPL.CONTAINMENT_CTX_ID IN (" + this.getAttribute("containmentContextIds") + ")"));
        }
        if (stringBuffer.length() > 0) {
            charSequence = this.getQueryAttributes().getEntityType();
            if (ProcessInstanceFilterAttributes.TYPE.equals(charSequence)) {
                QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)"PROCESS_INSTANCE.PTID = PROCESS_TEMPLATE.PTID");
                QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)"TASK_TEMPL.CONTAINMENT_CTX_ID = PROCESS_TEMPLATE.PTID");
            } else if (ActivityInstanceFilterAttributes.TYPE.equals(charSequence)) {
                QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)"ACTIVITY.PTID = PROCESS_TEMPLATE.PTID");
                QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)"TASK_TEMPL.CONTAINMENT_CTX_ID = PROCESS_TEMPLATE.PTID");
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("where " + stringBuffer));
        }
        return stringBuffer;
    }

    private String getWhereDisplayName() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        String string = (String)this.getAttribute("taskTemplateDisplayName");
        String string2 = "TASK_TEMPL_DESC";
        if (string != null) {
            String string3 = QueryUtils.getWhereDescLocale((String)(string2 + ".LOCALE"), (Locale)this.getQueryAttributes().getLocale());
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)(string2 + ".DISPLAY_NAME"), (String)string));
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)string3);
            QueryUtils.encloseCondition((StringBuffer)stringBuffer);
            StringBuffer stringBuffer2 = new StringBuffer(75);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"AND", (String)(string2 + ".DISPLAY_NAME IS NULL"));
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"AND", (String)string3);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"AND", (String)QueryUtils.getStringCondition((String)"TASK_TEMPL.NAME", (String)string));
            QueryUtils.encloseCondition((StringBuffer)stringBuffer2);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"OR", (String)stringBuffer2.toString());
            QueryUtils.encloseCondition((StringBuffer)stringBuffer);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("whereDisplayName: " + stringBuffer.toString()));
        }
        return stringBuffer.toString();
    }

    public static String getKindsDefault() {
        return "101,103,105";
    }

    public void addName(String string) {
        this.setAttribute("taskTemplateName", string);
    }

    public void addDisplayName(String string) {
        this.setAttribute("taskTemplateDisplayName", string);
    }

    public void addKinds(int[] nArray) {
        this.setAttribute("kinds", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addStates(int[] nArray) {
        this.setAttribute("states", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addValidFromReference(String string) {
        this.addDateTimeAttributeValue("validFromReference", string);
    }

    public void addValidFromAfterFirst(String string) {
        this.addDateTimeAttributeValue("validFromAfterFirst", string);
    }

    public void addValidFromEnd(String string) {
        this.addDateTimeAttributeValue("validFromEnd", string);
    }

    public void addValidFromBeforeLast(String string) {
        this.addDateTimeAttributeValue("validFromBeforeLast", string);
    }

    public void addValidFromReferenceOffset(String string) {
        this.setAttribute("validFromReferenceOffset", string);
    }

    public void addValidFromEndOffset(String string) {
        this.setAttribute("validFromEndOffset", string);
    }

    public void addContainmentContextIds(String string) {
        this.setAttribute("containmentContextIds", QueryUtils.convertToIDStringList((String)string));
    }

    public void addContainmentContextIds(List list) {
        this.setAttribute("containmentContextIds", QueryUtils.convertToIDStringList((List)list));
    }

    public void addApplicationName(String string) {
        this.setAttribute("applicationName", string);
    }

    public void addNamespace(String string) {
        this.setAttribute("namespace", string);
    }

    public void addType(String string) {
        this.setAttribute("type", string);
    }

    static {
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"tktid", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"taskTemplateName", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"taskTemplateDisplayName", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"kinds", (Object)new String[0]);
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"states", (Object)new String[0]);
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromReference", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromReferenceOffset", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromEnd", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromEndOffset", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromAfterFirst", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"validFromBeforeLast", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"containmentContextIds", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"applicationName", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"namespace", (Object)"");
        TaskTemplateFilterAttributes.addValidAttribute((String)TYPE, (Map)validAttributes, (String)"type", (Object)"");
    }
}

