/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.ActivityInstanceFilterAttributes;
import com.ibm.bpe.clientmodel.query.ProcessInstanceFilterAttributes;
import com.ibm.bpe.clientmodel.query.ProcessTemplateFilterAttributes;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanExt;
import com.ibm.task.clientmodel.query.TaskInstanceFilterAttributes;
import com.ibm.task.clientmodel.query.TaskTemplateFilterAttributes;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInstanceQueryAttributes
extends BPCQueryAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    private static final String SELECT_CLAUSE = "DISTINCT TASK.TKIID, TASK.ACTIVATED, TASK.APPLIC_DEFAULTS_ID, TASK.APPLIC_NAME, TASK.BUSINESS_RELEVANCE, TASK.COMPLETED, TASK.CONTAINMENT_CTX_ID, TASK.CTX_AUTHORIZATION, TASK.DUE, TASK.EXPIRES, TASK.FIRST_ACTIVATED, TASK.FOLLOW_ON_TKIID, TASK.HIERARCHY_POSITION, TASK.IS_AD_HOC, TASK.IS_ESCALATED, TASK.IS_INLINE, TASK.IS_WAIT_FOR_SUB_TK, TASK.KIND, TASK.LAST_MODIFIED, TASK.LAST_STATE_CHANGE, TASK.NAME, TASK.NAME_SPACE, TASK.ORIGINATOR, TASK.OWNER, TASK.PARENT_CONTEXT_ID, TASK.PRIORITY, TASK.RESUMES, TASK.STARTED, TASK.STARTER, TASK.STATE, TASK.SUPPORT_AUTOCLAIM, TASK.SUPPORT_CLAIM_SUSP, TASK.SUPPORT_DELEGATION, TASK.SUPPORT_SUB_TASK, TASK.SUSPENDED, TASK.TKTID, TASK.TOP_TKIID, TASK.TYPE";

    public TaskInstanceQueryAttributes() {
        super(TaskInstanceFilterAttributes.TYPE, "TASK", "TKIID", true, true);
        this.setFilterAttributes((BPCQueryFilterAttributes)new ProcessTemplateFilterAttributes());
        this.setFilterAttributes((BPCQueryFilterAttributes)new ProcessInstanceFilterAttributes());
        this.setFilterAttributes((BPCQueryFilterAttributes)new ActivityInstanceFilterAttributes());
        this.setFilterAttributes(new TaskTemplateFilterAttributes());
        this.setFilterAttributes(new TaskInstanceFilterAttributes());
    }

    protected BPCQueryAttributes getNewInstance() {
        return new TaskInstanceQueryAttributes();
    }

    protected String getSelectClauseDefault() {
        String string = SELECT_CLAUSE;
        if (!this.getUseQueryAll() && (this.getFilterAttribute(TaskInstanceFilterAttributes.TYPE, "piids") != null || this.isReasonAdmin() && (this.getFilterAttributes(ProcessTemplateFilterAttributes.TYPE).getAttributes().size() > 0 || this.getFilterAttributes(ProcessInstanceFilterAttributes.TYPE).getAttributes().size() > 0 || this.getFilterAttributes(ActivityInstanceFilterAttributes.TYPE).getAttributes().size() > 0))) {
            String string2 = ",PROCESS_INSTANCE.PIID [UPIA] ";
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("query hint for process administrator/reader work items: " + string2));
            }
            string = string + " " + string2;
        }
        return string;
    }

    private boolean isReasonAdmin() {
        boolean bl = false;
        String[] stringArray = (String[])this.getFilterAttribute(TaskInstanceFilterAttributes.TYPE, "wiReasons");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (7 != Integer.parseInt(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected Map<String, String> getOrderColumnsMap() {
        return TaskInstanceBeanExt.propertyNameToDBMap;
    }
}

