/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.util.QueryResultSetWrapper;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TKTID;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanPropertyExt;
import com.ibm.task.clientmodel.query.HTMQuery;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import com.ibm.task.clientmodel.query.TaskInstanceQueryAttributes;
import com.ibm.task.clientmodel.util.LocalisedDescEntry;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TaskInstanceQuery
extends HTMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";
    public static final String TYPE = HTMQueryConstants.TASKINSTANCEQUERYTYPE;

    public TaskInstanceQuery() {
        super(new TaskInstanceQueryAttributes());
        this.setType(TYPE);
    }

    protected String getQueryString() {
        StringBuffer stringBuffer = new StringBuffer(super.getQueryString());
        stringBuffer.append("\nSelectTaskDesc clause: ").append(this.getSelectTaskInstanceDesc());
        stringBuffer.append("\nSelectTaskTemplateDesc clause: ").append(this.getSelectClauseTaskTemplateDesc());
        return stringBuffer.toString();
    }

    protected List executeHTMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.resetQueryForTaskTemplateDesc();
        QueryResultSet queryResultSet = null;
        String string = this.getSelectClause();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"add task display name and description to query!");
        }
        string = string + ", " + this.getSelectTaskInstanceDesc();
        String string2 = this.getWhereClause();
        queryResultSet = this.executeGenericHTMQuery(string, string2, this.getOrderClause(), this.getThreshold());
        List list = this.transformToBeans(new QueryResultSetWrapper((Object)queryResultSet));
        Map<String, LocalisedDescEntry> map = this.getTaskInstanceDescValues(queryResultSet);
        queryResultSet = null;
        if (this.getLocale() != null) {
            QueryResultSet queryResultSet2 = null;
            Map<String, LocalisedDescEntry> map2 = null;
            if (this.getQueryForTaskTemplateDesc()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Additional task template description query!");
                }
                if ((queryResultSet2 = this.executeTaskTemplateDescQuery(string2)) != null) {
                    map2 = this.getTaskTemplateDescValues(queryResultSet2);
                } else if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Task template description query returned null!");
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No additional task template description query needed!");
            }
            list = this.addDescValues(list, map, map2);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + list.size() + " instances"));
        }
        return list;
    }

    private List addDescValues(List list, Map map, Map map2) {
        if (list != null) {
            for (TaskInstanceBeanPropertyExt taskInstanceBeanPropertyExt : list) {
                String string = taskInstanceBeanPropertyExt.getID().toString();
                LocalisedDescEntry localisedDescEntry = (LocalisedDescEntry)map.get(string);
                LocalisedDescEntry localisedDescEntry2 = null;
                if (map2 != null) {
                    localisedDescEntry2 = (LocalisedDescEntry)map2.get(string);
                }
                taskInstanceBeanPropertyExt = this.addDescValuesToBean(taskInstanceBeanPropertyExt, localisedDescEntry, localisedDescEntry2);
            }
        }
        return list;
    }

    private TaskInstanceBeanPropertyExt addDescValuesToBean(TaskInstanceBeanPropertyExt taskInstanceBeanPropertyExt, LocalisedDescEntry localisedDescEntry, LocalisedDescEntry localisedDescEntry2) {
        String string;
        Locale locale = this.getLocale();
        String string2 = taskInstanceBeanPropertyExt.getID().toString();
        TKTID tKTID = taskInstanceBeanPropertyExt.getTaskTemplateID();
        if (tKTID != null) {
            string = tKTID.toString();
            if (localisedDescEntry2 != null) {
                this.addTaskTemplateDescriptionToCache(string, localisedDescEntry2);
            } else {
                localisedDescEntry2 = this.getTaskTemplateDescriptionFromCache(string);
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(taskInstanceBeanPropertyExt.getID() + " is ADHOC Task(no TKTID)!"));
        }
        string = LocalisedDescEntry.getResolvedInstanceDisplayName(localisedDescEntry, localisedDescEntry2);
        String string3 = LocalisedDescEntry.getResolvedInstanceDescription(localisedDescEntry, localisedDescEntry2);
        String string4 = "";
        if (localisedDescEntry2 != null) {
            string4 = localisedDescEntry2.getResolvedDisplayName();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting localized values for " + string2 + " for locale " + locale.toString() + " -> displayName: " + string + ", description: " + string3 + ", taskTemplateDisplayName: " + string4));
        }
        taskInstanceBeanPropertyExt.setLocalisedDisplayName(string, locale);
        taskInstanceBeanPropertyExt.setLocalisedDescription(string3, locale);
        taskInstanceBeanPropertyExt.setLocalisedTaskTemplateDisplayName(string4, locale);
        return taskInstanceBeanPropertyExt;
    }

    protected Object createBean(QueryResultSetWrapper queryResultSetWrapper) {
        TaskInstanceBeanPropertyExt taskInstanceBeanPropertyExt = new TaskInstanceBeanPropertyExt(queryResultSetWrapper.getHTMQueryResultSet(), this.getConnection(), this.getLocale());
        TKTID tKTID = null;
        tKTID = taskInstanceBeanPropertyExt.getTaskTemplateID();
        if (tKTID != null) {
            this.checkDescCacheForTaskTemplate(tKTID.toString());
        }
        return taskInstanceBeanPropertyExt;
    }

    protected OID getID(Object object) {
        return ((TaskInstanceBeanPropertyExt)object).getID();
    }

    protected void updateCustomProperties(Object object, Map map) {
        ((TaskInstanceBeanPropertyExt)object).addCustomProperties(map);
    }

    protected void updateQueryProperties(Object object, Map map) {
        ((TaskInstanceBeanPropertyExt)object).addQueryProperties(map);
    }
}

