/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInstanceFilterAttributes
extends BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    public static final String TYPE = HTMQueryConstants.TASKINSTANCE_ENITITYTYPE;
    public static final String ID_COLUMN_NAME = "TKIID";
    private static Map<String, Object> validAttributes = new HashMap<String, Object>();

    public TaskInstanceFilterAttributes() {
        super(TYPE, validAttributes);
    }

    public BPCQueryFilterAttributes getNewInstance() {
        return new TaskInstanceFilterAttributes();
    }

    public StringBuffer getWhereFilterCondition() {
        int n;
        int n2;
        CharSequence charSequence;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAttribute("taskInstanceName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"TASK.NAME", (Object)this.getAttribute("taskTemplateName")));
        }
        if (this.getAttribute("tkiid") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.TKIID IN (" + QueryUtils.convertToIDStringList((String)((String)this.getAttribute("tkiid"))) + ") "));
        }
        if (this.getAttribute("taskInstanceDisplayName") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getWhereDisplayName());
        }
        if (this.getAttribute("kinds") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.KIND IN(" + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("kinds"))) + ")"));
        } else if (this.isEntityFilter()) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.KIND IN (" + TaskInstanceFilterAttributes.getKindsDefault() + ")"));
        }
        if (this.getAttribute("states") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.STATE IN( " + QueryUtils.convertToStringList((String[])((String[])this.getAttribute("states"))) + ")"));
        }
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("firstActivated", "TASK.FIRST_ACTIVATED", 2));
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("due", "TASK.DUE", 0));
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("expires", "TASK.EXPIRES", 0));
        QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)this.getDateTimeCondition("completed", "TASK.COMPLETED", 2));
        if (this.getAttribute("joinSubstates") != null) {
            if ("false".equals(this.getAttribute("joinSubstates"))) {
                if (this.getAttribute("escalated") != null) {
                    QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.IS_ESCALATED = " + ("true".equals(this.getAttribute("escalated")) ? "1" : "0")));
                }
                if (this.getAttribute("suspended") != null) {
                    QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.SUSPENDED = " + ("true".equals(this.getAttribute("suspended")) ? "1" : "0")));
                }
                if (this.getAttribute("waitForSubTk") != null) {
                    QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.IS_WAIT_FOR_SUB_TK = " + ("true".equals(this.getAttribute("waitForSubTk")) ? "1" : "0")));
                }
            } else {
                charSequence = new StringBuffer(75);
                if (this.getAttribute("escalated") != null) {
                    QueryUtils.addConditionToWhereClause((StringBuffer)charSequence, (String)"OR", (String)("TASK.IS_ESCALATED = " + ("true".equals(this.getAttribute("escalated")) ? "1" : "0")));
                }
                if (this.getAttribute("suspended") != null) {
                    QueryUtils.addConditionToWhereClause((StringBuffer)charSequence, (String)"OR", (String)("TASK.SUSPENDED = " + ("true".equals(this.getAttribute("suspended")) ? "1" : "0")));
                }
                if (this.getAttribute("waitForSubTk") != null) {
                    QueryUtils.addConditionToWhereClause((StringBuffer)charSequence, (String)"OR", (String)("TASK.IS_WAIT_FOR_SUB_TK = " + ("true".equals(this.getAttribute("waitForSubTk")) ? "1" : "0")));
                }
                QueryUtils.encloseCondition((StringBuffer)charSequence);
                QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)charSequence.toString());
            }
        }
        if (this.getAttribute("tkiids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.TKIID IN (" + this.getAttribute("tkiids") + ")"));
        }
        if (this.getAttribute("tktids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.TKTID IN (" + this.getAttribute("tktids") + ")"));
        }
        if (this.getAttribute("piids") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.CONTAINMENT_CTX_ID IN (" + this.getAttribute("piids") + ")"));
        }
        if (this.getAttribute("containmentContextIds") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.CONTAINMENT_CTX_ID IN (" + this.getAttribute("containmentContextIds") + ")"));
        }
        if (this.getAttribute("parentContextIds") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.PARENT_CONTEXT_ID IN (" + this.getAttribute("parentContextIds") + ")"));
        }
        if (this.getAttribute("topLevelTaskIds") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.TOP_TKIID IN (" + this.getAttribute("topLevelTaskIds") + ")"));
        }
        if (this.getAttribute("excludeTKIIDs") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.TKIID NOT IN (" + this.getAttribute("excludeTKIIDs") + ")"));
        }
        charSequence = (String)this.getAttribute("priorityFrom");
        String string = (String)this.getAttribute("priorityTo");
        if (charSequence != null && string != null) {
            n2 = Integer.parseInt((String)charSequence);
            n = Integer.parseInt(string);
            if (n < n2) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.PRIORITY >= " + n2 + " AND " + "TASK" + ".PRIORITY <= " + n));
        } else if (charSequence != null || string != null) {
            n2 = charSequence != null ? Integer.parseInt((String)charSequence) : Integer.parseInt(string);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)("TASK.PRIORITY IN (" + n2 + ")"));
        }
        if (this.getAttribute("type") != null) {
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)"TASK.TYPE", (Object)this.getAttribute("type")));
        }
        String string2 = QueryUtils.getWorkItemFilterCondition((BPCQueryFilterAttributes)this);
        int n4 = n = this.getAttribute("excludePO4Claimed") != null ? 1 : 0;
        if (string2 != null || n != 0) {
            if (n != 0) {
                QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)"NOT ( TASK.STATE IN (8) AND WORK_ITEM.REASON IN (1))");
            }
            if (string2 != null) {
                QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)string2);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("where " + stringBuffer));
        }
        return stringBuffer;
    }

    private String getWhereDisplayName() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        String string = (String)this.getAttribute("taskInstanceDisplayName");
        String string2 = "TASK_DESC";
        String string3 = "TASK_TEMPL_DESC";
        if (string != null) {
            String string4 = QueryUtils.getWhereDescLocale((String)(string2 + ".LOCALE"), (Locale)this.getQueryAttributes().getLocale());
            String string5 = QueryUtils.getWhereDescLocale((String)(string3 + ".LOCALE"), (Locale)this.getQueryAttributes().getLocale());
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)QueryUtils.getStringCondition((String)(string2 + ".DISPLAY_NAME"), (String)string));
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"AND", (String)string4);
            QueryUtils.encloseCondition((StringBuffer)stringBuffer);
            StringBuffer stringBuffer2 = new StringBuffer(75);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"AND", (String)(string2 + ".DISPLAY_NAME IS NULL"));
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"AND", (String)string4);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"AND", (String)QueryUtils.getStringCondition((String)(string3 + ".DISPLAY_NAME"), (String)string));
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer2, (String)"AND", (String)string5);
            QueryUtils.encloseCondition((StringBuffer)stringBuffer2);
            StringBuffer stringBuffer3 = new StringBuffer(75);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer3, (String)"AND", (String)(string2 + ".DISPLAY_NAME IS NULL"));
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer3, (String)"AND", (String)string4);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer3, (String)"AND", (String)(string3 + ".DISPLAY_NAME IS NULL"));
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer3, (String)"AND", (String)string5);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer3, (String)"AND", (String)QueryUtils.getStringCondition((String)"TASK.NAME", (String)string));
            QueryUtils.encloseCondition((StringBuffer)stringBuffer3);
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"OR", (String)stringBuffer2.toString());
            QueryUtils.addConditionToWhereClause((StringBuffer)stringBuffer, (String)"OR", (String)stringBuffer3.toString());
            QueryUtils.encloseCondition((StringBuffer)stringBuffer);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("whereDisplayName: " + stringBuffer.toString()));
        }
        return stringBuffer.toString();
    }

    public static String getKindsDefault() {
        return "102,101,103,105";
    }

    public void addKinds(int[] nArray) {
        this.setAttribute("kinds", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addStates(int[] nArray) {
        this.setAttribute("states", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addFirstActivatedEnd(String string) {
        this.addDateTimeAttributeValue("firstActivatedEnd", string);
    }

    public void addFirstActivatedReference(String string) {
        this.addDateTimeAttributeValue("firstActivatedReference", string);
    }

    public void addFirstActivatedReferenceOffset(String string) {
        this.setAttribute("firstActivatedReferenceOffset", string);
    }

    public void addFirstActivatedEndOffset(String string) {
        this.setAttribute("firstActivatedEndOffset", string);
    }

    public void addDueEnd(String string) {
        this.addDateTimeAttributeValue("dueEnd", string);
    }

    public void addDueReferenceOffset(String string) {
        this.setAttribute("dueReferenceOffset", string);
    }

    public void addDueReference(String string) {
        this.addDateTimeAttributeValue("dueReference", string);
    }

    public void addDueEndOffset(String string) {
        this.setAttribute("dueEndOffset", string);
    }

    public void addExpiresEnd(String string) {
        this.addDateTimeAttributeValue("expiresEnd", string);
    }

    public void addExpiresReference(String string) {
        this.addDateTimeAttributeValue("expiresReference", string);
    }

    public void addExpiresReferenceOffset(String string) {
        this.setAttribute("expiresReferenceOffset", string);
    }

    public void addExpiresEndOffset(String string) {
        this.setAttribute("expiresEndOffset", string);
    }

    public void addCompletedEnd(String string) {
        this.addDateTimeAttributeValue("completedEnd", string);
    }

    public void addCompletedReference(String string) {
        this.addDateTimeAttributeValue("completedReference", string);
    }

    public void addCompletedReferenceOffset(String string) {
        this.setAttribute("completedReferenceOffset", string);
    }

    public void addCompletedEndOffset(String string) {
        this.setAttribute("completedEndOffset", string);
    }

    public void addJoinSubstates(String string) {
        this.setAttribute("joinSubstates", string);
    }

    public void addExcludeTKIIDs(String string) {
        this.setAttribute("excludeTKIIDs", QueryUtils.convertToIDStringList((String)string));
    }

    public void addEscalated(String string) {
        this.setAttribute("escalated", string);
    }

    public void addSuspended(String string) {
        this.setAttribute("suspended", string);
    }

    public void addWaitForSubtask(String string) {
        this.setAttribute("waitForSubTk", string);
    }

    public void addTaskInstanceIds(String string) {
        this.setAttribute("tkiids", QueryUtils.convertToIDStringList((String)string));
    }

    public void addTaskInstanceIds(List<String> list) {
        this.setAttribute("tkiids", QueryUtils.convertToIDStringList(list));
    }

    public void addTaskTemplateIds(String string) {
        this.setAttribute("tktids", QueryUtils.convertToIDStringList((String)string));
    }

    public void addTaskTemplateIds(List<String> list) {
        this.setAttribute("tktids", QueryUtils.convertToIDStringList(list));
    }

    public void addProcessInstanceIds(String string) {
        this.setAttribute("piids", QueryUtils.convertToIDStringList((String)string));
    }

    public void addProcessInstanceIds(List<String> list) {
        this.setAttribute("piids", QueryUtils.convertToIDStringList(list));
    }

    public void addContainmentContextIds(String string) {
        this.setAttribute("containmentContextIds", QueryUtils.convertToIDStringList((String)string));
    }

    public void addContainmentContextIds(List<String> list) {
        this.setAttribute("containmentContextIds", QueryUtils.convertToIDStringList(list));
    }

    public void addParentContextIds(String string) {
        this.setAttribute("parentContextIds", QueryUtils.convertToIDStringList((String)string));
    }

    public void addParentContextIds(List<String> list) {
        this.setAttribute("parentContextIds", QueryUtils.convertToIDStringList(list));
    }

    public void addTopLevelTaskIds(String string) {
        this.setAttribute("topLevelTaskIds", QueryUtils.convertToIDStringList((String)string));
    }

    public void addWorkItemReasons(int[] nArray) {
        this.setAttribute("wiReasons", QueryUtils.convertToStringArray((int[])nArray));
    }

    public void addExcludePotentialOwnerForClaimedWorkItem() {
        this.setAttribute("excludePO4Claimed", "true");
    }

    public void addWorkItemOwner(String string) {
        this.setAttribute("wiOwners", new String[]{string});
    }

    public void addWorkItemOwners(String[] stringArray) {
        this.setAttribute("wiOwners", stringArray);
    }

    public void addWorkItemGroups(String[] stringArray) {
        this.setAttribute("wiGroups", stringArray);
    }

    static {
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"tkiid", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"taskInstanceName", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"taskInstanceDisplayName", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"kinds", (Object)new String[0]);
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"states", (Object)new String[0]);
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"firstActivatedReference", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"firstActivatedReferenceOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"firstActivatedEnd", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"firstActivatedEndOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"dueReference", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"dueReferenceOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"dueEnd", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"dueEndOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"excludeTKIIDs", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresReference", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresReferenceOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresEnd", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"expiresEndOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedReference", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedReferenceOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedEnd", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"completedEndOffset", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"escalated", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"suspended", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"waitForSubTk", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"joinSubstates", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"tkiids", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"tktids", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"piids", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"containmentContextIds", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"parentContextIds", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"topLevelTaskIds", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiReasons", (Object)new String[0]);
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"excludePO4Claimed", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiOwners", (Object)new String[0]);
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"wiGroups", (Object)new String[0]);
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"privateWIs", (Object)"false");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"groupWIs", (Object)"false");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"everybodyWIs", (Object)"false");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"priorityFrom", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"priorityTo", (Object)"");
        TaskInstanceFilterAttributes.addValidAttribute((String)TYPE, validAttributes, (String)"type", (Object)"");
    }
}

