/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Localization;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.query.BPCQueryPropertyExt;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.exception.HTMQueryException;
import com.ibm.task.clientmodel.query.EscalationFilterAttributes;
import com.ibm.task.clientmodel.query.TaskInstanceFilterAttributes;
import com.ibm.task.clientmodel.query.TaskTemplateFilterAttributes;
import com.ibm.task.clientmodel.query.WorkItemFilterAttributes;
import com.ibm.task.clientmodel.util.HTMUtils;
import com.ibm.task.clientmodel.util.LocalisedDescEntry;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTMQuery
extends BPCQueryPropertyExt
implements Localization {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private HTMConnection connection;
    private boolean queryForTaskTemplateDesc = true;
    private boolean queryForEscTemplateDesc = true;
    private static HashMap<String, LocalisedDescEntry> T_TEMP_DESC_CACHE = new HashMap();
    private static HashMap<String, LocalisedDescEntry> E_TEMP_DESC_CACHE = new HashMap();

    public HTMQuery() {
    }

    public HTMQuery(BPCQueryAttributes bPCQueryAttributes) {
        super(bPCQueryAttributes);
    }

    public String getWhereClause() {
        return super.getWhereClause();
    }

    public List executeBPCQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        List list = null;
        Assert.assertion((this.getConnection() != null ? 1 : 0) != 0, (String)("No connection set for query" + ((Object)((Object)this)).getClass()));
        list = this.executeHTMQuery();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("Returning " + list.size() + " items"));
        }
        return list;
    }

    protected abstract List executeHTMQuery() throws ClientException;

    protected QueryResultSet executeGenericHTMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        return this.executeGenericHTMQuery(this.getSelectClause(), this.getWhereClause(), this.getOrderClause(), this.getThreshold());
    }

    protected QueryResultSet executeGenericHTMQuery(String string, String string2, String string3, Integer n) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getQueryString(string, string2, string3, n));
        }
        String string4 = this.updateWhereClause(string2);
        QueryResultSet queryResultSet = null;
        try {
            HumanTaskManagerService humanTaskManagerService = this.getService();
            queryResultSet = this.getUseQueryAll() ? humanTaskManagerService.queryAll(string, string4, string3, null, n, null) : humanTaskManagerService.query(string, string4, string3, n, null);
        }
        catch (TaskException taskException) {
            throw new HTMQueryException(new Object[]{this.getQueryString(string, string4, string3, n)}, taskException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()});
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()});
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("result size: " + (queryResultSet == null ? 0 : queryResultSet.size())));
        }
        return queryResultSet;
    }

    public HTMConnection getConnection() {
        return this.connection;
    }

    public void setConnection(HTMConnection hTMConnection) {
        this.connection = hTMConnection;
        this.setSystemAdmin(HTMUtils.isHTMSystemAdministrator(this.connection));
        this.setSystemMonitor(HTMUtils.isHTMSystemMonitor(this.connection));
    }

    public HumanTaskManagerService getService() throws ClientException {
        Assert.assertion((this.getConnection() != null ? 1 : 0) != 0, (String)("No connection set for query" + ((Object)((Object)this)).getClass()));
        return HTMUtils.getHumanTaskManagerService(this.getConnection());
    }

    protected QueryResultSet executeTaskTemplateDescQuery(String string) throws ClientException {
        return this.executeDescQuery(this.getSelectClauseTaskTemplateDesc(), string);
    }

    protected QueryResultSet executeEscalationTemplateDescQuery(String string) throws ClientException {
        return this.executeDescQuery(this.getSelectClauseEscalationTemplateDesc(), string);
    }

    protected QueryResultSet executeDescQuery(String string, String string2) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        QueryResultSet queryResultSet = this.executeGenericHTMQuery(string, string2, this.getOrderClause(), this.getThreshold());
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("result size: " + (queryResultSet == null ? 0 : queryResultSet.size())));
        }
        return queryResultSet;
    }

    protected String getSelectTaskInstanceDesc() {
        return this.getSelectDesc("TASK_DESC");
    }

    protected String getSelectClauseTaskTemplateDesc() {
        return this.getSelectClauseTemplateDesc("TASK_TEMPL_DESC", "TASK_TEMPL");
    }

    protected String getSelectEscalationDesc() {
        return this.getSelectDesc("ESCALATION_DESC");
    }

    protected String getSelectClauseEscalationTemplateDesc() {
        return this.getSelectClauseTemplateDesc("ESC_TEMPL_DESC", "ESC_TEMPL");
    }

    private String getSelectClauseTemplateDesc(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(75);
        stringBuffer.append("DISTINCT ");
        stringBuffer.append(this.getTableName() + "." + this.getIdColumnName());
        stringBuffer.append(", ");
        stringBuffer.append(string2 + ".NAME");
        stringBuffer.append(", ");
        stringBuffer.append(this.getSelectDesc(string));
        String string3 = stringBuffer.toString();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)string3);
        }
        return string3;
    }

    private String getSelectDesc(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(75);
        stringBuffer.append(this.getSelectDescForLocale(string, "default", "1"));
        if (this.getLocale() != null) {
            string2 = this.getLocale().toString();
            stringBuffer.append(", ");
            stringBuffer.append(this.getSelectDescForLocale(string, string2, "2"));
            if (string2.indexOf(95) > 0) {
                stringBuffer.append(", ");
                stringBuffer.append(this.getSelectDescForLocale(string, string2.substring(0, 2), "3"));
            }
        }
        string2 = stringBuffer.toString();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)string2);
        }
        return string2;
    }

    private String getSelectDescForLocale(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(75);
        String string4 = string + string3 + ".LOCALE";
        String string5 = string + string3 + "LOCALE";
        stringBuffer.append(string4 + " as " + string5);
        String string6 = QueryUtils.getEqualStringCondition((String)string4, (String)string2);
        stringBuffer.append(" [AOJP:").append(string6).append("]");
        string4 = string + string3 + ".DISPLAY_NAME";
        string5 = string + string3 + "DISPLAY_NAME";
        stringBuffer.append(", " + string4 + " as " + string5);
        string4 = string + string3 + ".DESCRIPTION";
        string5 = string + string3 + "DESCRIPTION";
        stringBuffer.append(", " + string4 + " as " + string5);
        return stringBuffer.toString();
    }

    protected Map<String, LocalisedDescEntry> getTaskTemplateDescValues(QueryResultSet queryResultSet) {
        return this.getTemplateDescValues(queryResultSet, "TASK_TEMPL_DESC", "TASK_TEMPL", "taskTemplate");
    }

    protected Map<String, LocalisedDescEntry> getEscalationTemplateDescValues(QueryResultSet queryResultSet) {
        return this.getTemplateDescValues(queryResultSet, "ESC_TEMPL_DESC", "ESC_TEMPL", "escalationTemplate");
    }

    private Map<String, LocalisedDescEntry> getTemplateDescValues(QueryResultSet queryResultSet, String string, String string2, String string3) {
        Map<String, LocalisedDescEntry> map = new HashMap<String, LocalisedDescEntry>(queryResultSet.size());
        while (queryResultSet.next()) {
            map = this.addDescValues(map, queryResultSet, string, string2, string3);
        }
        return map;
    }

    protected Map<String, LocalisedDescEntry> getTaskInstanceDescValues(QueryResultSet queryResultSet) {
        return this.getInstanceDescValues(queryResultSet, "TASK_DESC", "TASK", "taskInstance");
    }

    protected Map<String, LocalisedDescEntry> getEscalationDescValues(QueryResultSet queryResultSet) {
        return this.getInstanceDescValues(queryResultSet, "ESCALATION_DESC", "ESCALATION", "escalation");
    }

    private Map<String, LocalisedDescEntry> getInstanceDescValues(QueryResultSet queryResultSet, String string, String string2, String string3) {
        Map<String, LocalisedDescEntry> map = new HashMap<String, LocalisedDescEntry>(queryResultSet.size());
        if (queryResultSet.first()) {
            map = this.addDescValues(map, queryResultSet, string, string2, string3);
        }
        while (queryResultSet.next()) {
            map = this.addDescValues(map, queryResultSet, string, string2, string3);
        }
        return map;
    }

    private Map<String, LocalisedDescEntry> addDescValues(Map<String, LocalisedDescEntry> map, QueryResultSet queryResultSet, String string, String string2, String string3) {
        Object object;
        Object object2 = null;
        String string4 = null;
        HashMap<String, LocalisedDescEntry> hashMap = new HashMap<String, LocalisedDescEntry>(3);
        for (int i = 1; i <= queryResultSet.numberColumns(); ++i) {
            object = queryResultSet.getTableDisplayName(i);
            String string5 = queryResultSet.getColumnDisplayName(i);
            if (this.getTableName().equalsIgnoreCase((String)object) && this.getIdColumnName().equalsIgnoreCase(string5)) {
                object2 = queryResultSet.getOID(i);
            }
            if (string2.equalsIgnoreCase((String)object) && "NAME".equalsIgnoreCase(string5)) {
                string4 = queryResultSet.getString(i);
            }
            if (!((String)object).equalsIgnoreCase(string)) continue;
            String string6 = queryResultSet.getString(i);
            int n = string.length() + 1;
            String string7 = string5.substring(0, n);
            String string8 = string5.substring(n);
            LocalisedDescEntry localisedDescEntry = (LocalisedDescEntry)hashMap.get(string7);
            if (localisedDescEntry == null) {
                localisedDescEntry = new LocalisedDescEntry();
                localisedDescEntry.setName(string4);
                hashMap.put(string7, localisedDescEntry);
            }
            if ("LOCALE".equalsIgnoreCase(string8)) {
                localisedDescEntry.setLocaleString(string6);
            }
            if ("DISPLAY_NAME".equalsIgnoreCase(string8)) {
                localisedDescEntry.setDisplayName(string6);
            }
            if (!"DESCRIPTION".equalsIgnoreCase(string8)) continue;
            localisedDescEntry.setDescription(string6);
        }
        LocalisedDescEntry localisedDescEntry = null;
        if (hashMap.size() > 0) {
            object = new ArrayList(hashMap.values());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(string3 + " oid=" + object2 + "\n" + object));
            }
            localisedDescEntry = LocalisedDescEntry.getDescForLocale((List)object, this.getLocale(), string3);
        }
        if (localisedDescEntry == null) {
            localisedDescEntry = new LocalisedDescEntry();
        }
        localisedDescEntry.setName(string4);
        map.put(object2.toString(), localisedDescEntry);
        return map;
    }

    public TaskTemplateFilterAttributes getTaskTemplateFilterAttributes() {
        return (TaskTemplateFilterAttributes)this.getQueryAttributes().getFilterAttributes(TaskTemplateFilterAttributes.TYPE);
    }

    public TaskInstanceFilterAttributes getTaskInstanceFilterAttributes() {
        return (TaskInstanceFilterAttributes)this.getQueryAttributes().getFilterAttributes(TaskInstanceFilterAttributes.TYPE);
    }

    public EscalationFilterAttributes getEscalationFilterAttributes() {
        return (EscalationFilterAttributes)this.getQueryAttributes().getFilterAttributes(EscalationFilterAttributes.TYPE);
    }

    public WorkItemFilterAttributes getWorkItemAdministrationFilterAttributes() {
        return (WorkItemFilterAttributes)this.getQueryAttributes().getFilterAttributes(WorkItemFilterAttributes.TYPE);
    }

    protected void checkDescCacheForTaskTemplate(String string) {
        if (!this.queryForTaskTemplateDesc && T_TEMP_DESC_CACHE.get(this.getLocale().toString() + "" + string) == null) {
            this.queryForTaskTemplateDesc = true;
        }
    }

    protected void resetQueryForTaskTemplateDesc() {
        this.queryForTaskTemplateDesc = false;
    }

    protected boolean getQueryForTaskTemplateDesc() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Items in task template description cache: " + T_TEMP_DESC_CACHE.size()));
        }
        return this.queryForTaskTemplateDesc;
    }

    protected LocalisedDescEntry getTaskTemplateDescriptionFromCache(String string) {
        LocalisedDescEntry localisedDescEntry = T_TEMP_DESC_CACHE.get(this.getLocale().toString() + "" + string);
        if (localisedDescEntry == null) {
            return null;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returning task template description from cache: " + string + " >> " + ((Object)localisedDescEntry).toString()));
        }
        return localisedDescEntry;
    }

    protected void addTaskTemplateDescriptionToCache(String string, LocalisedDescEntry localisedDescEntry) {
        if (BPCClientTrace.isTracing && localisedDescEntry != null) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added task template description to cache: " + string + " >> " + localisedDescEntry.toString()));
        }
        T_TEMP_DESC_CACHE.put(this.getLocale().toString() + "" + string, localisedDescEntry);
    }

    protected void checkDescCacheForEscTemplate(String string) {
        if (!this.queryForEscTemplateDesc && E_TEMP_DESC_CACHE.get(this.getLocale().toString() + "" + string) == null) {
            this.queryForEscTemplateDesc = true;
        }
    }

    protected void resetQueryForEscTemplateDesc() {
        this.queryForEscTemplateDesc = false;
    }

    protected boolean getQueryForEscTemplateDesc() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Items in escalation template description cache: " + E_TEMP_DESC_CACHE.size()));
        }
        return this.queryForEscTemplateDesc;
    }

    protected LocalisedDescEntry getEscTemplateDescriptionFromCache(String string) {
        LocalisedDescEntry localisedDescEntry = E_TEMP_DESC_CACHE.get(this.getLocale().toString() + "" + string);
        if (localisedDescEntry == null) {
            return null;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returning escalation template description from cache: " + string + " >> " + ((Object)localisedDescEntry).toString()));
        }
        return localisedDescEntry;
    }

    protected void addEscTemplateDescriptionToCache(String string, LocalisedDescEntry localisedDescEntry) {
        if (BPCClientTrace.isTracing && localisedDescEntry != null) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Added escalation template description to cache: " + string + " >> " + localisedDescEntry.toString()));
        }
        E_TEMP_DESC_CACHE.put(this.getLocale().toString() + "" + string, localisedDescEntry);
    }
}

