/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.GenericBPCQueryExt;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.InvalidTypeForQueryException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.EscalationBean;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.TaskTemplateBean;
import com.ibm.task.clientmodel.exception.HTMQueryException;
import com.ibm.task.clientmodel.util.HTMUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericHTMQuery
extends GenericBPCQueryExt {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private HTMConnection connection;

    public List execute() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        QueryResultSet queryResultSet = null;
        Assert.assertion((this.getConnection() != null ? 1 : 0) != 0, (String)("No connection set for query" + ((Object)((Object)this)).getClass()));
        queryResultSet = this.executeHTMQuery();
        List<Object> list = null;
        String string = this.getType();
        if (TaskTemplateBean.class.getName().equals(string)) {
            throw new InvalidTypeForQueryException(new Object[]{TaskTemplateBean.class.getName(), ((Object)((Object)this)).getClass()});
        }
        if (TaskInstanceBean.class.getName().equals(string)) {
            list = this.transformToTaskInstances(queryResultSet);
        } else if (EscalationBean.class.getName().equals(string)) {
            list = this.transformToEscalations(queryResultSet);
        } else {
            throw new InvalidTypeForQueryException(new Object[]{string, ((Object)((Object)this)).getClass()});
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("Returned Instances " + list.size()));
        }
        return list;
    }

    private QueryResultSet executeHTMQuery() throws ClientException {
        try {
            HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(this.getConnection());
            if (this.getUseQueryAll()) {
                return humanTaskManagerService.queryAll(this.getSelectClause(), this.getWhereClause(), this.getOrderClause(), null, this.getThreshold(), null);
            }
            return humanTaskManagerService.query(this.getSelectClause(), this.getWhereClause(), this.getOrderClause(), this.getThreshold(), null);
        }
        catch (TaskException taskException) {
            throw new HTMQueryException(new Object[]{this.getQueryString()}, taskException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{((Object)((Object)this)).getClass()}, (Throwable)remoteException);
        }
    }

    public HTMConnection getConnection() {
        return this.connection;
    }

    public void setConnection(HTMConnection hTMConnection) {
        this.connection = hTMConnection;
    }

    public HumanTaskManagerService getService() throws ClientException {
        Assert.assertion((this.getConnection() != null ? 1 : 0) != 0, (String)("No connection set for query" + ((Object)((Object)this)).getClass()));
        return HTMUtils.getHumanTaskManagerService(this.getConnection());
    }

    private List<TaskInstanceBean> transformToTaskInstances(QueryResultSet queryResultSet) {
        ArrayList<TaskInstanceBean> arrayList = null;
        int n = queryResultSet.size();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returned Instances " + n));
        }
        if (n > 0) {
            arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                queryResultSet.next();
                arrayList.add(new TaskInstanceBean(queryResultSet, this.connection));
            }
        } else {
            arrayList = new ArrayList<TaskInstanceBean>();
        }
        return arrayList;
    }

    private List<EscalationBean> transformToEscalations(QueryResultSet queryResultSet) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ArrayList<EscalationBean> arrayList = null;
        int n = queryResultSet.size();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Returned Instances " + n));
        }
        if (n > 0) {
            arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                queryResultSet.next();
                arrayList.add(new EscalationBean(queryResultSet, this.getConnection()));
            }
        } else {
            arrayList = new ArrayList<EscalationBean>();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return arrayList;
    }
}

