/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.query;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.util.QueryResultSetWrapper;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.ESTID;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TKTID;
import com.ibm.task.clientmodel.bean.EscalationBeanExt;
import com.ibm.task.clientmodel.query.EscalationQueryAttributes;
import com.ibm.task.clientmodel.query.HTMQuery;
import com.ibm.task.clientmodel.query.HTMQueryConstants;
import com.ibm.task.clientmodel.util.LocalisedDescEntry;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EscalationQuery
extends HTMQuery {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    public static final String TYPE = HTMQueryConstants.ESCALATIONSQUERYTYPE;

    public EscalationQuery() {
        super(new EscalationQueryAttributes());
        this.setType(TYPE);
    }

    protected String getQueryString() {
        StringBuffer stringBuffer = new StringBuffer(super.getQueryString());
        stringBuffer.append("\nSelectEscalationDesc clause: ").append(this.getSelectEscalationDesc());
        stringBuffer.append("\nSelectTaskDesc clause: ").append(this.getSelectTaskInstanceDesc());
        stringBuffer.append("\nSelectEscalationTemplateDesc clause: ").append(this.getSelectClauseEscalationTemplateDesc());
        stringBuffer.append("\nSelectTaskTemplateDesc clause: ").append(this.getSelectClauseTaskTemplateDesc());
        return stringBuffer.toString();
    }

    protected List executeHTMQuery() throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.resetQueryForTaskTemplateDesc();
        this.resetQueryForEscTemplateDesc();
        QueryResultSet queryResultSet = null;
        String string = this.getSelectClause();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"add escalation and task display name and description to query!");
        }
        string = string + ", " + this.getSelectEscalationDesc();
        string = string + ", " + this.getSelectTaskInstanceDesc();
        String string2 = this.getWhereClause();
        queryResultSet = this.executeGenericHTMQuery(string, string2, this.getOrderClause(), this.getThreshold());
        List list = this.transformToBeans(new QueryResultSetWrapper((Object)queryResultSet));
        Map<String, LocalisedDescEntry> map = this.getEscalationDescValues(queryResultSet);
        Map<String, LocalisedDescEntry> map2 = this.getTaskInstanceDescValues(queryResultSet);
        queryResultSet = null;
        if (this.getLocale() != null) {
            QueryResultSet queryResultSet2 = null;
            QueryResultSet queryResultSet3 = null;
            Map<String, LocalisedDescEntry> map3 = null;
            if (this.getQueryForEscTemplateDesc()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Additional escalation template description query!");
                }
                if ((queryResultSet2 = this.executeEscalationTemplateDescQuery(string2)) != null) {
                    map3 = this.getEscalationTemplateDescValues(queryResultSet2);
                } else if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Escalation template description query returned null!");
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No additional escalation template description query needed!");
            }
            Map<String, LocalisedDescEntry> map4 = null;
            if (this.getQueryForTaskTemplateDesc()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Additional task template description query!");
                }
                if ((queryResultSet3 = this.executeTaskTemplateDescQuery(string2)) != null) {
                    map4 = this.getTaskTemplateDescValues(queryResultSet3);
                } else if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Task template description query returned null!");
                }
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No additional task template description query needed!");
            }
            list = this.addDescValues(list, map, map3, map2, map4);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)("returning " + list.size() + " instances"));
        }
        return list;
    }

    private List addDescValues(List list, Map map, Map map2, Map map3, Map map4) {
        if (list != null) {
            for (EscalationBeanExt escalationBeanExt : list) {
                String string = escalationBeanExt.getID().toString();
                LocalisedDescEntry localisedDescEntry = (LocalisedDescEntry)map.get(string);
                LocalisedDescEntry localisedDescEntry2 = null;
                if (map2 != null) {
                    localisedDescEntry2 = (LocalisedDescEntry)map2.get(string);
                }
                LocalisedDescEntry localisedDescEntry3 = (LocalisedDescEntry)map3.get(string);
                LocalisedDescEntry localisedDescEntry4 = null;
                if (map4 != null) {
                    localisedDescEntry4 = (LocalisedDescEntry)map4.get(string);
                }
                escalationBeanExt = this.addDescValuesToBean(escalationBeanExt, localisedDescEntry, localisedDescEntry2, localisedDescEntry3, localisedDescEntry4);
            }
        }
        return list;
    }

    private EscalationBeanExt addDescValuesToBean(EscalationBeanExt escalationBeanExt, LocalisedDescEntry localisedDescEntry, LocalisedDescEntry localisedDescEntry2, LocalisedDescEntry localisedDescEntry3, LocalisedDescEntry localisedDescEntry4) {
        String string;
        String string2;
        Locale locale = this.getLocale();
        ESTID eSTID = escalationBeanExt.getEscalationTemplateID();
        if (eSTID != null) {
            string2 = eSTID.toString();
            if (localisedDescEntry2 != null) {
                this.addEscTemplateDescriptionToCache(string2, localisedDescEntry2);
            } else {
                localisedDescEntry4 = this.getTaskTemplateDescriptionFromCache(string2);
            }
        }
        if ((string2 = escalationBeanExt.getTaskTemplateID()) != null) {
            string = string2.toString();
            if (localisedDescEntry4 != null) {
                this.addTaskTemplateDescriptionToCache(string, localisedDescEntry4);
            } else {
                localisedDescEntry4 = this.getTaskTemplateDescriptionFromCache(string);
            }
        }
        string = LocalisedDescEntry.getResolvedInstanceDisplayName(localisedDescEntry, localisedDescEntry2);
        String string3 = LocalisedDescEntry.getResolvedInstanceDescription(localisedDescEntry, localisedDescEntry2);
        String string4 = LocalisedDescEntry.getResolvedInstanceDisplayName(localisedDescEntry3, localisedDescEntry4);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Setting localized values for " + escalationBeanExt.getID() + " for locale " + locale.toString() + " -> displayName: " + string + ", description: " + string3 + ", taskDisplayName: " + string4));
        }
        escalationBeanExt.setLocalisedDisplayName(string, locale);
        escalationBeanExt.setLocalisedDescription(string3, locale);
        escalationBeanExt.setLocalisedTaskDisplayName(string4, locale);
        return escalationBeanExt;
    }

    protected Object createBean(QueryResultSetWrapper queryResultSetWrapper) {
        EscalationBeanExt escalationBeanExt = new EscalationBeanExt(queryResultSetWrapper.getHTMQueryResultSet(), this.getConnection(), this.getLocale());
        TKTID tKTID = null;
        tKTID = escalationBeanExt.getTaskTemplateID();
        if (tKTID != null) {
            this.checkDescCacheForTaskTemplate(tKTID.toString());
        }
        ESTID eSTID = null;
        eSTID = escalationBeanExt.getEscalationTemplateID();
        if (eSTID != null) {
            this.checkDescCacheForEscTemplate(eSTID.toString());
        }
        return escalationBeanExt;
    }

    protected OID getID(Object object) {
        return ((EscalationBeanExt)object).getID();
    }
}

