/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.converter;

import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.api.StaffResultSet;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.clientmodel.converter.StaffListConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class StaffResultSetConverter
extends StaffListConverter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    protected static final String NOBODY_KEY = "STAFF.NOBODY";

    public StaffResultSetConverter() {
    }

    public StaffResultSetConverter(String string) {
        super(string);
    }

    public String getAsString(Object object, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)("getAsString(Object obj, Locale l) using locale " + locale.getDisplayName()));
        }
        String string = null;
        StaffResultSet staffResultSet = null;
        if (object instanceof StaffResultSet) {
            staffResultSet = (StaffResultSet)object;
        }
        if (staffResultSet == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("Object is not of type StaffResultSet - " + object.getClass().getName()));
            }
        } else {
            String string2 = null;
            int n = staffResultSet.getResultType();
            if (n == 1) {
                string2 = "STAFF.EVERYBODY";
            }
            if (n == 0) {
                string2 = NOBODY_KEY;
            }
            if (string2 != null) {
                string = LocaleUtils.getLocalizedString((String)string2, (Locale)locale);
                string = string != null ? string : string2;
            } else {
                String[] stringArray;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (n == 3 || n == 5) {
                    stringArray = staffResultSet.getUserIDs();
                    if (stringArray == null || stringArray.length == 0) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"List of userIDs is empty!");
                        }
                    } else {
                        arrayList.addAll(Arrays.asList(stringArray));
                    }
                }
                if (n == 4 || n == 5) {
                    stringArray = staffResultSet.getGroupIDs();
                    if (stringArray == null || stringArray.length == 0) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"List of groupIDs is empty!");
                        }
                    } else {
                        arrayList.addAll(Arrays.asList(stringArray));
                    }
                }
                string = super.getAsString(arrayList, locale);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(">>> staff value is " + string));
        }
        return string;
    }
}

