/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TaskDoesNotExistException;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.WorkItem;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanExt;
import com.ibm.task.clientmodel.command.TaskCommand;
import com.ibm.task.clientmodel.command.TaskRescheduleTimerContext;
import com.ibm.task.clientmodel.exception.TaskIsSuspendedException;
import com.ibm.task.clientmodel.exception.TaskWrongStateAndKindException;
import com.ibm.task.clientmodel.util.TaskTimer;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class TaskRescheduleTimerCommand
extends TaskCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    protected static Set<Integer> EXPECTED_AUTHORIZATIONS = new HashSet<Integer>(5);

    public TaskRescheduleTimerCommand() {
        super("rescheduleTimers", null);
    }

    protected void executeTaskCommand(HumanTaskManagerService humanTaskManagerService, TaskInstanceBean taskInstanceBean) throws TaskException, RemoteException, ClientException {
        block9: {
            TaskRescheduleTimerContext taskRescheduleTimerContext = (TaskRescheduleTimerContext)this.getContext(TaskRescheduleTimerContext.class);
            TaskTimer taskTimer = taskRescheduleTimerContext.getTaskTimer();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("About to call updateTimer()." + (Object)((Object)taskTimer)));
            }
            try {
                taskTimer.updateTimer();
                ((TaskInstanceBeanExt)taskInstanceBean).updateTask();
                if (taskTimer.isTaskReloadable()) {
                    ((TaskInstanceBeanExt)taskInstanceBean).reloadTask();
                }
            }
            catch (RuntimeException runtimeException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)runtimeException);
                }
                if (runtimeException.getCause() == null) break block9;
                Throwable throwable = runtimeException.getCause();
                if (throwable != null) {
                    throwable = throwable.getCause();
                }
                if (throwable != null && throwable instanceof TaskDoesNotExistException) {
                    taskTimer.setTaskReloadable(false);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Task is deleted in the meantime");
                    }
                }
                throw new RuntimeException(runtimeException);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    protected void checkPreconditions(TaskInstanceBean taskInstanceBean, WorkItem[] workItemArray, Locale locale) throws TaskException, TaskIsSuspendedException, TaskWrongStateAndKindException, NotAuthorizedException {
        Assert.assertion((boolean)(taskInstanceBean instanceof TaskInstanceBeanExt), (String)("task must be of type " + TaskInstanceBeanExt.class.getName()));
        boolean bl = false;
        for (int i = 0; i < workItemArray.length; ++i) {
            if (!EXPECTED_AUTHORIZATIONS.contains(workItemArray[i].getAssignmentReason())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new NotAuthorizedException(null);
        }
        if (!((TaskInstanceBeanExt)taskInstanceBean).isTimerChangeable()) {
            if (taskInstanceBean.isSuspended()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action!");
                }
                throw new TaskIsSuspendedException(new Object[]{taskInstanceBean.getDisplayName(locale)});
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action!");
            }
            throw new TaskWrongStateAndKindException(new Object[]{TaskInstanceBean.getConverter("state").getAsString((Object)new Integer(taskInstanceBean.getState()), locale), TaskInstanceBean.getConverter("kind").getAsString((Object)new Integer(taskInstanceBean.getKind()), locale), taskInstanceBean.getName()});
        }
    }

    static {
        EXPECTED_AUTHORIZATIONS.add(new Integer(7));
        EXPECTED_AUTHORIZATIONS.add(new Integer(2));
        EXPECTED_AUTHORIZATIONS.add(new Integer(9));
        EXPECTED_AUTHORIZATIONS.add(new Integer(4));
        EXPECTED_AUTHORIZATIONS.add(new Integer(6));
    }
}

