/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.command.WorkItemContext;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.MissingParameterException;
import com.ibm.bpc.clientcore.exception.MissingParametersException;
import com.ibm.bpc.clientcore.exception.NoObjectsSelectedException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpc.clientcore.util.ClientMessage;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.InheritedAccessRightException;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.WorkItemBeanExt;
import com.ibm.task.clientmodel.command.HTMCommand;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.util.HTMUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskInstanceWorkItemCommand
extends HTMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    private HTMConnection htmConnection;
    private Object context;
    private boolean bulk = false;

    public TaskInstanceWorkItemCommand(boolean bl) {
        this.bulk = bl;
    }

    @Override
    public void setHTMConnection(HTMConnection hTMConnection) {
        this.htmConnection = hTMConnection;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (list == null || list.size() == 0) {
            throw new NoObjectsSelectedException(null);
        }
        WorkItemContext workItemContext = (WorkItemContext)this.getContext(WorkItemContext.class);
        this.checkParameters();
        HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(this.htmConnection);
        Throwable throwable = null;
        HashMap<Object, Exception> hashMap = new HashMap<Object, Exception>();
        ArrayList<ClientMessage> arrayList = new ArrayList<ClientMessage>();
        if (this.bulk) {
            this.executeBulkCommand(humanTaskManagerService, list, hashMap, arrayList);
        } else {
            for (int i = 0; i < list.size(); ++i) {
                throwable = null;
                Object e = list.get(i);
                try {
                    this.executeHTMCommand(humanTaskManagerService, e, arrayList);
                }
                catch (ClientException clientException) {
                    throwable = clientException;
                }
                catch (InheritedAccessRightException inheritedAccessRightException) {
                    throwable = inheritedAccessRightException;
                }
                catch (com.ibm.task.api.NotAuthorizedException notAuthorizedException) {
                    throwable = new NotAuthorizedException(new Object[0], (Throwable)notAuthorizedException);
                }
                catch (TaskException taskException) {
                    throwable = taskException;
                }
                catch (RemoteException remoteException) {
                    throw new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)remoteException);
                }
                catch (EJBException eJBException) {
                    throw new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)eJBException);
                }
                if (throwable == null) continue;
                if (e != null) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)throwable);
                    }
                    if (e instanceof TaskInstanceBean) {
                        hashMap.put(((TaskInstanceBean)e).getID(), (Exception)throwable);
                        continue;
                    }
                    if (!(e instanceof WorkItemBeanExt)) continue;
                    hashMap.put(((WorkItemBeanExt)e).getErrorID(), (Exception)throwable);
                    continue;
                }
                throw new HTMCommandException(new Object[]{this.getClass().getName()}, throwable);
            }
        }
        if (arrayList.size() > 0) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Messages set. List contains: " + arrayList.size() + " entries"));
            }
            workItemContext.setMessages(arrayList);
        }
        if (hashMap.size() != 0) {
            ErrorsInCommandException errorsInCommandException = new ErrorsInCommandException(hashMap);
            throw errorsInCommandException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return null;
    }

    protected void executeBulkCommand(HumanTaskManagerService humanTaskManagerService, List<Object> list, Map<Object, Exception> map, List<ClientMessage> list2) throws ClientException {
        Assert.assertion((boolean)false, (String)"This method should not be called! It needs to be overwritten!");
    }

    protected abstract void executeHTMCommand(HumanTaskManagerService var1, Object var2, List<ClientMessage> var3) throws ClientException, TaskException, RemoteException, EJBException;

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public Object getContext(Class clazz) throws ClientException {
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        if (!clazz.isInstance(this.context)) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), clazz, this.context.getClass()}, null);
        }
        return this.context;
    }

    protected abstract void checkParameters() throws MissingParameterException, MissingParametersException, ClientException;
}

