/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.command.WorkItemContext;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.MissingParameterException;
import com.ibm.bpc.clientcore.exception.MissingParametersException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpc.clientcore.util.ClientMessage;
import com.ibm.bpc.clientcore.util.ClientMessageImpl;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.TaskResult;
import com.ibm.task.clientmodel.bean.WorkItemBean;
import com.ibm.task.clientmodel.bean.WorkItemBeanExt;
import com.ibm.task.clientmodel.command.TaskInstanceWorkItemCommand;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInstanceTransferWorkItemCommand
extends TaskInstanceWorkItemCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public TaskInstanceTransferWorkItemCommand() {
        super(true);
    }

    @Override
    protected void executeBulkCommand(HumanTaskManagerService humanTaskManagerService, List<Object> list, Map<Object, Exception> map, List<ClientMessage> list2) throws ClientException {
        ArrayList<List> arrayList;
        String string;
        List list3;
        Object object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        WorkItemContext workItemContext = (WorkItemContext)this.getContext(WorkItemContext.class);
        HashMap<String, WorkItemBeanExt> hashMap = new HashMap<String, WorkItemBeanExt>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        HashMap<String, ArrayList<List>> hashMap3 = new HashMap<String, ArrayList<List>>();
        HashMap<String, List> hashMap4 = new HashMap<String, List>();
        for (int i = 0; i < list.size(); ++i) {
            Map.Entry entry = list.get(i);
            if (!(entry instanceof WorkItemBeanExt)) {
                throw new WrongTypeForCommandException(new Object[]{this.getClass(), entry.getClass(), WorkItemBeanExt.class});
            }
            object = (WorkItemBeanExt)((Object)entry);
            hashMap.put(((WorkItemBeanExt)object).getErrorID(), (WorkItemBeanExt)object);
            list3 = (TKIID)((WorkItemBean)object).getObjectID();
            int n = ((WorkItemBean)object).getReason();
            String string2 = null;
            if (((WorkItemBean)object).isAssignedToEverybody()) {
                string2 = "EVERYBODY";
            } else {
                string2 = ((WorkItemBean)object).getOwner();
                if (string2 == null) {
                    string2 = ((WorkItemBean)object).getGroupName();
                }
            }
            hashMap2.put(this.getKeyForWorkItemIdMap((TKIID)list3, ((WorkItemBean)object).getReason(), string2), ((WorkItemBeanExt)object).getErrorID());
            string = this.getKeyForTaskIdsMap(n, string2);
            arrayList = (List)hashMap3.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<List>(list.size());
                hashMap3.put(string, arrayList);
            }
            arrayList.add(list3);
            hashMap4.put(list3.toString(), list3);
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            Object object2;
            Object object32;
            object = (String)entry.getKey();
            list3 = (List)entry.getValue();
            TKIID[] tKIIDArray = list3.toArray(new TKIID[0]);
            int n = this.getReasonFromKeyForTaskIdsMap((String)object);
            string = this.getOwnerFromKeyForTaskIdsMap((String)object);
            arrayList = workItemContext.getRecipient();
            List list4 = null;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"About to call bulkTransferWorkItem for selected workitems");
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Calling HumanTaskManagerService.bulkTransferWorkItem(" + tKIIDArray.toString() + ", " + n + ", " + string + ", " + arrayList + ")"));
            }
            try {
                list4 = humanTaskManagerService.bulkTransferWorkItem(tKIIDArray, n, string, (String)((Object)arrayList));
            }
            catch (RemoteException remoteException) {
                throw new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                throw new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)eJBException);
            }
            catch (TaskException taskException) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("Exception from HumanTaskManagerService.bulkTransferWorkItem: " + taskException.getMessage()));
                }
                for (Object object32 : list3) {
                    object2 = this.getKeyForWorkItemIdMap((TKIID)object32, n, string);
                    map.put(hashMap2.get(object2), (Exception)((Object)taskException));
                    arrayList2.add(object32.toString());
                }
            }
            if (list4 != null) {
                for (TaskResult taskResult : list4) {
                    object32 = this.getKeyForWorkItemIdMap(taskResult.getTKIID(), n, string);
                    if (taskResult.getTaskException() == null) continue;
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("Exception for " + (String)object32 + ": " + taskResult.getTaskException().getMessage()));
                    }
                    map.put(hashMap2.get(object32), (Exception)((Object)taskResult.getTaskException()));
                    arrayList2.add(taskResult.getTKIID().toString());
                }
            }
            for (TaskResult taskResult : list3) {
                if (arrayList2.contains(taskResult.toString())) continue;
                object32 = this.getKeyForWorkItemIdMap((TKIID)taskResult, n, string);
                object2 = (WorkItemBeanExt)hashMap.get(hashMap2.get(object32));
                String string3 = ((WorkItemBean)object2).getTaskDisplayName().getString(workItemContext.getLocale());
                list2.add((ClientMessage)new ClientMessageImpl("TASK.WORKITEM.TRANSFERED.MSG", new Object[]{string3, new Integer(n), arrayList}));
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    @Override
    protected void executeHTMCommand(HumanTaskManagerService humanTaskManagerService, Object object, List<ClientMessage> list) throws ClientException, TaskException, RemoteException, EJBException {
        Assert.assertion((boolean)false, (String)"This method should not be called!");
    }

    private String getKeyForWorkItemIdMap(TKIID tKIID, int n, String string) {
        return tKIID.toString() + "@" + n + "@" + string;
    }

    private String getKeyForTaskIdsMap(int n, String string) {
        return n + "@" + string;
    }

    private String getOwnerFromKeyForTaskIdsMap(String string) {
        String string2 = string.substring(string.indexOf("@") + 1);
        return "null".equals(string2) ? null : string2;
    }

    private int getReasonFromKeyForTaskIdsMap(String string) {
        return Integer.parseInt(string.substring(0, string.indexOf("@")));
    }

    @Override
    protected void checkParameters() throws MissingParameterException, MissingParametersException, ClientException {
        WorkItemContext workItemContext = (WorkItemContext)this.getContext(WorkItemContext.class);
        String string = workItemContext.getRecipient();
        if (string == null || string.trim().length() == 0) {
            throw new MissingParameterException(new Object[]{workItemContext.getLabelRecipient()});
        }
    }
}

