/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.MissingParameterException;
import com.ibm.bpc.clientcore.exception.MissingParametersException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpc.clientcore.util.ClientMessage;
import com.ibm.bpc.clientcore.util.ClientMessageImpl;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.bean.WorkItemBean;
import com.ibm.task.clientmodel.command.TaskInstanceWorkItemCommand;
import java.rmi.RemoteException;
import java.util.List;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInstanceDeleteWorkItemCommand
extends TaskInstanceWorkItemCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public TaskInstanceDeleteWorkItemCommand() {
        super(false);
    }

    @Override
    protected void executeHTMCommand(HumanTaskManagerService humanTaskManagerService, Object object, List<ClientMessage> list) throws ClientException, TaskException, RemoteException, EJBException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (!(object instanceof WorkItemBean)) {
            throw new WrongTypeForCommandException(new Object[]{this.getClass(), object.getClass(), WorkItemBean.class});
        }
        WorkItemBean workItemBean = (WorkItemBean)object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("taskInstanceId=" + workItemBean.getObjectID() + ", workItemId=" + workItemBean.getID()));
        }
        String string = null;
        if (workItemBean.isAssignedToEverybody()) {
            string = "EVERYBODY";
        } else {
            string = workItemBean.getOwner();
            if (string == null) {
                string = workItemBean.getGroupName();
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Calling HumanTaskManagerService.deleteWorkItem(" + workItemBean.getObjectID().toString() + ", " + workItemBean.getReason() + ", " + string + ")"));
        }
        humanTaskManagerService.deleteWorkItem(workItemBean.getObjectID().toString(), workItemBean.getReason(), string);
        list.add((ClientMessage)new ClientMessageImpl("TASK.WORKITEM.DELETED.MSG", new Object[]{string, new Integer(workItemBean.getReason())}));
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    @Override
    protected void checkParameters() throws MissingParameterException, MissingParametersException, ClientException {
    }
}

