/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.command.WorkItemCreateContext;
import com.ibm.bpc.clientcore.exception.MissingParameterException;
import com.ibm.bpc.clientcore.exception.MissingParametersException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpc.clientcore.util.ClientMessage;
import com.ibm.bpc.clientcore.util.ClientMessageImpl;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.ObjectDoesNotExistException;
import com.ibm.task.api.TaskDoesNotExistException;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.WrongKindException;
import com.ibm.task.api.WrongStateException;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.command.TaskCommand;
import com.ibm.task.clientmodel.command.TaskInstanceWorkItemCommand;
import com.ibm.task.clientmodel.exception.TaskWrongKindException;
import com.ibm.task.clientmodel.exception.TaskWrongStateException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import javax.ejb.EJBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInstanceCreateWorkItemCommand
extends TaskInstanceWorkItemCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public TaskInstanceCreateWorkItemCommand() {
        super(false);
    }

    @Override
    protected void executeHTMCommand(HumanTaskManagerService humanTaskManagerService, Object object, List<ClientMessage> list) throws ClientException, TaskException, RemoteException, EJBException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        WorkItemCreateContext workItemCreateContext = (WorkItemCreateContext)this.getContext(WorkItemCreateContext.class);
        Locale locale = workItemCreateContext.getLocale();
        if (!(object instanceof TaskInstanceBean)) {
            throw new WrongTypeForCommandException(new Object[]{this.getClass(), object.getClass(), TaskInstanceBean.class});
        }
        TaskInstanceBean taskInstanceBean = (TaskInstanceBean)object;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("taskInstanceId=" + taskInstanceBean.getID()));
        }
        String string = workItemCreateContext.getRecipient();
        List list2 = workItemCreateContext.getReasons();
        for (String string2 : list2) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Calling HumanTaskManagerService.createWorkItem(" + taskInstanceBean.getID().toString() + ", " + string2 + ", " + string + ")"));
            }
            try {
                humanTaskManagerService.createWorkItem(taskInstanceBean.getID(), Integer.valueOf(string2).intValue(), string);
                list.add((ClientMessage)new ClientMessageImpl("TASK.WORKITEM.CREATED.MSG", new Object[]{taskInstanceBean.getDisplayName().getString(locale), string2, string}));
            }
            catch (WrongStateException wrongStateException) {
                throw new TaskWrongStateException(new Object[]{TaskCommand.getStateAsString(taskInstanceBean.getState(), locale), taskInstanceBean.getDisplayName(locale)}, wrongStateException);
            }
            catch (WrongKindException wrongKindException) {
                throw new TaskWrongKindException(new Object[]{TaskCommand.getKindAsString(taskInstanceBean.getKind(), locale), taskInstanceBean.getDisplayName(locale)}, wrongKindException);
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                if (objectDoesNotExistException instanceof TaskDoesNotExistException) {
                    throw new com.ibm.task.clientmodel.exception.TaskDoesNotExistException(new Object[]{taskInstanceBean.getDisplayName(locale)}, objectDoesNotExistException);
                }
                throw objectDoesNotExistException;
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    @Override
    protected void checkParameters() throws MissingParameterException, MissingParametersException, ClientException {
        String string;
        WorkItemCreateContext workItemCreateContext = (WorkItemCreateContext)this.getContext(WorkItemCreateContext.class);
        List list = workItemCreateContext.getReasons();
        boolean bl = false;
        if (list == null || list.size() == 0) {
            bl = true;
        }
        if ((string = workItemCreateContext.getRecipient()) == null || string.trim().length() == 0) {
            if (bl) {
                throw new MissingParametersException(new Object[]{workItemCreateContext.getLabelRecipient() + ", " + workItemCreateContext.getLabelReasons()});
            }
            throw new MissingParameterException(new Object[]{workItemCreateContext.getLabelRecipient()});
        }
        if (bl) {
            throw new MissingParameterException(new Object[]{workItemCreateContext.getLabelReasons()});
        }
    }
}

