/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.CommandContext;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.ObjectDoesNotExistException;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.WrongKindException;
import com.ibm.task.api.WrongStateException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.command.HTMCommand;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.exception.TaskDoesNotExistException;
import com.ibm.task.clientmodel.exception.TaskIsSuspendedException;
import com.ibm.task.clientmodel.exception.TaskWrongKindException;
import com.ibm.task.clientmodel.exception.TaskWrongStateException;
import com.ibm.task.clientmodel.util.HTMUtils;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.EJBException;

public abstract class TaskCommand
extends HTMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private HTMConnection connection;
    private Object context;
    private String apiCallName4Trace = null;
    private String commandClazz = null;
    private String successView = null;

    public TaskCommand(String string, String string2) {
        this.apiCallName4Trace = string;
        this.successView = string2;
        this.commandClazz = this.getClass().getName();
    }

    public void setHTMConnection(HTMConnection hTMConnection) {
        this.connection = hTMConnection;
    }

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public Object getContext(Class clazz) throws ClientException {
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        if (!clazz.isInstance(this.context)) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), clazz, this.context.getClass()}, null);
        }
        return this.context;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.commandClazz);
        }
        this.checkSelectedItems(list);
        HumanTaskManagerService humanTaskManagerService = this.getHumanTaskManagerService();
        HashMap<TKIID, ClientException> hashMap = new HashMap<TKIID, ClientException>();
        for (int i = 0; i < list.size(); ++i) {
            ClientException clientException = null;
            TaskInstanceBean taskInstanceBean = null;
            Object e = list.get(i);
            try {
                taskInstanceBean = (TaskInstanceBean)e;
                this.executeTaskCommand(humanTaskManagerService, taskInstanceBean);
            }
            catch (ClassCastException classCastException) {
                clientException = new WrongTypeForCommandException(new Object[]{this.getClass(), TaskInstanceBean.class, e.getClass().getName()}, (Throwable)classCastException);
            }
            catch (ClientException clientException2) {
                clientException = clientException2;
            }
            catch (com.ibm.task.api.NotAuthorizedException notAuthorizedException) {
                clientException = new NotAuthorizedException(new Object[0], (Throwable)notAuthorizedException);
            }
            catch (com.ibm.task.api.TaskIsSuspendedException taskIsSuspendedException) {
                clientException = new TaskIsSuspendedException(new Object[]{taskInstanceBean.getDisplayName(this.getLocale())}, taskIsSuspendedException);
            }
            catch (WrongStateException wrongStateException) {
                clientException = new TaskWrongStateException(new Object[]{TaskCommand.getStateAsString(taskInstanceBean.getState(), this.getLocale()), taskInstanceBean.getDisplayName(this.getLocale())}, wrongStateException);
            }
            catch (WrongKindException wrongKindException) {
                clientException = new TaskWrongKindException(new Object[]{TaskCommand.getKindAsString(taskInstanceBean.getKind(), this.getLocale()), taskInstanceBean.getDisplayName(this.getLocale())}, wrongKindException);
            }
            catch (ObjectDoesNotExistException objectDoesNotExistException) {
                clientException = new TaskDoesNotExistException(new Object[]{taskInstanceBean.getDisplayName(this.getLocale())}, objectDoesNotExistException);
            }
            catch (TaskException taskException) {
                clientException = new HTMCommandException(new Object[]{this.commandClazz}, taskException);
            }
            catch (RemoteException remoteException) {
                clientException = new CommunicationException(new Object[]{this.commandClazz}, (Throwable)remoteException);
            }
            catch (EJBException eJBException) {
                clientException = new CommunicationException(new Object[]{this.commandClazz}, (Throwable)eJBException);
            }
            if (clientException == null) continue;
            if (taskInstanceBean != null) {
                hashMap.put(taskInstanceBean.getID(), clientException);
                continue;
            }
            throw clientException;
        }
        if (hashMap.size() != 0) {
            ErrorsInCommandException errorsInCommandException = new ErrorsInCommandException(hashMap);
            throw errorsInCommandException;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(this.commandClazz + " - successView=" + this.successView));
        }
        return this.successView;
    }

    public void setSuccessView(String string) {
        this.successView = string;
    }

    public String getSuccessView() {
        return this.successView;
    }

    protected abstract void executeTaskCommand(HumanTaskManagerService var1, TaskInstanceBean var2) throws TaskException, RemoteException, ClientException;

    protected HumanTaskManagerService getHumanTaskManagerService() throws ClientException {
        HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(this.connection);
        return humanTaskManagerService;
    }

    public static String getStateAsString(int n, Locale locale) {
        SimpleConverter simpleConverter = TaskInstanceBean.getConverter("state");
        String string = "";
        if (simpleConverter != null) {
            string = string + simpleConverter.getAsString((Object)new Integer(n), locale);
        }
        return string;
    }

    public static String getKindAsString(int n, Locale locale) {
        SimpleConverter simpleConverter = TaskInstanceBean.getConverter("kind");
        String string = "";
        if (simpleConverter != null) {
            string = string + simpleConverter.getAsString((Object)new Integer(n), locale);
        }
        return string;
    }

    protected Locale getLocale() {
        Locale locale = Locale.getDefault();
        CommandContext commandContext = null;
        if (this.context != null) {
            try {
                commandContext = (CommandContext)this.getContext(CommandContext.class);
            }
            catch (ClientException clientException) {
                // empty catch block
            }
        }
        if (commandContext == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)"Using default locale for localized message parameters because no context available to retrieve client locale!");
            }
        } else {
            locale = commandContext.getLocale();
        }
        return locale;
    }
}

