/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.NotAuthorizedException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.ClientObjectWrapper;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.ObjectDoesNotExistException;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.WrongKindException;
import com.ibm.task.api.WrongStateException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanExt;
import com.ibm.task.clientmodel.bean.TaskTemplateBean;
import com.ibm.task.clientmodel.command.HTMCommand;
import com.ibm.task.clientmodel.command.TaskCommand;
import com.ibm.task.clientmodel.command.TaskMessageContext;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.exception.TaskDoesNotExistException;
import com.ibm.task.clientmodel.exception.TaskInvalidActionException;
import com.ibm.task.clientmodel.exception.TaskWrongKindException;
import com.ibm.task.clientmodel.exception.TaskWrongStateException;
import com.ibm.task.clientmodel.util.HTMUtils;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBException;

public class SubmitTaskInputMessageCommand
extends HTMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    public static final int CREATE_TASK = 0;
    public static final int CREATE_AND_START_TASK = 1;
    public static final int START_TASK = 2;
    protected HTMConnection connection = null;
    Object context = null;
    private String successView = null;

    public SubmitTaskInputMessageCommand() {
        this(null);
    }

    public SubmitTaskInputMessageCommand(String string) {
        this.successView = string;
    }

    public void setHTMConnection(HTMConnection hTMConnection) {
        this.connection = hTMConnection;
    }

    public String execute(List list) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry((Object)this.getClass().getName());
        }
        this.checkSelectedItems(list);
        TaskMessageContext taskMessageContext = (TaskMessageContext)this.getContext(TaskMessageContext.class);
        Object e = list.get(0);
        Assert.assertion((e instanceof TaskInstanceBean || e instanceof TaskTemplateBean ? 1 : 0) != 0, (String)("Expecting " + TaskTemplateBean.class.getName() + " or " + TaskInstanceBean.class.getName()));
        HashMap<Object, ClientException> hashMap = new HashMap<Object, ClientException>();
        ClientException clientException = null;
        TaskTemplateBean taskTemplateBean = null;
        TaskInstanceBean taskInstanceBean = null;
        try {
            HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(this.connection);
            if (e instanceof TaskTemplateBean) {
                taskTemplateBean = (TaskTemplateBean)e;
                this.executeTaskTemplateCommand(humanTaskManagerService, taskTemplateBean);
            } else if (e instanceof TaskInstanceBean) {
                taskInstanceBean = (TaskInstanceBean)e;
                this.executeTaskCommand(humanTaskManagerService, taskInstanceBean);
            }
        }
        catch (ClientException clientException2) {
            clientException = clientException2;
        }
        catch (com.ibm.task.api.NotAuthorizedException notAuthorizedException) {
            clientException = new NotAuthorizedException(new Object[0], (Throwable)notAuthorizedException);
        }
        catch (WrongStateException wrongStateException) {
            clientException = taskInstanceBean != null ? new TaskWrongStateException(new Object[]{TaskCommand.getStateAsString(taskInstanceBean.getState(), taskMessageContext.getLocale()), taskInstanceBean.getDisplayName(taskMessageContext.getLocale())}, wrongStateException) : new HTMCommandException(new Object[]{this.getClass().getName()}, wrongStateException);
        }
        catch (WrongKindException wrongKindException) {
            clientException = taskInstanceBean != null ? new TaskWrongKindException(new Object[]{TaskCommand.getKindAsString(taskInstanceBean.getKind(), taskMessageContext.getLocale()), taskInstanceBean.getDisplayName(taskMessageContext.getLocale())}, wrongKindException) : new HTMCommandException(new Object[]{this.getClass().getName()}, wrongKindException);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            clientException = taskInstanceBean != null ? new TaskDoesNotExistException(new Object[]{taskInstanceBean.getDisplayName(taskMessageContext.getLocale())}, objectDoesNotExistException) : new HTMCommandException(new Object[]{this.getClass().getName()}, objectDoesNotExistException);
        }
        catch (TaskException taskException) {
            clientException = new HTMCommandException(new Object[]{this.getClass().getName()}, taskException);
        }
        catch (RemoteException remoteException) {
            clientException = new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            clientException = new CommunicationException(new Object[]{this.getClass().getName()}, (Throwable)eJBException);
        }
        if (clientException != null) {
            if (taskInstanceBean != null) {
                hashMap.put(taskInstanceBean.getID(), clientException);
            } else if (taskTemplateBean != null) {
                hashMap.put(taskTemplateBean.getID(), clientException);
            } else {
                throw clientException;
            }
            throw new ErrorsInCommandException(hashMap);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit((Object)(this.getClass().getName() + " - successView=" + this.getSuccessView()));
        }
        return this.getSuccessView();
    }

    protected void executeTaskCommand(HumanTaskManagerService humanTaskManagerService, TaskInstanceBean taskInstanceBean) throws TaskException, RemoteException, ClientException {
        TaskMessageContext taskMessageContext;
        MessageWrapper messageWrapper;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ClientObjectWrapper clientObjectWrapper = (messageWrapper = (taskMessageContext = (TaskMessageContext)this.getContext(TaskMessageContext.class)).getInputMessageWrapper()) != null ? new ClientObjectWrapper(messageWrapper.getMessage()) : new ClientObjectWrapper();
        humanTaskManagerService.startTask(taskInstanceBean.getID(), clientObjectWrapper, null);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    protected void executeTaskTemplateCommand(HumanTaskManagerService humanTaskManagerService, TaskTemplateBean taskTemplateBean) throws TaskException, RemoteException, ClientException {
        TaskMessageContext taskMessageContext;
        MessageWrapper messageWrapper;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        ClientObjectWrapper clientObjectWrapper = (messageWrapper = (taskMessageContext = (TaskMessageContext)this.getContext(TaskMessageContext.class)).getInputMessageWrapper()) != null ? new ClientObjectWrapper(messageWrapper.getMessage()) : new ClientObjectWrapper();
        int n = taskMessageContext.getCallMode();
        if (n == 1) {
            humanTaskManagerService.createAndStartTask(taskTemplateBean.getName(), taskTemplateBean.getNamespace(), clientObjectWrapper, null);
        } else if (n == 0) {
            humanTaskManagerService.createTask(taskTemplateBean.getName(), taskTemplateBean.getNamespace(), clientObjectWrapper);
        } else {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("incorrect call mode: " + n));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    protected void checkPreconditions(TaskInstanceBean taskInstanceBean, TaskMessageContext taskMessageContext) throws TaskWrongStateException, TaskInvalidActionException {
        Assert.assertion((boolean)(taskInstanceBean instanceof TaskInstanceBeanExt), (String)("task must be of type " + TaskInstanceBeanExt.class.getName()));
        int n = taskMessageContext.getCallMode();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(taskInstanceBean + " - callMode=" + n));
        }
        if (n == 2 && !((TaskInstanceBeanExt)taskInstanceBean).isActionAvailable(3051)) {
            int n2 = taskInstanceBean.getState();
            if (n2 != 1) {
                throw new TaskWrongStateException(new Object[]{TaskCommand.getStateAsString(n2, taskMessageContext.getLocale()), taskInstanceBean.getDisplayName(taskMessageContext.getLocale())});
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action!");
            }
            throw new TaskInvalidActionException(new Object[]{taskInstanceBean.getDisplayName(taskMessageContext.getLocale())});
        }
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public Object getContext(Class clazz) throws ClientException {
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        if (!clazz.isInstance(this.context)) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), clazz, this.context.getClass()}, null);
        }
        return this.context;
    }

    public String getSuccessView() {
        return this.successView;
    }

    public void setSuccessView(String string) {
        this.successView = string;
    }
}

