/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.ClientObjectWrapper;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TaskException;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanExt;
import com.ibm.task.clientmodel.command.TaskCommand;
import com.ibm.task.clientmodel.command.TaskMessageContext;
import com.ibm.task.clientmodel.exception.TaskInvalidActionException;
import com.ibm.task.clientmodel.exception.TaskWrongStateException;
import java.rmi.RemoteException;

public class RestartTaskCommand
extends TaskCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008, 2009.\n\n";

    public RestartTaskCommand() {
        super("restart", "taskInstanceList");
    }

    public RestartTaskCommand(String string, String string2) {
        super(string, string2);
    }

    protected void executeTaskCommand(HumanTaskManagerService humanTaskManagerService, TaskInstanceBean taskInstanceBean) throws ClientException, TaskException, RemoteException {
        String string = taskInstanceBean.getID().toString();
        TaskMessageContext taskMessageContext = (TaskMessageContext)this.getContext(TaskMessageContext.class);
        this.checkPreconditions(taskInstanceBean, taskMessageContext);
        boolean bl = taskMessageContext.isKeepResultMessages();
        MessageWrapper messageWrapper = taskMessageContext.getInputMessageWrapper();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Restart task: " + string + " keepResultMessages: " + bl));
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Restart task: " + string + " input message: " + messageWrapper.getMessage()));
        }
        humanTaskManagerService.restart(string, new ClientObjectWrapper(messageWrapper.getMessage()), bl);
    }

    public boolean isMultiSelectEnabled() {
        return false;
    }

    protected void checkPreconditions(TaskInstanceBean taskInstanceBean, TaskMessageContext taskMessageContext) throws TaskWrongStateException, TaskInvalidActionException {
        Assert.assertion((boolean)(taskInstanceBean instanceof TaskInstanceBeanExt), (String)("task must be of type " + TaskInstanceBeanExt.class.getName()));
        if (!((TaskInstanceBeanExt)taskInstanceBean).isActionAvailable(3052)) {
            int n = taskInstanceBean.getState();
            int n2 = taskInstanceBean.getKind();
            if (n == 1 || n2 == 103 && n == 3 || n2 == 105 && (n == 5 || n == 6 || n == 7 || n == 12 || n == 2 && taskInstanceBean.isInline())) {
                throw new TaskWrongStateException(new Object[]{TaskCommand.getStateAsString(n, taskMessageContext.getLocale()), taskInstanceBean.getDisplayName(taskMessageContext.getLocale())});
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No reason found for unavailable action, may be due to missing authorization!");
            }
            throw new TaskInvalidActionException(new Object[]{taskInstanceBean.getDisplayName(taskMessageContext.getLocale())});
        }
    }
}

