/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.command;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.exception.ContextNotSetException;
import com.ibm.bpc.clientcore.exception.ErrorsInCommandException;
import com.ibm.bpc.clientcore.exception.GenericCommandBarMessageException;
import com.ibm.bpc.clientcore.exception.InvalidContextException;
import com.ibm.bpc.clientcore.exception.NoObjectsSelectedException;
import com.ibm.bpc.clientcore.exception.WrongTypeForCommandException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.IdWrongFormatException;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.TaskResult;
import com.ibm.task.api.UnexpectedFailureException;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.TaskInstanceBeanExt;
import com.ibm.task.clientmodel.command.HTMCommand;
import com.ibm.task.clientmodel.util.HTMUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBException;

public class CancelClaimTaskCommand
extends HTMCommand {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    private HTMConnection connection;
    private Object context;

    public void setHTMConnection(HTMConnection hTMConnection) {
        this.connection = hTMConnection;
    }

    public String execute(List list) throws ClientException {
        if (list == null || list.size() == 0) {
            throw new NoObjectsSelectedException(null);
        }
        try {
            Object object;
            int n;
            HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(this.connection);
            HashMap<TKIID, TaskException> hashMap = new HashMap<TKIID, TaskException>();
            TKIID[] tKIIDArray = new TKIID[list.size()];
            List list2 = new ArrayList();
            for (n = 0; n < list.size(); ++n) {
                object = list.get(n);
                if (!(object instanceof TaskInstanceBean)) {
                    throw new WrongTypeForCommandException(new Object[]{this.getClass(), object.getClass(), TaskInstanceBean.class});
                }
                TaskInstanceBean taskInstanceBean = (TaskInstanceBean)object;
                tKIIDArray[n] = taskInstanceBean.getID();
            }
            try {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"About to call claim of all selected tasks");
                }
                list2 = humanTaskManagerService.cancelClaim(tKIIDArray);
            }
            catch (UnexpectedFailureException unexpectedFailureException) {
                throw new GenericCommandBarMessageException(new Object[]{"CancelClaimTaskCommand.execute"}, (Throwable)unexpectedFailureException);
            }
            catch (IdWrongFormatException idWrongFormatException) {
                throw new GenericCommandBarMessageException(new Object[]{"CancelClaimTaskCommand.execute"}, (Throwable)idWrongFormatException);
            }
            if (list2 != null) {
                for (n = 0; n < list2.size(); ++n) {
                    object = (TaskResult)list2.get(n);
                    if (object.getTaskException() != null) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)object.getTaskException());
                        }
                        hashMap.put(object.getTKIID(), object.getTaskException());
                        continue;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        TaskInstanceBean taskInstanceBean = (TaskInstanceBean)e;
                        if (!taskInstanceBean.getID().toString().equals(object.getTKIID().toString())) continue;
                        taskInstanceBean.setState(new Integer(2));
                        if (!(taskInstanceBean instanceof TaskInstanceBeanExt)) continue;
                        ((TaskInstanceBeanExt)taskInstanceBean).setOwner(null);
                    }
                }
            }
            if (hashMap.size() != 0) {
                ErrorsInCommandException errorsInCommandException = new ErrorsInCommandException(hashMap);
                throw errorsInCommandException;
            }
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{"HumanTaskManagerService.cancelClaimTaskCommand(...)"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{"HumanTaskManagerService.cancelClaimTaskCommand(...)"}, (Throwable)eJBException);
        }
        return null;
    }

    public void setContext(Object object) {
        this.context = object;
    }

    public boolean isMultiSelectEnabled() {
        return true;
    }

    public boolean[] isApplicable(List list) {
        return null;
    }

    public Object getContext(Class clazz) throws ClientException {
        if (this.context == null) {
            throw new ContextNotSetException(new Object[]{this.getClass()});
        }
        if (!clazz.isInstance(this.context)) {
            throw new InvalidContextException(new Object[]{this.context.getClass(), clazz, this.context.getClass()}, null);
        }
        return this.context;
    }
}

