/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.bean;

import com.ibm.bpc.clientcore.converter.BooleanConverter;
import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.LocalisedStringConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.LocalisedString;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.WIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TKTID;
import com.ibm.task.api.Task;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.converter.WorkItemReasonConverter;
import com.ibm.task.clientmodel.util.LocalisedDisplayName;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class WorkItemBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    private static Map labels = new HashMap();
    private static Map converters = new HashMap();
    public static final String CREATIONTIME_PROPERTY = "creationTime";
    public static final String CREATIONIME_PROPERTY = "creationTime";
    public static final String ID_PROPERTY = "ID";
    public static final String OBJECTID_PROPERTY = "objectID";
    public static final String OBJECTTYPE_PROPERTY = "objectType";
    public static final String OWNER_PROPERTY = "owner";
    public static final String REASON_PROPERTY = "reason";
    public static final String ASSIGNEDTOEVERYBODY_PROPERTY = "assignedToEverybody";
    public static final String TASKNAME_PROPERTY = "taskName";
    public static final String TASKDISPLAYNAME_PROPERTY = "taskDisplayName";
    public static final String GROUPNAME_PROPERTY = "groupName";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private HTMConnection connection;
    private WIID workitemID = null;
    private long creationTime;
    private boolean creationTimeSet = false;
    private Boolean assignedToEverybody = null;
    private OID objectID = null;
    private int objectType;
    private String owner = null;
    private int reason;
    private TKIID taskID = null;
    private String taskName = null;
    private String groupName = null;
    private LocalisedDisplayName localisedTaskDisplayName = null;
    private Locale initialLocale = null;
    private Task task = null;
    private byte[] tktid = null;
    boolean tktidSet = false;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)((String)labels.get(string)), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public WorkItemBean(QueryResultSet queryResultSet, HTMConnection hTMConnection) {
        this(queryResultSet, hTMConnection, Locale.getDefault());
    }

    public WorkItemBean(QueryResultSet queryResultSet, HTMConnection hTMConnection, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (queryResultSet == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Parameter resultSet is null, returning directly from constructor.");
            }
        } else {
            Long l = null;
            byte[] byArray = null;
            for (int i = 1; i <= queryResultSet.numberColumns(); ++i) {
                String string = queryResultSet.getTableDisplayName(i);
                String string2 = queryResultSet.getColumnDisplayName(i);
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Analyzing: (" + string + "," + string2 + ")"));
                }
                if (string.equalsIgnoreCase("WORK_ITEM")) {
                    if (string2.equalsIgnoreCase("WIID")) {
                        this.workitemID = (WIID)queryResultSet.getOID(i);
                    } else if (string2.equalsIgnoreCase("CREATION_TIME")) {
                        l = queryResultSet.getTimestampAsLong(i);
                        if (l != null) {
                            this.creationTime = l;
                            this.creationTimeSet = true;
                        }
                    } else if (string2.equalsIgnoreCase("EVERYBODY")) {
                        this.assignedToEverybody = queryResultSet.getBoolean(i);
                    } else if (string2.equalsIgnoreCase("OBJECT_ID")) {
                        this.objectID = queryResultSet.getOID(i);
                    } else if (string2.equalsIgnoreCase("OBJECT_TYPE")) {
                        this.objectType = queryResultSet.getInteger(i);
                    } else if (string2.equalsIgnoreCase("OWNER_ID")) {
                        this.owner = queryResultSet.getString(i);
                    } else if (string2.equalsIgnoreCase("REASON")) {
                        this.reason = queryResultSet.getInteger(i);
                    } else if (string2.equalsIgnoreCase("GROUP_NAME")) {
                        this.groupName = queryResultSet.getString(i);
                    }
                }
                if (!string.equalsIgnoreCase("TASK")) continue;
                if (string2.equalsIgnoreCase("NAME")) {
                    this.taskName = queryResultSet.getString(i);
                    continue;
                }
                if (string2.equalsIgnoreCase("TKIID")) {
                    this.taskID = (TKIID)queryResultSet.getOID(i);
                    continue;
                }
                if (!string2.equalsIgnoreCase("TKTID") || (byArray = queryResultSet.getBinary(i)) == null) continue;
                this.tktid = byArray;
                this.tktidSet = true;
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)this.toString());
            }
        }
        this.connection = hTMConnection;
        this.initialLocale = locale;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
    }

    private TKIID getTaskID() {
        if (this.taskID == null) {
            TKIID tKIID = this.taskID = this.objectID instanceof TKIID ? (TKIID)this.objectID : null;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieved taskID from ObjectID: " + this.taskID));
            }
        }
        return this.taskID;
    }

    private Task getTask() {
        if (this.task == null) {
            try {
                HumanTaskManagerService humanTaskManagerService = this.connection.getHumanTaskManagerService();
                this.task = humanTaskManagerService.getTask(this.getTaskID());
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving original for " + this.getTaskID()));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not load original data from TKIID " + this.getTaskID(), exception);
            }
        }
        return this.task;
    }

    public TKTID getTaskTemplateID() {
        if (this.tktidSet && this.task == null) {
            return (TKTID)TaskInstanceBean.convertByteToOID(this.tktid);
        }
        return this.getTask().getTaskTemplateID();
    }

    public Calendar getCreationTime() {
        if (this.creationTimeSet) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.creationTime);
            return calendar;
        }
        return null;
    }

    public WIID getID() {
        return this.workitemID;
    }

    public OID getObjectID() {
        return this.objectID;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public void setLocalisedDisplayName(String string, Locale locale) {
        this.localisedTaskDisplayName = new LocalisedTaskDisplayName(string, locale);
    }

    public LocalisedString getTaskDisplayName() {
        if (this.localisedTaskDisplayName == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"No taskDisplayName!");
            }
            this.localisedTaskDisplayName = new LocalisedTaskDisplayName(null, this.initialLocale);
        }
        return this.localisedTaskDisplayName;
    }

    public String getTaskDisplayName(Locale locale) {
        return this.getTaskDisplayName().getString(locale);
    }

    public String getTaskName() {
        if (this.taskName == null) {
            this.taskName = this.getTask().getName();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieved taskName from Task: " + this.taskName));
            }
        }
        return this.taskName;
    }

    public String getOwner() {
        return this.owner;
    }

    public int getReason() {
        return this.reason;
    }

    public boolean isAssignedToEverybody() {
        if (this.assignedToEverybody != null) {
            return this.assignedToEverybody;
        }
        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"WORK_ITEM.EVERYBODY not set.");
        return false;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setAssignedToEverybody(boolean bl) {
        this.assignedToEverybody = new Boolean(bl);
    }

    public void setCreationTime(Calendar calendar) {
        if (calendar != null) {
            this.creationTime = calendar.getTimeInMillis();
            this.creationTimeSet = true;
        } else {
            this.creationTimeSet = false;
        }
    }

    public void setID(WIID wIID) {
        this.workitemID = wIID;
    }

    public void setObjectID(OID oID) {
        this.objectID = oID;
    }

    public void setObjectType(int n) {
        this.objectType = n;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setReason(int n) {
        this.reason = n;
    }

    public String toString() {
        String string = "WorkItemBean [";
        string = string + "(id: " + this.workitemID + "), ";
        string = string + "(creationTime: + " + this.creationTime + ")";
        string = string + ("(assignedToEverybody: + " + this.assignedToEverybody != null ? this.assignedToEverybody.toString() : null + ")");
        string = string + "(objectId: + " + this.objectID + "), ";
        string = string + "(objectType: + " + this.objectType + "), ";
        string = string + "(owner: " + this.owner + "), ";
        string = string + "(reason: " + this.reason + "), ";
        string = string + "(groupName: + " + this.groupName + ")";
        string = string + "(taskID: + " + this.taskID + "), ";
        string = string + "(taskName: + " + this.taskName + "), ";
        string = string + "(localisedTaskDisplayName: + " + this.localisedTaskDisplayName + "), ";
        string = string + "]";
        return string;
    }

    static {
        labels.put(ID_PROPERTY, "WORKITEM.ID");
        labels.put(REASON_PROPERTY, "WORKITEM.REASON");
        labels.put(OBJECTID_PROPERTY, "WORKITEM.OBJECTID");
        labels.put(OBJECTTYPE_PROPERTY, "WORKITEM.OBJECTTYPE");
        labels.put("creationTime", "WORKITEM.CREATIONTIME");
        labels.put(OWNER_PROPERTY, "WORKITEM.OWNER");
        labels.put(ASSIGNEDTOEVERYBODY_PROPERTY, "STAFF.EVERYBODY");
        labels.put(TASKNAME_PROPERTY, "TASK.NAME");
        labels.put(TASKDISPLAYNAME_PROPERTY, "TASK.NAME");
        labels.put(GROUPNAME_PROPERTY, "WORKITEM.GROUP.WORK.LIST");
        converters.put("creationTime", new CalendarConverter());
        converters.put(REASON_PROPERTY, new WorkItemReasonConverter());
        converters.put(ASSIGNEDTOEVERYBODY_PROPERTY, new BooleanConverter());
        converters.put(TASKDISPLAYNAME_PROPERTY, new LocalisedStringConverter());
    }

    private class LocalisedTaskDisplayName
    extends LocalisedDisplayName {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";

        public LocalisedTaskDisplayName(String string, Locale locale) {
            super(string, locale);
        }

        protected String getDisplayName(Locale locale) {
            return WorkItemBean.this.getTask().getDisplayName(locale);
        }

        protected String getName() {
            return WorkItemBean.this.getTaskName();
        }

        protected List getLocalesOfDisplayNames() {
            return WorkItemBean.this.getTask().getLocalesOfDisplayNames();
        }
    }
}

