/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.MessageWrapper;
import com.ibm.bpc.clientcore.converter.BooleanConverter;
import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.LocalisedStringConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.converter.SupportedConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.ClientUIHelper;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.LocalisedString;
import com.ibm.bpc.clientcore.util.MessageWrapperImpl;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.ACOID;
import com.ibm.task.api.ClientObjectWrapper;
import com.ibm.task.api.CustomClientSettings;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.JspLocation;
import com.ibm.task.api.JspUsageEnum;
import com.ibm.task.api.TKTID;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.TaskTemplate;
import com.ibm.task.api.WebClientSetting;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.converter.TaskInstanceKindConverter;
import com.ibm.task.clientmodel.converter.TaskTemplateDeletionModeConverter;
import com.ibm.task.clientmodel.converter.TaskTemplateDurationConverter;
import com.ibm.task.clientmodel.converter.TaskTemplateStateConverter;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.util.HTMUtils;
import com.ibm.task.clientmodel.util.LocalisedDescription;
import com.ibm.task.clientmodel.util.LocalisedDisplayName;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ejb.EJBException;

public class TaskTemplateBean
implements TaskTemplate {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    private static Map converters = new HashMap();
    private static Map labels = new HashMap();
    private HTMConnection connection;
    private TaskTemplate original;
    private MessageWrapper inputMessage = null;
    public static final String APPLICATIONDEFAULTSID_PROPERTY = "applicationDefaultsID";
    public static final String APPLICATIONNAME_PROPERTY = "applicationName";
    public static final String AUTODELETIONMODE_PROPERTY = "autoDeletionMode";
    public static final String ASSIGNMENTTYPE_PROPERTY = "assignmentType";
    public static final String INHERITEDAUTHORIZATION_PROPERTY = "inheritedAuthorization";
    public static final String CALENDARNAME_PROPERTY = "calendarName";
    public static final String CONTAINMENTCONTEXTID_PROPERTY = "containmentContextID";
    public static final String CONTEXTAUTHORIZATIONOFOWNER_PROPERTY = "contextAuthorizationOfOwner";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String DISPLAYNAME_PROPERTY = "displayName";
    public static final String DURATIONUNTILDELETED_PROPERTY = "durationUntilDeleted";
    public static final String DURATIONUNTILDUE_PROPERTY = "durationUntilDue";
    public static final String DURATIONUNTILEXPIRES_PROPERTY = "durationUntilExpires";
    public static final String ESCALATIONTEMPLATEIDS_PROPERTY = "escalationTemplateIDs";
    public static final String EVENTHANDLERNAME_PROPERTY = "eventHandlerName";
    public static final String ID_PROPERTY = "ID";
    public static final String JNDINAMEOFCALENDAR_PROPERTY = "JNDINameOfCalendar";
    public static final String JNDINAMEOFSTAFFPLUGINPROVIDER_PROPERTY = "JNDINameOfStaffPluginProvider";
    public static final String KIND_PROPERTY = "kind";
    public static final String NAME_PROPERTY = "name";
    public static final String NAMESPACE_PROPERTY = "namespace";
    public static final String DEFINITIONNAME_PROPERTY = "definitionName";
    public static final String DEFINITIONNAMESPACE_PROPERTY = "definitionNamespace";
    public static final String PRIORITY_PROPERTY = "priority";
    public static final String PRIORITY_DEFINITION_PROPERTY = "priorityDefinition";
    public static final String TYPE_PROPERTY = "type";
    public static final String VALIDFROMTIME_PROPERTY = "validFromTime";
    public static final String ADHOC_PROPERTY = "adHoc";
    public static final String BUSINESSRELEVANT_PROPERTY = "businessRelevant";
    public static final String SUPPORTSAUTOMATICCLAIM_PROPERTY = "supportsAutomaticClaim";
    public static final String SUPPORTSCLAIMIFSUSPENDED_PROPERTY = "supportsClaimIfSuspended";
    public static final String SUPPORTSDELEGATION_PROPERTY = "supportsDelegation";
    public static final String SUPPORTSSUBTASKS_PROPERTY = "supportsSubTasks";
    public static final String SUPPORTSFOLLOWONTASKS_PROPERTY = "supportsFollowOnTasks";
    public static final String STATE_PROPERTY = "state";
    public static final String SUBSTITUTIONPOLICY_PROPERTY = "substitutionPolicy";
    public static String INLINE_PROPERTY = "inline";
    public static final String WORKBASKETNAME_PROPERTY = "workBasketName";

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)((String)labels.get(string)), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public TaskTemplateBean(TaskTemplate taskTemplate, HTMConnection hTMConnection) {
        this.original = taskTemplate;
        this.connection = hTMConnection;
        Assert.assertion((this.original != null ? 1 : 0) != 0, (String)"original != null");
    }

    public ACOID getApplicationDefaultsID() {
        return this.original.getApplicationDefaultsID();
    }

    public String getApplicationName() {
        return this.original.getApplicationName();
    }

    public String getWorkBasketName() {
        return this.original.getWorkBasketName();
    }

    public int getAutoDeletionMode() {
        String string = this.getDurationUntilDeleted();
        if (string != null) {
            if (string.equals("DURATION_INFINITE")) {
                return 0;
            }
            return this.original.getAutoDeletionMode();
        }
        if (this.isInline()) {
            return 0;
        }
        if (this.getKind() == 105) {
            return this.original.getAutoDeletionMode();
        }
        return 0;
    }

    public int getAssignmentType() {
        return this.original.getAssignmentType();
    }

    public int getInheritedAuthorization() {
        return this.original.getInheritedAuthorization();
    }

    public String getCalendarName() {
        return this.original.getCalendarName();
    }

    public OID getContainmentContextID() {
        return this.original.getContainmentContextID();
    }

    public int getContextAuthorizationOfOwner() {
        return this.original.getContextAuthorizationOfOwner();
    }

    public String getDescription(Locale locale) {
        return this.original.getDescription(locale);
    }

    public LocalisedString getDescription() {
        return new LocalisedTaskTemplateDescription();
    }

    public String getDisplayName(Locale locale) {
        if (this.original.getDisplayName(locale) != null) {
            return this.original.getDisplayName(locale);
        }
        return this.original.getName();
    }

    public LocalisedString getDisplayName() {
        return new LocalisedTaskTemplateDisplayName();
    }

    public String getDurationUntilDeleted() {
        return this.original.getDurationUntilDeleted();
    }

    public String getDurationUntilDue() {
        return this.original.getDurationUntilDue();
    }

    public String getDurationUntilExpires() {
        return this.original.getDurationUntilExpires();
    }

    public String getEventHandlerName() {
        return this.original.getEventHandlerName();
    }

    public TKTID getID() {
        return this.original.getID();
    }

    public String getJNDINameOfCalendar() {
        return this.original.getJNDINameOfCalendar();
    }

    public String getJNDINameOfStaffPluginProvider() {
        return this.original.getJNDINameOfStaffPluginProvider();
    }

    public int getKind() {
        return this.original.getKind();
    }

    public List getLocalesOfDescriptions() {
        return this.original.getLocalesOfDescriptions();
    }

    public List getLocalesOfDisplayNames() {
        return this.original.getLocalesOfDisplayNames();
    }

    public String getName() {
        return this.original.getName();
    }

    public String getNamespace() {
        return this.original.getNamespace();
    }

    public String getDefinitionName() {
        return this.original.getDefinitionName();
    }

    public String getDefinitionNamespace() {
        return this.original.getDefinitionNamespace();
    }

    public Integer getPriority() {
        return this.original.getPriority();
    }

    public String getPriorityDefinition() {
        return this.original.getPriorityDefinition();
    }

    public int getState() {
        return this.original.getState();
    }

    public int getAutonomy() {
        return this.original.getAutonomy();
    }

    public int getSubstitutionPolicy() {
        return this.original.getSubstitutionPolicy();
    }

    public String getType() {
        return this.original.getType();
    }

    public Calendar getValidFromTime() {
        return this.original.getValidFromTime();
    }

    public boolean isAdHoc() {
        return this.original.isAdHoc();
    }

    public boolean isBusinessRelevant() {
        return this.original.isBusinessRelevant();
    }

    public boolean supportsAutomaticClaim() {
        return this.original.supportsAutomaticClaim();
    }

    public boolean supportsClaimIfSuspended() {
        return this.original.supportsClaimIfSuspended();
    }

    public boolean supportsDelegation() {
        return this.original.supportsDelegation();
    }

    public boolean supportsSubTasks() {
        return this.original.supportsSubTasks();
    }

    public boolean supportsFollowOnTasks() {
        return this.original.supportsFollowOnTasks();
    }

    public boolean isSupportsAutomaticClaim() {
        return this.original.supportsAutomaticClaim();
    }

    public boolean isSupportsClaimIfSuspended() {
        return this.original.supportsClaimIfSuspended();
    }

    public boolean isSupportsDelegation() {
        return this.original.supportsDelegation();
    }

    public boolean isSupportsSubTasks() {
        return this.original.supportsSubTasks();
    }

    public boolean isSupportsFollowOnTasks() {
        return this.original.supportsFollowOnTasks();
    }

    public boolean isInline() {
        return this.original.isInline();
    }

    public MessageWrapper getInputMessageWrapper() throws ClientException {
        MessageWrapperImpl messageWrapperImpl = new MessageWrapperImpl(this.getApplicationName());
        try {
            HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(this.connection);
            ClientObjectWrapper clientObjectWrapper = humanTaskManagerService.createInputMessage(this.getID());
            if (clientObjectWrapper != null) {
                if (BPCClientTrace.isTracing && clientObjectWrapper.getObject() == null) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"ClientObjectWrapper contained no data!");
                }
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
                this.inputMessage = messageWrapperImpl;
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"HumanTaskManagerService.createMessage returned null!");
            }
            if (clientObjectWrapper != null) {
                messageWrapperImpl.setMessage(clientObjectWrapper.getObject());
                if (ClientUIHelper.getWebClientType() != null) {
                    JspLocation jspLocation;
                    CustomClientSettings customClientSettings = humanTaskManagerService.getUISettings(this.getID());
                    WebClientSetting webClientSetting = customClientSettings != null ? customClientSettings.getWebClientSetting(ClientUIHelper.getWebClientType()) : null;
                    JspLocation jspLocation2 = jspLocation = webClientSetting != null ? ClientUIHelper.getJspLocationForParticipatingInterface((JspUsageEnum)JspUsageEnum.INPUT, (WebClientSetting)webClientSetting) : null;
                    if (jspLocation != null) {
                        messageWrapperImpl.setContextRoot(jspLocation.getContextRoot());
                        messageWrapperImpl.setUrl(jspLocation.getUriAsString());
                    }
                }
            }
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"HumanTaskService.getInputMessage"}, (Throwable)remoteException);
        }
        catch (TaskException taskException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)taskException);
            }
            throw new HTMCommandException(new Object[]{"HumanTaskService.callWithUISettings"}, taskException);
        }
        catch (EJBException eJBException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)eJBException);
            }
            throw new CommunicationException(new Object[]{"HumanTaskService.getInputMessage"}, (Throwable)eJBException);
        }
        return this.inputMessage;
    }

    static {
        labels.put(APPLICATIONDEFAULTSID_PROPERTY, "TASK.TEMPLATE.APPLICATIONDEFAULTSID");
        labels.put(APPLICATIONNAME_PROPERTY, "TASK.TEMPLATE.APPLICATIONNAME");
        labels.put(AUTODELETIONMODE_PROPERTY, "TASK.TEMPLATE.AUTODELETIONMODE");
        labels.put(ASSIGNMENTTYPE_PROPERTY, "TASK.TEMPLATE.ASSIGNMENTTYPE");
        labels.put(INHERITEDAUTHORIZATION_PROPERTY, "TASK.TEMPLATE.INHERITEDAUTHORIZATION");
        labels.put(CALENDARNAME_PROPERTY, "TASK.TEMPLATE.CALENDARNAME");
        labels.put(CONTAINMENTCONTEXTID_PROPERTY, "TASK.TEMPLATE.CONTAINMENTCONTEXTID");
        labels.put(CONTEXTAUTHORIZATIONOFOWNER_PROPERTY, "TASK.TEMPLATE.CONTEXTAUTHORIZATIONOFOWNER");
        labels.put(DESCRIPTION_PROPERTY, "TASK.TEMPLATE.DESCRIPTION");
        labels.put(DISPLAYNAME_PROPERTY, "TASK.TEMPLATE.NAME");
        labels.put(DURATIONUNTILDELETED_PROPERTY, "TASK.TEMPLATE.DURATIONUNTILDELETED");
        labels.put(DURATIONUNTILDUE_PROPERTY, "TASK.TEMPLATE.DURATIONUNTILDUE");
        labels.put(DURATIONUNTILEXPIRES_PROPERTY, "TASK.TEMPLATE.DURATIONUNTILEXPIRES");
        labels.put(ESCALATIONTEMPLATEIDS_PROPERTY, "TASK.TEMPLATE.ESCALATIONTEMPLATEIDS");
        labels.put(EVENTHANDLERNAME_PROPERTY, "TASK.TEMPLATE.EVENTHANDLERNAME");
        labels.put(ID_PROPERTY, "TASK.TEMPLATE.ID");
        labels.put(JNDINAMEOFCALENDAR_PROPERTY, "TASK.TEMPLATE.JNDINAMEOFCALENDAR");
        labels.put(JNDINAMEOFSTAFFPLUGINPROVIDER_PROPERTY, "TASK.TEMPLATE.JNDINAMEOFSTAFFPLUGINPROVIDER");
        labels.put(KIND_PROPERTY, "TASK.TEMPLATE.KIND");
        labels.put(NAME_PROPERTY, "TASK.TEMPLATE.NAME");
        labels.put(NAMESPACE_PROPERTY, "TASK.TEMPLATE.NAMESPACE");
        labels.put(DEFINITIONNAME_PROPERTY, "TASK.TEMPLATE.DEFINITIONNAME");
        labels.put(DEFINITIONNAMESPACE_PROPERTY, "TASK.TEMPLATE.DEFINITIONNAMESPACE");
        labels.put(PRIORITY_PROPERTY, "TASK.TEMPLATE.PRIORITY");
        labels.put(PRIORITY_DEFINITION_PROPERTY, "TASK.TEMPLATE.PRIORITYDEFINITION");
        labels.put(TYPE_PROPERTY, "TASK.TEMPLATE.BUSINESS.CATEGORY");
        labels.put(VALIDFROMTIME_PROPERTY, "TASK.TEMPLATE.VALIDFROMTIME");
        labels.put(ADHOC_PROPERTY, "TASK.TEMPLATE.ADHOC");
        labels.put(BUSINESSRELEVANT_PROPERTY, "TASK.TEMPLATE.BUSINESSRELEVANT");
        labels.put(SUPPORTSAUTOMATICCLAIM_PROPERTY, "TASK.TEMPLATE.SUPPORTSAUTOMATICCLAIM");
        labels.put(SUPPORTSCLAIMIFSUSPENDED_PROPERTY, "TASK.TEMPLATE.SUPPORTSCLAIMIFSUSPENDED");
        labels.put(SUPPORTSDELEGATION_PROPERTY, "TASK.TEMPLATE.SUPPORTSDELEGATION");
        labels.put(SUPPORTSSUBTASKS_PROPERTY, "TASK.TEMPLATE.SUPPORTSSUBTASKS");
        labels.put(SUPPORTSFOLLOWONTASKS_PROPERTY, "TASK.TEMPLATE.SUPPORTSFOLLOWONTASKS");
        labels.put(STATE_PROPERTY, "PROCESS.TEMPLATE.STATE");
        labels.put(INLINE_PROPERTY, "TASK.TEMPLATE.INLINE");
        labels.put(SUBSTITUTIONPOLICY_PROPERTY, "PROCESS.TEMPLATE.SUBSTITUTIONPOLICY");
        labels.put(WORKBASKETNAME_PROPERTY, "TASK.TEMPLATE.WORKBASKETNAME");
        converters.put(VALIDFROMTIME_PROPERTY, new CalendarConverter());
        converters.put(KIND_PROPERTY, new TaskInstanceKindConverter());
        converters.put(DISPLAYNAME_PROPERTY, new LocalisedStringConverter());
        converters.put(DESCRIPTION_PROPERTY, new LocalisedStringConverter());
        converters.put(ADHOC_PROPERTY, new BooleanConverter());
        converters.put(BUSINESSRELEVANT_PROPERTY, new BooleanConverter());
        converters.put(SUPPORTSAUTOMATICCLAIM_PROPERTY, new SupportedConverter());
        converters.put(SUPPORTSCLAIMIFSUSPENDED_PROPERTY, new SupportedConverter());
        converters.put(SUPPORTSDELEGATION_PROPERTY, new SupportedConverter());
        converters.put(SUPPORTSSUBTASKS_PROPERTY, new SupportedConverter());
        converters.put(SUPPORTSFOLLOWONTASKS_PROPERTY, new SupportedConverter());
        converters.put(STATE_PROPERTY, new TaskTemplateStateConverter());
        converters.put(DURATIONUNTILDELETED_PROPERTY, new TaskTemplateDurationConverter());
        converters.put(DURATIONUNTILDUE_PROPERTY, new TaskTemplateDurationConverter());
        converters.put(DURATIONUNTILEXPIRES_PROPERTY, new TaskTemplateDurationConverter());
        converters.put(AUTODELETIONMODE_PROPERTY, new TaskTemplateDeletionModeConverter());
        converters.put(INLINE_PROPERTY, new BooleanConverter());
    }

    private class LocalisedTaskTemplateDisplayName
    extends LocalisedDisplayName {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006.\n\n";

        private LocalisedTaskTemplateDisplayName() {
        }

        protected String getDisplayName(Locale locale) {
            return TaskTemplateBean.this.original.getDisplayName(locale);
        }

        protected String getName() {
            return TaskTemplateBean.this.original.getName();
        }

        protected List getLocalesOfDisplayNames() {
            return TaskTemplateBean.this.original.getLocalesOfDisplayNames();
        }
    }

    private class LocalisedTaskTemplateDescription
    extends LocalisedDescription {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

        private LocalisedTaskTemplateDescription() {
        }

        protected String getDescription(Locale locale) {
            return TaskTemplateBean.this.original.getDescription(locale);
        }

        protected List getLocalesOfDescriptions() {
            return TaskTemplateBean.this.original.getLocalesOfDescriptions();
        }
    }
}

