/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.bean;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpc.clientcore.util.FieldMapCreator;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.LocalisedString;
import com.ibm.bpe.api.EIID;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TKTID;
import com.ibm.task.api.Task;
import com.ibm.task.api.TaskActions;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.TaskTemplate;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.bean.TaskTemplateBean;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import com.ibm.task.clientmodel.util.HTMUtils;
import com.ibm.task.clientmodel.util.LocalisedDisplayName;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TaskInstanceBeanExt
extends TaskInstanceBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2004, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    public static Map<String, String> propertyNameToDBMap = new HashMap<String, String>();
    private Locale initialLocale;
    private boolean shortcut = false;
    private String owner;
    private boolean ownerSet = false;
    private LocalisedDisplayName localisedTaskTemplateDisplayName = null;
    public static final String TABLE_NAME_DESC = "TASK_DESC";
    public static final String TABLE_NAME = "TASK";
    private static Map<Integer, String> actionNames;
    private List<Integer> availableActions = null;

    public static SimpleConverter getConverter(String string) {
        return TaskInstanceBean.getConverter(string);
    }

    public static String getLabel(String string) {
        return TaskInstanceBean.getLabel(string);
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)TaskInstanceBeanExt.getLabel(string), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = TaskInstanceBeanExt.getLabel(string) != null;
        return bl;
    }

    public static ColumnInfo getColumnInfo(String string, String string2) {
        if (TaskInstanceBeanExt.isValid(string)) {
            return new ColumnInfo(string, TaskInstanceBeanExt.getLabel(string), (Object)TaskInstanceBeanExt.getConverter(string), string2);
        }
        return null;
    }

    public TaskInstanceBeanExt(QueryResultSet queryResultSet, HTMConnection hTMConnection) {
        this(queryResultSet, hTMConnection, Locale.getDefault());
    }

    public TaskInstanceBeanExt(QueryResultSet queryResultSet, HTMConnection hTMConnection, Locale locale) {
        super(queryResultSet, hTMConnection, locale);
        this.setHTMConnection(hTMConnection);
        this.initialLocale = locale;
    }

    public TaskInstanceBeanExt(Task task, HTMConnection hTMConnection) {
        this(task, hTMConnection, Locale.getDefault());
    }

    public TaskInstanceBeanExt(Task task, HTMConnection hTMConnection, Locale locale) {
        super(task, hTMConnection);
        this.setHTMConnection(hTMConnection);
        this.initialLocale = locale;
    }

    public HTMConnection getConnection() {
        return super.getHTMConnection();
    }

    public void setConnection(HTMConnection hTMConnection) {
        super.setHTMConnection(hTMConnection);
    }

    public String getOwner() {
        if (this.ownerSet && this.shortcut) {
            return this.owner;
        }
        return super.getOwner();
    }

    public void setOwner(String string) {
        this.owner = string;
        this.ownerSet = true;
        this.shortcut = true;
    }

    public OID getParentContextID() {
        OID oID = super.getParentContextID();
        if (oID != null && oID instanceof EIID) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"EIID set to null.");
            }
            oID = null;
        }
        return oID;
    }

    public void setLocalisedTaskTemplateDisplayName(String string, Locale locale) {
        this.localisedTaskTemplateDisplayName = new LocalisedTaskTemplateDisplayName(string, locale);
    }

    public LocalisedString getTaskTemplateDisplayName() {
        if (this.localisedTaskTemplateDisplayName == null) {
            this.localisedTaskTemplateDisplayName = new LocalisedTaskTemplateDisplayName(null, this.initialLocale);
        }
        return this.localisedTaskTemplateDisplayName;
    }

    public String getTaskTemplateDisplayName(Locale locale) {
        return this.getTaskTemplateDisplayName().getString(locale);
    }

    public boolean isActionAvailable(int n) {
        boolean bl = false;
        if (this.availableActions == null) {
            block6: {
                try {
                    int[] nArray = HTMUtils.getHumanTaskManagerService(this.getConnection()).getAvailableActions(this.getID());
                    this.availableActions = new ArrayList<Integer>(nArray.length);
                    for (int i = 0; i < nArray.length; ++i) {
                        this.availableActions.add(nArray[i]);
                    }
                }
                catch (Exception exception) {
                    if (!BPCClientTrace.isTracing) break block6;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("No actions retrieved\n" + exception));
                }
            }
            actionNames = FieldMapCreator.createKeyMap(TaskActions.class, (String)"", (String)"");
        }
        if (this.availableActions != null) {
            boolean bl2 = bl = this.availableActions.indexOf(new Integer(n)) > -1;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Action " + actionNames.get(new Integer(n)) + " available: " + Boolean.toString(bl)));
            }
        }
        return bl;
    }

    public void resetAvailableActions() {
        actionNames = null;
        this.availableActions = null;
    }

    public boolean isTimerChangeable() {
        return this.isDurationUntilDeletedUpdateable() || this.isDurationUntilDueUpdateable() || this.isDurationUntilExpiresUpdateable() || this.isDeletionTimeUpdateable() || this.isDueTimeUpdateable() || this.isExpirationTimeUpdateable();
    }

    public void reloadTask() {
        this.setOriginal(null);
        this.getOriginal();
    }

    public void updateTask() throws ClientException {
        try {
            HumanTaskManagerService humanTaskManagerService = HTMUtils.getHumanTaskManagerService(this.getConnection());
            humanTaskManagerService.update(this.getOriginal());
        }
        catch (RemoteException remoteException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)remoteException);
            }
            throw new CommunicationException(new Object[]{"HumanTaskService.getOutputMessage"}, (Throwable)remoteException);
        }
        catch (TaskException taskException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (Throwable)taskException);
            }
            throw new HTMCommandException(new Object[]{"HumanTaskService.update"}, taskException);
        }
    }

    static {
        propertyNameToDBMap.put("ID", "TASK.TKIID");
        propertyNameToDBMap.put("activationTime", "TASK.ACTIVATED");
        propertyNameToDBMap.put("containmentContextID", "TASK.CONTAINMENT_CTX_ID");
        propertyNameToDBMap.put("completionTime", "TASK.COMPLETED");
        propertyNameToDBMap.put("dueTime", "TASK.DUE");
        propertyNameToDBMap.put("expirationTime", "TASK.EXPIRES");
        propertyNameToDBMap.put("state", "TASK.STATE");
        propertyNameToDBMap.put("firstActivationTime", "TASK.FIRST_ACTIVATED");
        propertyNameToDBMap.put("lastModificationTime", "TASK.LAST_MODIFIED");
        propertyNameToDBMap.put("lastStateChangeTime", "TASK.LAST_STATE_CHANGE");
        propertyNameToDBMap.put("namespace", "TASK.NAME_SPACE");
        propertyNameToDBMap.put("originator", "TASK.ORIGINATOR");
        propertyNameToDBMap.put("owner", "TASK.OWNER");
        propertyNameToDBMap.put("parentContextID", "TASK.PARENT_CONTEXT_ID");
        propertyNameToDBMap.put("priority", "TASK.PRIORITY");
        propertyNameToDBMap.put("startTime", "TASK.STARTED");
        propertyNameToDBMap.put("starter", "TASK.STARTER");
        propertyNameToDBMap.put("positionInHierarchy", "TASK.HIERARCHY_POSITION");
        propertyNameToDBMap.put("type", "TASK.TYPE");
        propertyNameToDBMap.put("applicationName", "TASK.APPLIC_NAME");
        actionNames = null;
    }

    private class LocalisedTaskTemplateDisplayName
    extends LocalisedDisplayName {
        TaskTemplateBean taskTemplateBean;

        public LocalisedTaskTemplateDisplayName(String string, Locale locale) {
            super(string, locale);
            this.taskTemplateBean = null;
        }

        private TaskTemplateBean getTaskTemplateBean() {
            block4: {
                if (this.taskTemplateBean == null) {
                    try {
                        TKTID tKTID = TaskInstanceBeanExt.this.getTaskTemplateID();
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving template bean for " + tKTID));
                        }
                        this.taskTemplateBean = new TaskTemplateBean((TaskTemplate)TaskInstanceBeanExt.this.getConnection().retrieve((OID)tKTID), TaskInstanceBeanExt.this.getConnection());
                    }
                    catch (Exception exception) {
                        if (!BPCClientTrace.isTracing) break block4;
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)exception);
                    }
                }
            }
            return this.taskTemplateBean;
        }

        protected String getDisplayName(Locale locale) {
            String string = null;
            TaskTemplateBean taskTemplateBean = this.getTaskTemplateBean();
            if (taskTemplateBean != null) {
                string = taskTemplateBean.getDisplayName(locale);
            }
            return string;
        }

        protected String getName() {
            String string = null;
            TaskTemplateBean taskTemplateBean = this.getTaskTemplateBean();
            if (taskTemplateBean != null) {
                string = taskTemplateBean.getName();
            }
            return string;
        }

        protected List getLocalesOfDisplayNames() {
            List list = null;
            TaskTemplateBean taskTemplateBean = this.getTaskTemplateBean();
            if (taskTemplateBean != null) {
                list = taskTemplateBean.getLocalesOfDisplayNames();
            }
            return list;
        }
    }
}

