/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.bean;

import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.converter.LocalisedStringConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.LocalisedString;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.Escalation;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.Task;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.EscalationBean;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.util.LocalisedDescription;
import com.ibm.task.clientmodel.util.LocalisedDisplayName;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EscalationBeanExt
extends EscalationBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    public static final String TABLE_NAME = "ESCALATION";
    public static final String TABLE_NAME_TEMPL = "ESC_TEMPL";
    public static final String TABLE_NAME_DESC = "ESCALATION_DESC";
    public static final String TABLE_NAME_TEMPL_DESC = "ESC_TEMPL_DESC";
    public static final String ID_COLUMN_NAME = "ESIID";
    public static Map<String, String> propertyNameToDBMap = new HashMap<String, String>();
    private static Map<String, LocalisedStringConverter> converters;
    private static final long serialVersionUID = 1L;
    private static Map<String, String> labels;
    public static final String TASK_NAME_PROPERTY = "taskName";
    public static final String TASK_DISPLAYNAME_PROPERTY = "taskDisplayName";
    public static final String DISPLAYNAME_PROPERTY = "displayName";
    private HTMConnection connection;
    private Locale initialLocale = null;
    private Escalation escalation = null;
    private LocalisedDisplayName localisedDisplayName;
    private LocalisedDescription localisedDescription;
    private LocalisedTaskDisplayName localisedTaskDisplayName;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = EscalationBean.getConverter(string);
        if (simpleConverter == null) {
            simpleConverter = (SimpleConverter)converters.get(string);
        }
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = EscalationBean.getLabel(string);
        if (string2 == null) {
            string2 = labels.get(string);
        }
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)EscalationBeanExt.getLabel(string), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = EscalationBeanExt.getLabel(string) != null;
        return bl;
    }

    public static ColumnInfo getColumnInfo(String string, String string2) {
        if (EscalationBeanExt.isValid(string)) {
            return new ColumnInfo(string, EscalationBeanExt.getLabel(string), (Object)EscalationBeanExt.getConverter(string), string2);
        }
        return null;
    }

    public EscalationBeanExt(QueryResultSet queryResultSet, HTMConnection hTMConnection) {
        this(queryResultSet, hTMConnection, Locale.getDefault());
    }

    public EscalationBeanExt(QueryResultSet queryResultSet, HTMConnection hTMConnection, Locale locale) {
        super(queryResultSet, hTMConnection);
        this.connection = hTMConnection;
        this.initialLocale = locale;
    }

    public EscalationBeanExt(Escalation escalation, HTMConnection hTMConnection) {
        this(escalation, hTMConnection, Locale.getDefault());
    }

    public EscalationBeanExt(Escalation escalation, HTMConnection hTMConnection, Locale locale) {
        super(escalation, hTMConnection);
        this.escalation = escalation;
        this.connection = hTMConnection;
        this.initialLocale = locale;
    }

    public HTMConnection getConnection() {
        return this.connection;
    }

    private Escalation getOriginal() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.escalation != null) {
            return this.escalation;
        }
        try {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving original for " + this.getID()));
            }
            HumanTaskManagerService humanTaskManagerService = this.connection.getHumanTaskManagerService();
            this.escalation = humanTaskManagerService.getEscalation(this.getID());
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load original data from ESIID " + this.getID(), exception);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return this.escalation;
    }

    public void setLocalisedDescription(String string, Locale locale) {
        this.localisedDescription = new LocalisedEscalationDescription(string, locale);
    }

    public void setLocalisedDisplayName(String string, Locale locale) {
        this.localisedDisplayName = new LocalisedEscalationDisplayName(string, locale);
    }

    public void setLocalisedTaskDisplayName(String string, Locale locale) {
        this.localisedTaskDisplayName = new LocalisedTaskDisplayName(string, locale);
    }

    public LocalisedString getDescription() {
        if (this.localisedDescription == null) {
            this.localisedDescription = new LocalisedEscalationDescription(null, Locale.getDefault());
        }
        return this.localisedDescription;
    }

    public LocalisedString getDisplayName() {
        if (this.localisedDisplayName == null) {
            this.localisedDisplayName = new LocalisedEscalationDisplayName(null, Locale.getDefault());
        }
        return this.localisedDisplayName;
    }

    public LocalisedString getTaskDisplayName() {
        if (this.localisedTaskDisplayName == null) {
            this.localisedTaskDisplayName = new LocalisedTaskDisplayName(null, this.initialLocale);
        }
        return this.localisedTaskDisplayName;
    }

    public String getTaskDisplayName(Locale locale) {
        return this.getTaskDisplayName().getString(locale);
    }

    static {
        propertyNameToDBMap.put("firstEscalationID", "ESCALATION.FIRST_ESIID");
        propertyNameToDBMap.put("activationTime", "ESCALATION.ACTIVATION_TIME");
        converters = new HashMap<String, LocalisedStringConverter>();
        labels = new HashMap<String, String>();
        labels.put(TASK_NAME_PROPERTY, "ESCALATION.TASK_NAME");
        labels.put(TASK_DISPLAYNAME_PROPERTY, "ESCALATION.TASK_NAME");
        converters.put(TASK_DISPLAYNAME_PROPERTY, new LocalisedStringConverter());
    }

    private class LocalisedTaskDisplayName
    extends LocalisedDisplayName {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006.\n\n";
        private TaskInstanceBean taskInstanceBean;

        public LocalisedTaskDisplayName(String string, Locale locale) {
            super(string, locale);
            this.taskInstanceBean = null;
        }

        private TaskInstanceBean getTaskInstanceBean() {
            block4: {
                if (this.taskInstanceBean == null) {
                    try {
                        TKIID tKIID = EscalationBeanExt.this.getTaskInstanceID();
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving instance bean for " + tKIID));
                        }
                        this.taskInstanceBean = new TaskInstanceBean((Task)EscalationBeanExt.this.getConnection().retrieve((OID)tKIID), EscalationBeanExt.this.getConnection());
                    }
                    catch (Exception exception) {
                        if (!BPCClientTrace.isTracing) break block4;
                        BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)exception);
                    }
                }
            }
            return this.taskInstanceBean;
        }

        protected String getDisplayName(Locale locale) {
            String string = null;
            TaskInstanceBean taskInstanceBean = this.getTaskInstanceBean();
            if (taskInstanceBean != null) {
                string = taskInstanceBean.getDisplayName(locale);
            }
            return string;
        }

        protected String getName() {
            String string = null;
            TaskInstanceBean taskInstanceBean = this.getTaskInstanceBean();
            if (taskInstanceBean != null) {
                string = taskInstanceBean.getName();
            }
            return string;
        }

        protected List getLocalesOfDisplayNames() {
            List list = null;
            TaskInstanceBean taskInstanceBean = this.getTaskInstanceBean();
            if (taskInstanceBean != null) {
                list = taskInstanceBean.getLocalesOfDisplayNames();
            }
            return list;
        }
    }

    private class LocalisedEscalationDisplayName
    extends LocalisedDisplayName {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006.\n\n";

        public LocalisedEscalationDisplayName(String string, Locale locale) {
            super(string, locale);
        }

        protected String getDisplayName(Locale locale) {
            return EscalationBeanExt.this.getOriginal().getDisplayName(locale);
        }

        protected String getName() {
            return EscalationBeanExt.this.getOriginal().getName();
        }

        protected List getLocalesOfDisplayNames() {
            return EscalationBeanExt.this.getOriginal().getLocalesOfDisplayNames();
        }
    }

    private class LocalisedEscalationDescription
    extends LocalisedDescription {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006.\n\n";

        public LocalisedEscalationDescription(String string, Locale locale) {
            super(string, locale);
        }

        protected String getDescription(Locale locale) {
            return EscalationBeanExt.this.getOriginal().getDescription(locale);
        }

        protected List getLocalesOfDescriptions() {
            return EscalationBeanExt.this.getOriginal().getLocalesOfDescriptions();
        }
    }
}

