/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel.bean;

import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.LocalisedStringConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.LocalisedString;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.ESIID;
import com.ibm.task.api.ESTID;
import com.ibm.task.api.Escalation;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.QueryResultSet;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TKTID;
import com.ibm.task.api.Task;
import com.ibm.task.api.WorkItem;
import com.ibm.task.clientmodel.HTMConnection;
import com.ibm.task.clientmodel.bean.TaskInstanceBean;
import com.ibm.task.clientmodel.converter.EscalationActionConverter;
import com.ibm.task.clientmodel.converter.EscalationActivationStateConverter;
import com.ibm.task.clientmodel.converter.EscalationAtLeastExpectedStateConverter;
import com.ibm.task.clientmodel.converter.EscalationIncreasePriorityConverter;
import com.ibm.task.clientmodel.converter.EscalationStateConverter;
import com.ibm.task.clientmodel.converter.SimpleStaffConverter;
import com.ibm.task.clientmodel.util.HTMUtils;
import com.ibm.task.clientmodel.util.LocalisedDescription;
import com.ibm.task.clientmodel.util.LocalisedDisplayName;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class EscalationBean
implements Escalation {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    private static final long serialVersionUID = 1L;
    private static Map converters = new HashMap();
    private static Map labels = new HashMap();
    public static final String ACTION_PROPERTY = "action";
    public static final String ACTIVATIONSTATE_PROPERTY = "activationState";
    public static final String ACTIVATIONTIME_PROPERTY = "activationTime";
    public static final String ATLEASTEXPECTEDSTATE_PROPERTY = "atLeastExpectedState";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String NAME_PROPERTY = "name";
    public static final String DURATIONUNTILESCALATED_PROPERTY = "durationUntilEscalated";
    public static final String DURATIONUNTILREPEATED_PROPERTY = "durationUntilRepeated";
    public static final String PRIORITY_INCREASE_PROPERTY = "priorityIncrease";
    public static final String STATE_PROPERTY = "state";
    public static final String TASK_OWNER_PROPERTY = "taskOwner";
    public static final String ESCALATION_RECEIVER_PROPERTY = "escalationReceiver";
    public static final String FIRST_ESCALATION_ID_PROPERTY = "firstEscalationID";
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private HTMConnection connection;
    private ESIID id;
    private Integer action;
    boolean actionSet = false;
    private Integer activationState;
    boolean activationStateSet = false;
    private long activationTime;
    boolean activationTimeSet = false;
    private Integer atLeastExpectedState;
    boolean atLeastExpectedStateSet = false;
    private Integer priorityIncrease;
    boolean priorityIncreaseSet = false;
    private String name;
    boolean nameSet = false;
    private Integer state;
    boolean stateSet = false;
    private TKIID tkiid;
    boolean tkiidSet = false;
    private byte[] tktid;
    boolean tktidSet = false;
    private String taskName;
    boolean taskNameSet = false;
    private String taskOwner;
    boolean taskOwnerSet = false;
    private Boolean escalationReceiverEverybody;
    boolean escalationReceiverEverybodySet = false;
    private String escalationReceiver;
    boolean escalationReceiverSet = false;
    private LocalisedDisplayName localisedDisplayName;
    private LocalisedDescription localisedDescription;
    private Escalation escalation = null;
    private Task taskInstance = null;

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)((String)labels.get(string)), (Locale)locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public EscalationBean(QueryResultSet queryResultSet, HTMConnection hTMConnection) {
        this.connection = hTMConnection;
        int n = queryResultSet.numberColumns();
        for (int i = 1; i <= n; ++i) {
            String string = queryResultSet.getTableDisplayName(i);
            String string2 = queryResultSet.getColumnDisplayName(i);
            byte[] byArray = null;
            Long l = null;
            if (string.equalsIgnoreCase("ESCALATION")) {
                if (string2.equalsIgnoreCase("ESIID")) {
                    this.id = (ESIID)queryResultSet.getOID(i);
                }
                if (string2.equalsIgnoreCase("ACTION")) {
                    this.action = queryResultSet.getInteger(i);
                    this.actionSet = true;
                }
                if (string2.equalsIgnoreCase("ACTIVATION_STATE")) {
                    this.activationState = queryResultSet.getInteger(i);
                    this.activationStateSet = true;
                }
                if (string2.equalsIgnoreCase("ACTIVATION_TIME") && (l = queryResultSet.getTimestampAsLong(i)) != null) {
                    this.activationTime = l;
                    this.activationTimeSet = true;
                }
                if (string2.equalsIgnoreCase("AT_LEAST_EXP_STATE")) {
                    this.atLeastExpectedState = queryResultSet.getInteger(i);
                    this.atLeastExpectedStateSet = true;
                }
                if (string2.equalsIgnoreCase("NAME")) {
                    this.name = queryResultSet.getString(i);
                    this.nameSet = true;
                }
                if (string2.equalsIgnoreCase("INCREASE_PRIORITY")) {
                    this.priorityIncrease = queryResultSet.getInteger(i);
                    this.priorityIncreaseSet = true;
                }
                if (string2.equalsIgnoreCase("STATE")) {
                    this.state = queryResultSet.getInteger(i);
                    this.stateSet = true;
                }
                if (!string2.equalsIgnoreCase("TKIID")) continue;
                this.tkiid = (TKIID)queryResultSet.getOID(i);
                this.tkiidSet = true;
                continue;
            }
            if (string.equalsIgnoreCase("TASK")) {
                if (string2.equalsIgnoreCase("NAME")) {
                    this.taskName = queryResultSet.getString(i);
                    this.taskNameSet = true;
                }
                if (string2.equalsIgnoreCase("OWNER")) {
                    this.taskOwner = queryResultSet.getString(i);
                    this.taskOwnerSet = true;
                }
                if (!string2.equalsIgnoreCase("TKTID") || (byArray = queryResultSet.getBinary(i)) == null) continue;
                this.tktid = byArray;
                this.tktidSet = true;
                continue;
            }
            if (!string.equalsIgnoreCase("WORK_ITEM")) continue;
            if (string2.equalsIgnoreCase("OWNER_ID")) {
                this.escalationReceiver = queryResultSet.getString(i);
                this.escalationReceiverSet = true;
            }
            if (!string2.equalsIgnoreCase("EVERYBODY")) continue;
            this.escalationReceiverEverybody = queryResultSet.getBoolean(i);
            this.escalationReceiverEverybodySet = true;
        }
    }

    public EscalationBean(Escalation escalation, HTMConnection hTMConnection) {
        this.escalation = escalation;
        this.id = escalation.getID();
        this.connection = hTMConnection;
    }

    public int getAction() {
        if (this.actionSet && this.escalation == null) {
            return this.action;
        }
        return this.getOriginal().getAction();
    }

    public int getActivationState() {
        if (this.activationStateSet && this.escalation == null) {
            return this.activationState;
        }
        return this.getOriginal().getActivationState();
    }

    public Calendar getActivationTime() {
        if (this.activationTimeSet && this.escalation == null) {
            Calendar calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.activationTime);
            return calendar;
        }
        return this.getOriginal().getActivationTime();
    }

    public int getAtLeastExpectedState() {
        if (this.atLeastExpectedStateSet && this.escalation == null) {
            return this.atLeastExpectedState;
        }
        return this.getOriginal().getAtLeastExpectedState();
    }

    public OID getContainmentContextID() {
        return this.getOriginal().getContainmentContextID();
    }

    public LocalisedString getDescription() {
        if (this.localisedDescription == null) {
            this.localisedDescription = new LocalisedEscalationDescription(null, Locale.getDefault());
        }
        return this.localisedDescription;
    }

    public String getDescription(Locale locale) {
        return this.getDescription().getString(locale);
    }

    public LocalisedString getDisplayName() {
        if (this.localisedDisplayName == null) {
            this.localisedDisplayName = new LocalisedEscalationDisplayName(null, Locale.getDefault());
        }
        return this.localisedDisplayName;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName().getString(locale);
    }

    public String getDurationUntilEscalated() {
        return this.getOriginal().getDurationUntilEscalated();
    }

    public String getDurationUntilRepeated() {
        return this.getOriginal().getDurationUntilRepeated();
    }

    public String getEscalationReceiver() {
        if (!(this.escalationReceiverSet && this.escalationReceiver != null || this.escalationReceiverEverybodySet && this.escalationReceiverEverybody != null)) {
            block2: for (int i = 1; i <= 2 && !this.escalationReceiverSet && !this.escalationReceiverEverybodySet; ++i) {
                try {
                    WorkItem[] workItemArray = null;
                    if (i == 1) {
                        workItemArray = HTMUtils.getHumanTaskManagerService(this.connection).getAllWorkItems(this.id);
                    }
                    if (i == 2 || workItemArray == null || workItemArray.length == 0) {
                        workItemArray = HTMUtils.getHumanTaskManagerService(this.connection).getWorkItems(this.id);
                    }
                    for (int j = 0; j < workItemArray.length; ++j) {
                        WorkItem workItem = workItemArray[j];
                        if (10 != workItem.getAssignmentReason()) continue;
                        if (workItem.getIsAssignedToEverybody()) {
                            this.escalationReceiverEverybody = new Boolean(true);
                            this.escalationReceiverEverybodySet = true;
                            continue block2;
                        }
                        String string = null;
                        if (workItem.getOwnerID() != null) {
                            string = workItem.getOwnerID();
                        } else if (workItem.getGroupName() != null) {
                            string = workItem.getGroupName();
                        }
                        if (string == null) continue;
                        if (this.escalationReceiver != null && this.escalationReceiver.length() > 0) {
                            this.escalationReceiver = this.escalationReceiver + ", ";
                        } else {
                            this.escalationReceiver = "";
                            this.escalationReceiverSet = true;
                        }
                        this.escalationReceiver = this.escalationReceiver + string;
                    }
                    continue;
                }
                catch (Exception exception) {
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_EVENT, (String)("No work items retrieved! " + exception.getMessage()));
                }
            }
        }
        if (this.escalationReceiverSet && this.escalationReceiver != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)this.escalationReceiver);
            }
            return this.escalationReceiver;
        }
        if (this.escalationReceiverEverybodySet && this.escalationReceiverEverybody != null && this.escalationReceiverEverybody.booleanValue()) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Everybody");
            }
            return "";
        }
        return null;
    }

    public ESTID getEscalationTemplateID() {
        return this.getOriginal().getEscalationTemplateID();
    }

    public ESIID getFirstEscalationID() {
        return this.getOriginal().getFirstEscalationID();
    }

    public ESIID getID() {
        if (this.escalation != null) {
            return this.escalation.getID();
        }
        if (this.id != null) {
            return this.id;
        }
        return null;
    }

    public List getLocalesOfDescriptions() {
        return this.getOriginal().getLocalesOfDescriptions();
    }

    public List getLocalesOfDisplayNames() {
        return this.getOriginal().getLocalesOfDisplayNames();
    }

    public String getName() {
        if (this.nameSet && this.escalation == null) {
            return this.name;
        }
        return this.getOriginal().getName();
    }

    public ESIID getNextEscalationID() {
        return this.getOriginal().getNextEscalationID();
    }

    private Escalation getOriginal() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.escalation != null) {
            return this.escalation;
        }
        try {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving original for " + this.id));
            }
            HumanTaskManagerService humanTaskManagerService = this.connection.getHumanTaskManagerService();
            this.escalation = humanTaskManagerService.getEscalation(this.id);
            this.taskInstance = null;
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load original data from ESIID " + this.id, exception);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return this.escalation;
    }

    public ESIID getPreviousEscalationID() {
        return this.getOriginal().getPreviousEscalationID();
    }

    public int getPriorityIncrease() {
        if (this.priorityIncreaseSet && this.escalation == null) {
            return this.priorityIncrease;
        }
        return this.getOriginal().getPriorityIncrease();
    }

    public int getState() {
        if (this.stateSet && this.escalation == null) {
            return this.state;
        }
        return this.getOriginal().getState();
    }

    private Task getTask() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.taskInstance != null) {
            return this.taskInstance;
        }
        Escalation escalation = this.getOriginal();
        TKIID tKIID = escalation.getTaskInstanceID();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Retrieving original for " + tKIID));
        }
        try {
            this.taskInstance = (Task)this.connection.retrieve((OID)tKIID);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load Task(" + tKIID + ") from ESIID " + this.id, exception);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return this.taskInstance;
    }

    public TKIID getTaskInstanceID() {
        if (this.tkiidSet && this.escalation == null) {
            return this.tkiid;
        }
        return this.getOriginal().getTaskInstanceID();
    }

    public TKTID getTaskTemplateID() {
        if (this.tktidSet && this.taskInstance == null) {
            return (TKTID)TaskInstanceBean.convertByteToOID(this.tktid);
        }
        return this.getTask().getTaskTemplateID();
    }

    public String getTaskName() {
        if (this.taskNameSet && this.taskInstance == null) {
            return this.taskName;
        }
        return this.getTask().getName();
    }

    public String getTaskOwner() {
        if (this.taskOwnerSet && this.taskInstance == null) {
            return this.taskOwner;
        }
        return this.getTask().getOwner();
    }

    public void setName(String string) {
        this.getOriginal().setName(string);
    }

    public boolean isNameUpdateable() {
        return this.getOriginal().isNameUpdateable();
    }

    public Calendar getEscalationTime() {
        return this.getOriginal().getEscalationTime();
    }

    public void setEscalationTime(Calendar calendar) {
        this.getOriginal().setEscalationTime(calendar);
    }

    public boolean isEscalationTimeUpdateable() {
        return this.getOriginal().isEscalationTimeUpdateable();
    }

    public void setDurationUntilEscalated(String string) {
        this.getOriginal().setDurationUntilEscalated(string);
    }

    public boolean isDurationUntilEscalatedUpdateable() {
        return this.getOriginal().isDurationUntilEscalatedUpdateable();
    }

    public void setDurationUntilRepeated(String string) {
        this.getOriginal().setDurationUntilRepeated(string);
    }

    public boolean isDurationUntilRepeatedUpdateable() {
        return this.getOriginal().isDurationUntilRepeatedUpdateable();
    }

    static {
        labels.put(ACTION_PROPERTY, "ESCALATION.ACTION");
        labels.put(ACTIVATIONSTATE_PROPERTY, "ESCALATION.ACTIVATION_STATE");
        labels.put(ACTIVATIONTIME_PROPERTY, "ESCALATION.ACTIVATION_TIME");
        labels.put(ATLEASTEXPECTEDSTATE_PROPERTY, "ESCALATION.AT_LEAST_EXPECTED_STATE");
        labels.put(DESCRIPTION_PROPERTY, "ESCALATION.DESCRIPTION");
        labels.put("displayName", "ESCALATION.NAME");
        labels.put(DURATIONUNTILESCALATED_PROPERTY, "ESCALATION.DURATION_UNTIL_ESCALATED");
        labels.put(DURATIONUNTILREPEATED_PROPERTY, "ESCALATION.DURATION_UNTIL_REPEATED");
        labels.put(NAME_PROPERTY, "ESCALATION.NAME");
        labels.put(PRIORITY_INCREASE_PROPERTY, "ESCALATION.PRIORITY_INCREASE");
        labels.put(STATE_PROPERTY, "ESCALATION.STATE");
        labels.put(TASK_OWNER_PROPERTY, "ESCALATION.TASK_OWNER");
        labels.put(ESCALATION_RECEIVER_PROPERTY, "ESCALATION.ESCALATION_RECEIVER");
        labels.put(FIRST_ESCALATION_ID_PROPERTY, "ESCALATION.FIRST_ESCALATION_ID");
        converters.put(ACTION_PROPERTY, new EscalationActionConverter());
        converters.put(ACTIVATIONSTATE_PROPERTY, new EscalationActivationStateConverter());
        converters.put(ACTIVATIONTIME_PROPERTY, new CalendarConverter());
        converters.put(ATLEASTEXPECTEDSTATE_PROPERTY, new EscalationAtLeastExpectedStateConverter());
        converters.put(PRIORITY_INCREASE_PROPERTY, new EscalationIncreasePriorityConverter());
        converters.put(STATE_PROPERTY, new EscalationStateConverter());
        converters.put(DESCRIPTION_PROPERTY, new LocalisedStringConverter());
        converters.put("displayName", new LocalisedStringConverter());
        converters.put(ESCALATION_RECEIVER_PROPERTY, new SimpleStaffConverter());
    }

    private class LocalisedEscalationDisplayName
    extends LocalisedDisplayName {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006.\n\n";

        public LocalisedEscalationDisplayName(String string, Locale locale) {
            super(string, locale);
        }

        protected String getDisplayName(Locale locale) {
            return EscalationBean.this.getOriginal().getDisplayName(locale);
        }

        protected String getName() {
            return EscalationBean.this.getOriginal().getName();
        }

        protected List getLocalesOfDisplayNames() {
            return EscalationBean.this.getOriginal().getLocalesOfDisplayNames();
        }
    }

    private class LocalisedEscalationDescription
    extends LocalisedDescription {
        public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006,2007.\n\n";

        public LocalisedEscalationDescription(String string, Locale locale) {
            super(string, locale);
        }

        protected String getDescription(Locale locale) {
            return EscalationBean.this.getOriginal().getDescription(locale);
        }

        protected List getLocalesOfDescriptions() {
            return EscalationBean.this.getOriginal().getLocalesOfDescriptions();
        }
    }
}

