/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.task.clientmodel;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.ESIID;
import com.ibm.task.api.Escalation;
import com.ibm.task.api.HumanTaskManagerHome;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.LocalHumanTaskManagerHome;
import com.ibm.task.api.TKIID;
import com.ibm.task.api.TKTID;
import com.ibm.task.api.Task;
import com.ibm.task.api.TaskException;
import com.ibm.task.api.TaskTemplate;
import com.ibm.task.clientmodel.exception.HTMCommandException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class HTMConnection {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    private Context context;
    private HumanTaskManagerHome taskHome;
    private LocalHumanTaskManagerHome localHumanTaskManagerHome;
    private String providerURL = null;
    private String jndiName = "com/ibm/task/api/TaskManagerHome";
    private Boolean isConfiguredForRemoteEJB = Boolean.FALSE;
    private Boolean isObserverConfigured = Boolean.FALSE;

    public String getProviderURL() {
        return this.providerURL;
    }

    public void setProviderURL(String string) {
        this.providerURL = string;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
    }

    public void setRemote(String string) {
        this.isConfiguredForRemoteEJB = Boolean.valueOf(string);
    }

    public String getRemote() {
        return this.isConfiguredForRemoteEJB.toString();
    }

    public Boolean getObserver() {
        return this.isObserverConfigured;
    }

    public void setObserver(Boolean bl) {
        this.isObserverConfigured = bl;
    }

    private Context getInitialContext() throws NamingException {
        InitialContext initialContext = null;
        if (this.context != null) {
            return this.context;
        }
        if (this.getProviderURL() != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.provider.url", this.providerURL);
            hashtable.put("com.ibm.websphere.naming.jndicache.cacheobject", "none");
            initialContext = new InitialContext(hashtable);
        } else {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("com.ibm.websphere.naming.jndicache.cacheobject", "none");
            initialContext = new InitialContext(hashtable);
        }
        this.context = initialContext;
        return initialContext;
    }

    private boolean isLocal() {
        return this.isConfiguredForRemoteEJB == false;
    }

    public Object retrieve(TKIID tKIID) throws ClientException {
        return this.retrieve((OID)tKIID);
    }

    public Object retrieve(OID oID) throws ClientException {
        HumanTaskManagerService humanTaskManagerService = null;
        try {
            humanTaskManagerService = this.getHumanTaskManagerService();
        }
        catch (NamingException namingException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)namingException);
        }
        catch (CreateException createException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)createException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{this.getClass()}, (Throwable)remoteException);
        }
        String string = null;
        try {
            if (oID instanceof TKTID) {
                string = "HumanTaskManagerService.getTaskTemplate";
                TaskTemplate taskTemplate = humanTaskManagerService.getTaskTemplate((TKTID)oID);
                return taskTemplate;
            }
            if (oID instanceof TKIID) {
                string = "HumanTaskManagerService.getTask";
                Task task = humanTaskManagerService.getTask((TKIID)oID);
                return task;
            }
            if (oID instanceof ESIID) {
                string = "HumanTaskManagerService.getEscalation";
                Escalation escalation = humanTaskManagerService.getEscalation((ESIID)oID);
                return escalation;
            }
        }
        catch (TaskException taskException) {
            throw new HTMCommandException(new Object[]{string + " for ID: '" + oID + "'"}, taskException);
        }
        catch (RemoteException remoteException) {
            throw new CommunicationException(new Object[]{string + " for ID: '" + oID + "'"}, (Throwable)remoteException);
        }
        catch (EJBException eJBException) {
            throw new CommunicationException(new Object[]{string + " for ID: '" + oID + "'"}, (Throwable)eJBException);
        }
        return null;
    }

    public void close() {
        try {
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public HumanTaskManagerService getHumanTaskManagerService() throws NamingException, CreateException, RemoteException {
        if (this.isLocal()) {
            return this.getLocalHumanTaskManager();
        }
        return this.getHumanTaskManager();
    }

    private HumanTaskManagerService getHumanTaskManager() throws CreateException, RemoteException, NamingException {
        Context context;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.taskHome == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Creating HumanTaskManagerHome");
            }
            context = this.getInitialContext();
            Object object = context.lookup(this.jndiName);
            this.taskHome = (HumanTaskManagerHome)PortableRemoteObject.narrow((Object)object, HumanTaskManagerHome.class);
        }
        context = null;
        if (this.taskHome != null) {
            try {
                context = this.taskHome.create();
            }
            catch (Exception exception) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Exception during TaskManager.create(): " + exception.getMessage() + ". Starting retry..."));
                }
                Context context2 = this.getInitialContext();
                Object object = context2.lookup(this.jndiName);
                this.taskHome = (HumanTaskManagerHome)PortableRemoteObject.narrow((Object)object, HumanTaskManagerHome.class);
                context = this.taskHome.create();
            }
        }
        if (context != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Returning HumanTaskManagerHome object");
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Not Returning HumanTaskManagerHome object");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return (HumanTaskManagerService)context;
    }

    private HumanTaskManagerService getLocalHumanTaskManager() throws CreateException, RemoteException, NamingException {
        Context context;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.localHumanTaskManagerHome == null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Creating LocalHumanTaskManagerHome");
            }
            context = this.getInitialContext();
            this.localHumanTaskManagerHome = (LocalHumanTaskManagerHome)context.lookup(this.jndiName);
        }
        context = null;
        if (this.localHumanTaskManagerHome != null) {
            try {
                context = this.localHumanTaskManagerHome.create();
            }
            catch (Exception exception) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Exception during TaskManager.create(): " + exception.getMessage() + ". Starting retry..."));
                }
                Context context2 = this.getInitialContext();
                this.localHumanTaskManagerHome = (LocalHumanTaskManagerHome)context2.lookup(this.jndiName);
                context = this.localHumanTaskManagerHome.create();
            }
        }
        if (context != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Returning LocalHumanTaskManager object");
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Not Returning LocalHumanTaskManager object");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return (HumanTaskManagerService)context;
    }
}

