/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.client;

import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;

public class BPCClientTrace {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2006.\n\n";
    private static TraceLogger trace = TraceLogger.newTraceLogger(BPCClientTrace.class);
    private static boolean isInitialized = false;
    public static boolean isTracing = trace.isLogging(null);

    public static final void initialize(String string) throws IllegalStateException {
        if (isInitialized) {
            throw new IllegalStateException("Tracing already initialized.");
        }
        trace.addFileHandler(string);
        isInitialized = true;
    }

    public static final void deInitialize() throws IllegalStateException {
        if (!isInitialized) {
            throw new IllegalStateException("Tracing already deinitialized.");
        }
        BPCClientTrace.stop();
        trace.destroy();
        isInitialized = false;
    }

    public static final boolean isInitialized() {
        return isInitialized;
    }

    public static final void start() {
        trace.setLogging(true);
        isTracing = trace.isLogging(null);
    }

    public static final void stop() {
        trace.setLogging(false);
        isTracing = trace.isLogging(null);
    }

    public static final void refreshCachedSettings() {
        isTracing = trace.isLogging(null);
    }

    public static final void entry() {
        trace.entry();
    }

    public static final void entry(Object object) {
        trace.entry(object);
    }

    public static final void entry(Object object, Object object2) {
        trace.entry(object, object2);
    }

    public static final void entry(Object[] objectArray) {
        trace.entry(objectArray);
    }

    public static final void exit() {
        trace.exit();
    }

    public static final void exit(Object object) {
        trace.exit(object);
    }

    public static final void trace(TraceEventType traceEventType, String string) {
        trace.trace(traceEventType, string);
    }

    public static final void trace(TraceEventType traceEventType, String string, Object[] objectArray) {
        trace.trace(traceEventType, string, objectArray);
    }

    public static final void trace(TraceEventType traceEventType, String string, Object object) {
        trace.trace(traceEventType, string, object);
    }

    public static final void trace(TraceEventType traceEventType, String string, Object object, Object object2) {
        trace.trace(traceEventType, string, object, object2);
    }

    public static final void trace(TraceEventType traceEventType, Throwable throwable) {
        trace.exception(traceEventType, throwable);
    }
}

