/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.servletfilters;

import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLog;
import com.ibm.bpe.util.TraceLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ZippedServletOutputStream
extends ServletOutputStream {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008, 2009.\n\n";
    private ByteArrayOutputStream byteStream;
    private GZIPOutputStream zipStream;
    private boolean closed = false;
    private HttpServletResponse response;
    private ServletOutputStream output;

    public ZippedServletOutputStream(HttpServletResponse httpServletResponse) throws IOException {
        this.response = httpServletResponse;
        this.byteStream = new ByteArrayOutputStream();
        this.zipStream = new GZIPOutputStream(this.byteStream);
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        this.zipStream.finish();
        byte[] byArray = this.byteStream.toByteArray();
        if (TraceLog.isTracing) {
            TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Content length is: " + byArray.length));
        }
        this.response.addHeader("Content-Length", Integer.toString(byArray.length));
        this.response.addHeader("Content-Encoding", "gzip");
        this.output = this.response.getOutputStream();
        this.output.write(byArray);
        this.output.flush();
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (TraceLog.isTracing) {
            TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"flushing zipStream");
        }
        this.zipStream.flush();
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.zipStream.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.zipStream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this.closed;
    }
}

