/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.servletfilters;

import com.ibm.bpc.servletfilters.ZippedServletOutputStream;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLog;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ZipWrapper
extends HttpServletResponseWrapper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008, 2009.\n\n";
    private HttpServletResponse response;
    private ServletOutputStream stream = null;
    private PrintWriter writer = null;

    public ZipWrapper(HttpServletResponse httpServletResponse) throws IOException {
        super(httpServletResponse);
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        this.response = httpServletResponse;
    }

    public void finishResponse() {
        block5: {
            try {
                if (this.writer != null) {
                    this.writer.close();
                } else if (this.stream != null) {
                    this.stream.flush();
                    this.stream.close();
                }
            }
            catch (IOException iOException) {
                if (!TraceLog.isTracing) break block5;
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_EVENT, (Throwable)iOException);
            }
        }
    }

    public void flushBuffer() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream == null) {
            this.stream = new ZippedServletOutputStream(this.response);
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), "UTF-8"));
        }
        return this.writer;
    }

    public void setContentLength(int n) {
    }
}

