/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.servletfilters;

import com.ibm.bpc.servletfilters.ZipWrapper;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLog;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CompressionFilter
implements Filter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        if (servletRequest != null && servletRequest instanceof HttpServletRequest && servletResponse != null && servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            if (httpServletRequest.getHeader("Content-Encoding") != null) {
                httpServletResponse.sendError(415);
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)"Request content encoding is not supported");
                }
                return;
            }
            String string = httpServletRequest.getRequestURI();
            String string2 = httpServletRequest.getHeader("accept-encoding");
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Accept-encoding header is set to: " + string2));
            }
            if (string2 != null && string2.indexOf("identity") >= 0) {
                if (filterChain != null) {
                    filterChain.doFilter(servletRequest, servletResponse);
                }
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)"No compression required");
                }
                return;
            }
            if (string2 != null && string2.indexOf("gzip") >= 0 && this.canBeCompressed(string)) {
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Compressing content");
                }
                ZipWrapper zipWrapper = new ZipWrapper(httpServletResponse);
                if (filterChain != null) {
                    filterChain.doFilter(servletRequest, (ServletResponse)zipWrapper);
                }
                zipWrapper.finishResponse();
                if (TraceLog.isTracing) {
                    TraceLog.exit();
                }
                return;
            }
            if (string2 != null && string2.indexOf("gzip") < 0) {
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.sendError(406);
                }
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)"Requested encoding is not supported");
                }
                return;
            }
        }
        if (filterChain != null) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        if (TraceLog.isTracing) {
            TraceLog.exit();
        }
    }

    private boolean canBeCompressed(String string) {
        return !string.endsWith("gif") && !string.endsWith("jpg") && !string.endsWith("jpeg") && !string.endsWith("png");
    }

    public void destroy() {
    }
}

