/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.servletfilters;

import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLog;
import com.ibm.bpe.util.TraceLogger;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CachingFilter
implements Filter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        if (servletRequest != null && servletRequest instanceof HttpServletRequest && servletResponse != null && servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            String string = httpServletRequest.getRequestURI();
            if (string.endsWith("gif") || string.endsWith("jpg") || string.endsWith("jpeg") || string.endsWith("png") || string.endsWith(".js") || string.endsWith(".css")) {
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Setting expiration header");
                }
                Date date = new Date();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", new Locale("en", "US"));
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                date.setTime(date.getTime() + 86400000L);
                httpServletResponse.addHeader("Expires", simpleDateFormat.format(date));
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("expiration header set to: " + simpleDateFormat.format(date)));
                }
            }
        }
        if (filterChain != null) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        if (TraceLog.isTracing) {
            TraceLog.exit();
        }
    }

    public void destroy() {
    }
}

