/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.exporter;

import com.ibm.bpc.exporter.ResultExport;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CSVResultExport
extends ResultExport {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007.\n\n";
    private String separator = ",";

    public CSVResultExport(ResourceBundle resourceBundle, Locale locale) {
        super(resourceBundle, locale);
    }

    public CSVResultExport(ResourceBundle resourceBundle) {
        super(resourceBundle);
    }

    public String export() {
        return this.exportHeader().append(this.exportContent()).toString();
    }

    public void setSeparator(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string);
        }
        this.separator = string;
    }

    private StringBuffer exportHeader() {
        StringBuffer stringBuffer = null;
        List list = this.getHeader();
        if (list != null) {
            stringBuffer = new StringBuffer("");
            String string = null;
            String string2 = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                try {
                    if (this.getBundle() == null) {
                        throw new MissingResourceException("Resource bundle not set in CSV exporter", null, string);
                    }
                    string2 = this.getBundle().getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "No localized string found for key " + string);
                    }
                    string2 = string;
                }
                if (string2 != null) {
                    string2 = string2.indexOf(this.separator) >= 0 ? "\" " + string2 + "\"" : " " + string2;
                }
                stringBuffer.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuffer.append(this.separator);
            }
            stringBuffer.append(LS);
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "CSV export header list is empty!!");
        }
        return stringBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer exportContent() {
        StringBuffer stringBuffer = null;
        int n = this.getColumnNumber();
        List list = this.getContent();
        if (list == null) return stringBuffer;
        stringBuffer = new StringBuffer("");
        String string3 = null;
        String string2 = null;
        int n2 = 1;
        for (String string3 : list) {
            try {
                if (string3 != null) {
                    if (this.getBundle() == null) throw new MissingResourceException("Resource bundle not set in CSV exporter", null, string3);
                    string2 = this.getBundle().getString(string3);
                } else {
                    string2 = "";
                }
            }
            catch (MissingResourceException missingResourceException) {
                string2 = string3;
            }
            if (string2 != null) {
                string2 = string2.indexOf(this.separator) >= 0 ? "\" " + string2 + "\"" : " " + string2;
            }
            if (n2 < n) {
                stringBuffer.append(string2);
                stringBuffer.append(this.separator);
                ++n2;
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(LS);
            n2 = 1;
        }
        return stringBuffer;
    }
}

