/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.icu.util.TimeZone;
import java.util.Locale;

public abstract class Timer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2009.\n\n";
    private String id = null;
    private String label = null;
    private Locale locale = Locale.getDefault();
    private TimeZone timeZone = null;
    protected boolean timeUpdateable = true;
    protected boolean durationUpdateable = true;
    public static final String DURATION_ZERO = "DURATION_ZERO";
    public static final String DURATION_INFINITE = "DURATION_INFINITE";
    protected String timestamp = "";

    public Timer(String string, String string2, Locale locale, TimeZone timeZone) {
        String string3;
        this.id = string;
        this.label = string3 = LocaleUtils.getLocalizedString(string2, locale);
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public boolean isTimeUpdateable() {
        return this.timeUpdateable;
    }

    public boolean isDurationUpdateable() {
        return this.durationUpdateable;
    }

    protected void initializeAvailableActions() {
        if (this.isTimerTimestampUpdateable()) {
            this.timeUpdateable = true;
            this.getTimestamp();
        } else {
            this.timeUpdateable = false;
        }
        this.durationUpdateable = this.isTimerDurationUpdateable();
    }

    protected boolean isTimerUpdateable() {
        return this.isTimerDurationUpdateable() || this.isTimerTimestampUpdateable();
    }

    protected abstract boolean isTimerTimestampUpdateable();

    protected abstract boolean isTimerDurationUpdateable();

    public abstract String getTimestamp();

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

