/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.UTCDate;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.ActivityInstanceFilterAttributes;
import com.ibm.bpe.clientmodel.query.ActivityInstanceQueryAttributes;
import com.ibm.bpe.clientmodel.query.ProcessInstanceFilterAttributes;
import com.ibm.bpe.clientmodel.query.ProcessInstanceQueryAttributes;
import com.ibm.bpe.clientmodel.query.ProcessTemplateFilterAttributes;
import com.ibm.bpe.clientmodel.query.ProcessTemplateQueryAttributes;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.task.clientmodel.query.EscalationFilterAttributes;
import com.ibm.task.clientmodel.query.EscalationQueryAttributes;
import com.ibm.task.clientmodel.query.TaskInstanceFilterAttributes;
import com.ibm.task.clientmodel.query.TaskInstanceQueryAttributes;
import com.ibm.task.clientmodel.query.TaskTemplateFilterAttributes;
import com.ibm.task.clientmodel.query.TaskTemplateQueryAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    public static final String ANDCONDITION = "AND";
    public static final String ORCONDITION = "OR";
    public static final String OPERATOR_EQUAL = "=";
    public static final String OPERATOR_NOT_EQUAL = "<>";
    public static final String OPERATOR_IS_NULL = "IS NULL";
    public static final String OPERATOR_IS_NOT_NULL = "IS NOT NULL";
    public static final String OPERATOR_IN = "IN";
    public static final String OPERATOR_LIKE = "LIKE";
    private static final String COLUMN_WI_OWNERID = "WORK_ITEM.OWNER_ID";
    private static final String COLUMN_WI_GROUPNAME = "WORK_ITEM.GROUP_NAME";
    public static final String ATTRIBUTE_CURRENT_USER = "CURRENT_USER";
    public static final String ATTRIBUTE_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";

    public static String[] convertToStringArray(int[] nArray) {
        String[] stringArray = null;
        if (nArray != null) {
            stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray[i] = Integer.toString(nArray[i]);
            }
        }
        return stringArray;
    }

    public static String convertToStringList(List<String> list, String string) {
        StringBuffer stringBuffer = new StringBuffer(75);
        if (list != null) {
            for (String string2 : list) {
                if (string2 == null || "".equals(string2.trim())) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public static String convertToStringList(String[] stringArray) {
        return QueryUtils.convertToStringList(stringArray, ",");
    }

    public static String convertToStringList(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(75);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || "".equals(string2.trim())) continue;
                if (i > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public static String convertToQuotedStringList(String string) {
        StringBuffer stringBuffer = new StringBuffer(75);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                stringBuffer.append(QueryUtils.getQuotedString(string2, "", ""));
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public static String convertToQuotedStringList(String string, String string2, String string3) {
        String string4;
        StringBuffer stringBuffer = new StringBuffer(75);
        String string5 = string2 != null ? string2 : "";
        String string6 = string4 = string3 != null ? string3 : "";
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string7 = stringTokenizer.nextToken().trim();
                stringBuffer.append(QueryUtils.getQuotedString(string7, string5, string4));
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    public static String convertToQuotedStringList(List<String> list) {
        return QueryUtils.convertToQuotedStringList(list, null, null);
    }

    public static String convertToQuotedStringList(List<String> list, String string, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer(75);
        String string4 = string != null ? string : "";
        String string5 = string3 = string2 != null ? string2 : "";
        if (list != null) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string6 = iterator.next();
                if (string6 instanceof String) {
                    stringBuffer.append(QueryUtils.getQuotedString(string6, string4, string3));
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(",");
                    continue;
                }
                if (!(string6 instanceof OID)) continue;
                stringBuffer.append(QueryUtils.getQuotedString(string6.toString(), string4, string3));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getQuotedString(String string, String string2, String string3) {
        return string2 + "'" + QueryUtils.escapeQuotes(string) + "'" + string3;
    }

    public static String escapeQuotes(String string) {
        String string2 = string;
        if (string != null && string.indexOf(39) != -1) {
            string2 = string.replaceAll("'", "''");
        }
        return string2;
    }

    public static String convertToIDStringList(String string) {
        return QueryUtils.convertToQuotedStringList(string, "ID(", ")");
    }

    public static String convertToIDStringList(String[] stringArray) {
        return QueryUtils.convertToQuotedStringList(Arrays.asList(stringArray), "ID(", ")");
    }

    public static String convertToIDStringList(List<String> list) {
        return QueryUtils.convertToQuotedStringList(list, "ID(", ")");
    }

    public static String convertToTSString(String string) {
        String string2 = null;
        if (string != null) {
            if (string.startsWith("TS('")) {
                string2 = string;
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Value is already timestamp '" + string + "'");
                }
            } else {
                int n;
                string2 = ATTRIBUTE_CURRENT_TIMESTAMP.equals(string) ? string : ((n = string.indexOf(" ")) > 0 ? "TS('" + string.replaceFirst(" ", "T") + "')" : "TS('" + string + "')");
            }
        }
        if (string2 == null && BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Invalid datetime value '" + string + "', expecting yyyy-mm-dd hh:mm:ss.mmm");
        }
        return string2;
    }

    public static String convertTSStringToDate(String string) {
        String string2 = null;
        if (!string.startsWith("TS('")) {
            string2 = string;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Value is no timestamp '" + string + "'");
            }
        } else {
            String string3 = string.split("'")[1];
            int n = string3.indexOf("T");
            string2 = n > 0 ? string3.replaceFirst("T", " ") : string3;
        }
        if (string2 == null && BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Invalid timestamp value '" + string + "', expecting yyyy-mm-dd hh:mm:ss.mmm");
        }
        return string2;
    }

    public static void addConditionToWhereClause(StringBuffer stringBuffer, String string, String string2) {
        if (string2 != null) {
            if (stringBuffer.length() > 0 && string2 != null && string2.length() != 0) {
                if (!ANDCONDITION.equalsIgnoreCase(string) && !ORCONDITION.equalsIgnoreCase(string)) {
                    throw new IllegalArgumentException("Parameter operator must be either 'AND' or 'OR'.");
                }
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
        }
    }

    public static String getConditionIsNull(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("A value for column must be specified.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + " " + OPERATOR_IS_NULL);
        return stringBuffer.toString();
    }

    public static String getConditionIsNotNull(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("A value for column must be specified.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + " " + OPERATOR_IS_NOT_NULL);
        return stringBuffer.toString();
    }

    public static String getCondition(String string, String string2, String string3) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("A value for column must be specified.");
        }
        if (string2 == null || !OPERATOR_EQUAL.equalsIgnoreCase(string2) && !OPERATOR_IN.equalsIgnoreCase(string2) && !OPERATOR_LIKE.equalsIgnoreCase(string2) && !OPERATOR_NOT_EQUAL.equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException("Parameter operator must be '<>', '=', 'IN' or 'LIKE'.");
        }
        if (string3 == null || "".equals(string3)) {
            throw new IllegalArgumentException("A value must be specified.");
        }
        String string4 = string3;
        if (OPERATOR_IN.equalsIgnoreCase(string2)) {
            string4 = "(" + string3 + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + " " + string2 + " " + string4);
        return stringBuffer.toString();
    }

    public static String getEqualStringCondition(String string, String string2) {
        return QueryUtils.getCondition(string, OPERATOR_EQUAL, "'" + QueryUtils.escapeQuotes(string2) + "'");
    }

    public static String getNotEqualStringCondition(String string, String string2) {
        return QueryUtils.getCondition(string, OPERATOR_NOT_EQUAL, "'" + QueryUtils.escapeQuotes(string2) + "'");
    }

    public static String getLikeStringCondition(String string, String string2) {
        return QueryUtils.getCondition(string, OPERATOR_LIKE, "'" + QueryUtils.escapeQuotes(string2) + "'");
    }

    public static String getStringCondition(String string, Object object) {
        return QueryUtils.getStringCondition(string, object.toString());
    }

    public static String getStringCondition(String string, String string2) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("A value for column must be specified.");
        }
        if (string2 == null || "".equals(string2)) {
            throw new IllegalArgumentException("value must be specified.");
        }
        if (string2.indexOf("%") != -1 || string2.indexOf("_") != -1) {
            return QueryUtils.getCondition(string, OPERATOR_LIKE, "'" + QueryUtils.escapeQuotes(string2) + "'");
        }
        return QueryUtils.getCondition(string, OPERATOR_EQUAL, "'" + QueryUtils.escapeQuotes(string2) + "'");
    }

    private static String getCondition(String string, String[] stringArray) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("A value for column must be specified.");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Values must be specified.");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.indexOf("%") != -1 || string2.indexOf("_") != -1) {
                QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getLikeStringCondition(string, string2));
                continue;
            }
            arrayList.add(string2);
        }
        if (arrayList.size() > 1) {
            QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getCondition(string, OPERATOR_IN, QueryUtils.convertToQuotedStringList(arrayList)));
        } else if (arrayList.size() > 0) {
            QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getEqualStringCondition(string, (String)arrayList.get(0)));
        }
        return stringBuffer.toString();
    }

    public static void encloseCondition(StringBuffer stringBuffer) {
        if (stringBuffer != null && stringBuffer.length() != 0) {
            stringBuffer.insert(0, "(");
            stringBuffer.append(")");
        }
    }

    public static String getWorkItemFilterCondition(BPCQueryFilterAttributes bPCQueryFilterAttributes) {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getCurrentUserWorkItemCondition(bPCQueryFilterAttributes));
        String[] stringArray2 = (String[])bPCQueryFilterAttributes.getAttribute("wiOwners");
        if (stringArray2 != null) {
            QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getUserWorkItemCondition(stringArray2));
        }
        if ((stringArray = (String[])bPCQueryFilterAttributes.getAttribute("wiGroups")) != null) {
            QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getGroupWorkItemCondition(stringArray));
        }
        QueryUtils.encloseCondition(stringBuffer);
        String[] stringArray3 = (String[])bPCQueryFilterAttributes.getAttribute("wiReasons");
        if (stringArray3 != null) {
            QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, QueryUtils.getWorkItemReasonsCondition(QueryUtils.convertToStringList(stringArray3)));
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : null;
    }

    private static String getCurrentUserWorkItemCondition(BPCQueryFilterAttributes bPCQueryFilterAttributes) throws IllegalArgumentException {
        if (bPCQueryFilterAttributes == null) {
            throw new IllegalArgumentException("A value for parameter filterAttributes must be specified.");
        }
        StringBuffer stringBuffer = new StringBuffer(50);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bPCQueryFilterAttributes.getAttribute("privateWIs") != null) {
            bl = new Boolean((String)bPCQueryFilterAttributes.getAttribute("privateWIs"));
        }
        if (bPCQueryFilterAttributes.getAttribute("groupWIs") != null) {
            bl2 = new Boolean((String)bPCQueryFilterAttributes.getAttribute("groupWIs"));
        }
        if (bPCQueryFilterAttributes.getAttribute("everybodyWIs") != null) {
            bl3 = new Boolean((String)bPCQueryFilterAttributes.getAttribute("everybodyWIs"));
        }
        if (bl || bl2 || bl3) {
            if (bl) {
                stringBuffer.append(QueryUtils.getPrivateWorkItemCondition());
                QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, "WORK_ITEM.EVERYBODY = 0");
                QueryUtils.encloseCondition(stringBuffer);
            } else if (bl2) {
                stringBuffer.append(QueryUtils.getPrivateGroupWorkItemCondition());
                QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, "WORK_ITEM.EVERYBODY = 0");
                QueryUtils.encloseCondition(stringBuffer);
            } else if (bl3) {
                stringBuffer.append(QueryUtils.getEverybodyWorkItemCondition(true));
            }
        }
        return stringBuffer.toString();
    }

    private static String getPrivateWorkItemCondition() {
        return QueryUtils.getCondition(COLUMN_WI_OWNERID, OPERATOR_EQUAL, ATTRIBUTE_CURRENT_USER);
    }

    private static String getPrivateGroupWorkItemCondition() {
        return QueryUtils.getCondition(COLUMN_WI_OWNERID, OPERATOR_EQUAL, ATTRIBUTE_CURRENT_USER);
    }

    private static String getEverybodyWorkItemCondition(boolean bl) {
        if (bl) {
            return "(WORK_ITEM.OWNER_ID IS NULL AND WORK_ITEM.GROUP_NAME IS NULL AND WORK_ITEM.EVERYBODY = 1)";
        }
        return "(WORK_ITEM.OWNER_ID IS NULL AND WORK_ITEM.EVERYBODY = 1)";
    }

    public static String replaceCurrentUser(String string, String string2) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("User: " + string2 + " Clause: " + string);
        }
        String string3 = string;
        if (string != null && string2 != null) {
            string3 = string.replaceAll(ATTRIBUTE_CURRENT_USER, "'" + QueryUtils.escapeQuotes(string2) + "'");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string3);
        }
        return string3;
    }

    public static String replaceCurrentTimestamp(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Clause: " + string);
        }
        String string2 = string;
        if (string != null) {
            String string3 = new UTCDate().toXsdString();
            string2 = string.replaceAll(ATTRIBUTE_CURRENT_TIMESTAMP, "TS('" + string3 + "')");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string2);
        }
        return string2;
    }

    public static String replaceTsAdd(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (string != null) {
            int n = string.indexOf("TS_ADD(");
            int n2 = 0;
            int n3 = 0;
            if (n != -1) {
                try {
                    while (n != -1 && string.length() > n2) {
                        stringBuffer.append(string.substring(n2, n));
                        n2 = n + 7;
                        n3 = string.indexOf(44, n2);
                        String string2 = string.substring(n2, n3);
                        n2 = n3 + 2;
                        n3 = string.indexOf(41, n2) - 1;
                        String string3 = string.substring(n2, n3);
                        stringBuffer.append(QueryUtils.addOffsetToTimestamp(string2, string3));
                        n2 = n3 + 2;
                        n = string.indexOf("TS_ADD(", n2);
                    }
                    if (stringBuffer.length() > 0 && n2 < string.length()) {
                        stringBuffer.append(string.substring(n2));
                    }
                }
                catch (DatatypeConfigurationException datatypeConfigurationException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace(TraceLogger.TYPE_EVENT, datatypeConfigurationException);
                    }
                    Assert.assertion((boolean)false, (String)"DatatypeConfigurationException in addOffsetToTimestamp, check the trace of this method above in trace.");
                    stringBuffer = new StringBuffer(string);
                }
            } else {
                stringBuffer = new StringBuffer(string);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(stringBuffer);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private static String addOffsetToTimestamp(String string, String string2) throws DatatypeConfigurationException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "ts: " + string + ", offset: " + string2);
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(string.substring(4, string.length() - 2));
        Duration duration = datatypeFactory.newDuration(string2);
        xMLGregorianCalendar.add(duration);
        String string3 = QueryUtils.convertToTSString(xMLGregorianCalendar.toXMLFormat());
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, string3);
        }
        return string3;
    }

    private static String addDurations(String string, String string2) throws DatatypeConfigurationException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Duration1: " + string + ", Duration2: " + string2);
        }
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        Duration duration = datatypeFactory.newDuration(string);
        Duration duration2 = datatypeFactory.newDuration(string2);
        Duration duration3 = duration.add(duration2);
        String string3 = duration3.toString();
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, string + " + " + string2 + " = " + string3);
        }
        return string3;
    }

    public static String replaceTsSpan(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string);
        }
        StringBuffer stringBuffer = new StringBuffer("");
        if (string != null) {
            int n = string.indexOf("TS_SPAN(");
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (n != -1) {
                try {
                    while (n != -1 && string.length() > n6) {
                        stringBuffer.append(string.substring(n6, n));
                        StringBuffer stringBuffer2 = new StringBuffer();
                        n2 = n + 8;
                        n3 = string.indexOf(",", n2) + 1;
                        n4 = string.indexOf(",", n3) + 1;
                        n5 = string.indexOf("))", n4) + 1;
                        String string2 = string.substring(n2, n3 - 1);
                        String string3 = string.substring(n3, n4 - 1);
                        String string4 = string.substring(n4, n5);
                        stringBuffer2.append(QueryUtils.getTimeSpanCondition(string2, string3, string4));
                        if (stringBuffer2 != null && stringBuffer2.length() > 0) {
                            stringBuffer.append(stringBuffer2.toString());
                        } else {
                            stringBuffer2.append(string.substring(n, n5 + 1));
                        }
                        n6 = n5 + 1;
                        n = string.indexOf("TS_SPAN(", n6);
                    }
                    if (stringBuffer.length() > 0 && n6 < string.length()) {
                        stringBuffer.append(string.substring(n6));
                    }
                }
                catch (DatatypeConfigurationException datatypeConfigurationException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace(TraceLogger.TYPE_EVENT, datatypeConfigurationException);
                    }
                    Assert.assertion((boolean)false, (String)"DatatypeConfigurationException in getTimeSpanCondition, check the trace of this method above in trace.");
                    stringBuffer = new StringBuffer(string);
                }
            } else {
                stringBuffer = new StringBuffer(string);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(stringBuffer);
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private static String getTimeSpanCondition(String string, String string2, String string3) throws DatatypeConfigurationException {
        XMLGregorianCalendar xMLGregorianCalendar;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "column: " + string + " ts1: " + string2 + " ts2: " + string3);
        }
        String string4 = null;
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xMLGregorianCalendar2 = datatypeFactory.newXMLGregorianCalendar(string2.substring(4, string2.length() - 2));
        int n = xMLGregorianCalendar2.compare(xMLGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(string3.substring(4, string3.length() - 2)));
        if (n == -1) {
            string4 = string + " >= " + string2 + " AND " + string + " <= " + string3;
        } else if (n == 1) {
            string4 = string + " >= " + string3 + " AND " + string + " <= " + string2;
        } else if (n == 0) {
            string4 = string + " = " + string2;
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Timestamps could not be compared! column: " + string + " ts1: " + string2 + " ts2: " + string3);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, string4);
        }
        return string4;
    }

    private static String getUserWorkItemCondition(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("A value for parameter users must be specified.");
        }
        return QueryUtils.getCondition(COLUMN_WI_OWNERID, stringArray);
    }

    private static String getGroupWorkItemCondition(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("A value for parameter groupNames must be specified.");
        }
        return QueryUtils.getCondition(COLUMN_WI_GROUPNAME, stringArray);
    }

    public static String getWorkItemReasonsCondition(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("A value for parameter wiReasons must be specified.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WORK_ITEM.REASON IN (");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.length() != 0 ? stringBuffer.toString() : null;
    }

    public static String getAdminAsUserWorkItemCondition(BPCQueryAttributes bPCQueryAttributes) {
        Assert.assertion((bPCQueryAttributes != null ? 1 : 0) != 0, (String)"queryAttributes must be set!");
        StringBuffer stringBuffer = new StringBuffer(75);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("queryType=" + bPCQueryAttributes.getEntityType() + ", systemAdmin=" + bPCQueryAttributes.isSystemAdmin() + ", adminAsUser=" + bPCQueryAttributes.getAdminAsUser() + ", currentUser=" + bPCQueryAttributes.getCurrentUser());
        }
        if (bPCQueryAttributes.isSystemAdmin()) {
            if (bPCQueryAttributes.getAdminAsUser()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "User view for System Administrator: Add private work item restriction.");
                }
                stringBuffer.append(QueryUtils.getPrivateWorkItemCondition());
                boolean bl = TaskInstanceFilterAttributes.TYPE.equals(bPCQueryAttributes.getEntityType());
                QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getEverybodyWorkItemCondition(bl));
                QueryUtils.encloseCondition(stringBuffer);
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Administrative view for System Administrator: No private work item restriction.");
            }
        } else if (bPCQueryAttributes.getAdminAsUser()) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "User view for normal user: Implicit work item restrictions.");
            }
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Administrative view for normal user: Implicit work item restrictions.");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(stringBuffer.toString());
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : null;
    }

    public static BPCQueryAttributes createQueryAttributes(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string);
        }
        ProcessTemplateQueryAttributes processTemplateQueryAttributes = null;
        if (ProcessTemplateFilterAttributes.TYPE.equals(string)) {
            processTemplateQueryAttributes = new ProcessTemplateQueryAttributes();
        } else if (ProcessInstanceFilterAttributes.TYPE.equals(string)) {
            processTemplateQueryAttributes = new ProcessInstanceQueryAttributes();
        } else if (ActivityInstanceFilterAttributes.TYPE.equals(string)) {
            processTemplateQueryAttributes = new ActivityInstanceQueryAttributes();
        } else if (TaskTemplateFilterAttributes.TYPE.equals(string)) {
            processTemplateQueryAttributes = new TaskTemplateQueryAttributes();
        } else if (TaskInstanceFilterAttributes.TYPE.equals(string)) {
            processTemplateQueryAttributes = new TaskInstanceQueryAttributes();
        } else if (EscalationFilterAttributes.TYPE.equals(string)) {
            processTemplateQueryAttributes = new EscalationQueryAttributes();
        } else if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Invalid type " + string);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(processTemplateQueryAttributes);
        }
        return processTemplateQueryAttributes;
    }

    public static BPCQueryFilterAttributes createAttributesForType(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string);
        }
        ProcessTemplateFilterAttributes processTemplateFilterAttributes = null;
        if (ProcessTemplateFilterAttributes.TYPE.equals(string)) {
            processTemplateFilterAttributes = new ProcessTemplateFilterAttributes();
        }
        if (ProcessInstanceFilterAttributes.TYPE.equals(string)) {
            processTemplateFilterAttributes = new ProcessInstanceFilterAttributes();
        }
        if (ActivityInstanceFilterAttributes.TYPE.equals(string)) {
            processTemplateFilterAttributes = new ActivityInstanceFilterAttributes();
        }
        if (TaskTemplateFilterAttributes.TYPE.equals(string)) {
            processTemplateFilterAttributes = new TaskTemplateFilterAttributes();
        }
        if (TaskInstanceFilterAttributes.TYPE.equals(string)) {
            processTemplateFilterAttributes = new TaskInstanceFilterAttributes();
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(processTemplateFilterAttributes);
        }
        return processTemplateFilterAttributes;
    }

    public static String getEntityType(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.substring(string.lastIndexOf(".") + 1, string.length() - 4);
        }
        return string2;
    }

    public static String getWhereDescLocale(String string, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer(75);
        if (locale != null) {
            stringBuffer.append(QueryUtils.getLikeStringCondition(string, locale.getLanguage().toLowerCase() + "%"));
            QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, QueryUtils.getLikeStringCondition(string, locale.getLanguage().toUpperCase() + "%"));
        }
        QueryUtils.addConditionToWhereClause(stringBuffer, ORCONDITION, string + " = 'default'");
        QueryUtils.encloseCondition(stringBuffer);
        return stringBuffer.toString();
    }

    public static String getDateTimeCondition(String string, String string2, String string3, String string4, String string5) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("columnName: " + string + " reference: " + string2 + " referenceOffset: " + string3 + " end: " + string4 + " endOffset: " + string5);
        }
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("A value for parameter columnName must be specified.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string6 = null;
        if (string2 == null) {
            string6 = string3 == null ? ATTRIBUTE_CURRENT_TIMESTAMP : "TS_ADD(CURRENT_TIMESTAMP,'" + string3 + "')";
            if (string4 == null) {
                if (string5 != null) {
                    if ("P".equals(string5)) {
                        QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, string + " >= " + string6);
                    } else if ("-P".equals(string5)) {
                        QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, string + " <= " + string6);
                    } else {
                        String string7;
                        block34: {
                            string7 = string5;
                            if (string3 != null) {
                                try {
                                    string7 = QueryUtils.addDurations(string3, string5);
                                }
                                catch (DatatypeConfigurationException datatypeConfigurationException) {
                                    if (!BPCClientTrace.isTracing) break block34;
                                    BPCClientTrace.trace(TraceLogger.TYPE_EVENT, datatypeConfigurationException);
                                }
                            }
                        }
                        QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, "TS_SPAN(" + string + "," + string6 + ",TS_ADD(" + ATTRIBUTE_CURRENT_TIMESTAMP + ",'" + string7 + "'))");
                    }
                }
            } else if (string5 != null) {
                if ("-P".equals(string5)) {
                    QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, string + " >= " + string4);
                } else {
                    try {
                        String string8 = string5;
                        if (string3 != null) {
                            string8 = QueryUtils.addDurations(string3, string5);
                        }
                        QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, QueryUtils.replaceTsSpan("TS_SPAN(" + string + "," + string6 + "," + QueryUtils.addOffsetToTimestamp(string4, string8) + ")"));
                    }
                    catch (DatatypeConfigurationException datatypeConfigurationException) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace(TraceLogger.TYPE_EVENT, datatypeConfigurationException);
                        }
                        Assert.assertion((boolean)false, (String)"DatatypeConfigurationException in addDurations, check the trace of this method above in trace.");
                    }
                }
            } else {
                QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, "TS_SPAN(" + string + "," + string6 + "," + string4 + ")");
            }
        } else if (string4 == null) {
            if (string5 != null) {
                if ("P".equals(string5)) {
                    QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, string + " >= " + string2);
                } else if ("-P".equals(string5)) {
                    QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, string + " <= " + string2);
                } else {
                    try {
                        QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, QueryUtils.replaceTsSpan("TS_SPAN(" + string + "," + string2 + "," + QueryUtils.addOffsetToTimestamp(string2, string5) + ")"));
                    }
                    catch (DatatypeConfigurationException datatypeConfigurationException) {
                        if (BPCClientTrace.isTracing) {
                            BPCClientTrace.trace(TraceLogger.TYPE_EVENT, datatypeConfigurationException);
                        }
                        Assert.assertion((boolean)false, (String)"DatatypeConfigurationException in addOffsetToTimestamp, check the trace of this method above in trace.");
                    }
                }
            } else {
                QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, string + " = " + string2);
            }
        } else {
            QueryUtils.addConditionToWhereClause(stringBuffer, ANDCONDITION, QueryUtils.replaceTsSpan("TS_SPAN(" + string + "," + string2 + "," + string4 + ")"));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

