/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.util.Assert;
import com.ibm.task.api.TKIID;
import java.util.HashMap;
import java.util.Map;

public abstract class QueryProperties {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008.\n\n";
    private Map beanQueryProperties = null;
    private Map queryProperties = null;
    private OID oid = null;
    public static final String QUERY_PROPERTIES_MAP = "queryPropertiesMap";
    public static final String QUERY_PROPERTIES = "queryProperties";

    public QueryProperties(OID oID) {
        Assert.assertion((oID instanceof PIID || oID instanceof AIID || oID instanceof TKIID ? 1 : 0) != 0, (String)"OID must be of type PIID, AIID or TKIID!");
        this.oid = oID;
    }

    public OID getOid() {
        return this.oid;
    }

    public Map getBeanQueryProperties() throws ClientException {
        if (this.beanQueryProperties == null) {
            this.beanQueryProperties = this.retrieveBeanQueryProperties();
            this.addQueryProperties(this.beanQueryProperties);
        }
        return this.beanQueryProperties;
    }

    protected abstract Map retrieveBeanQueryProperties() throws ClientException;

    public void addQueryProperties(Map map) {
        if (map != null) {
            if (this.queryProperties == null) {
                this.queryProperties = new HashMap(map.size());
            }
            this.queryProperties.putAll(map);
        }
    }

    public Map getQueryProperties() {
        if (this.queryProperties == null) {
            return new HashMap();
        }
        return this.queryProperties;
    }
}

