/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLog;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParserUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";

    public static final Node childElementOf(Node node, String string) {
        Node node2 = null;
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        if (node != null && string != null) {
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() != 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2 = nodeList.item(i).getLocalName();
                    if (string2 == null || !string2.equals(string)) continue;
                    node2 = nodeList.item(i);
                    break;
                }
                if (TraceLog.isTracing && node2 != null) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Parsing XML query: element <" + string + "> found"));
                }
            }
            if (TraceLog.isTracing) {
                TraceLog.exit();
            }
        }
        return node2;
    }

    public static final List childElementsOf(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        if (node != null && string != null) {
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() != 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2 = nodeList.item(i).getLocalName();
                    if (string2 == null || !string2.equals(string)) continue;
                    arrayList.add(nodeList.item(i));
                }
                if (TraceLog.isTracing && arrayList != null) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Parsing XML query: found " + arrayList.size() + " elsement with name " + string));
                }
            }
            if (TraceLog.isTracing) {
                TraceLog.exit();
            }
        }
        return arrayList;
    }

    public static final String valueOf(Node node) {
        String string = null;
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        if (node != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                switch (node2.getNodeType()) {
                    case 3: 
                    case 4: {
                        stringBuffer.append(((CharacterData)node2).getData());
                    }
                }
            }
            string = stringBuffer.toString();
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Parsing XML message: Value of element <" + node.getLocalName() + "> is \"" + string + "\""));
            }
            if (TraceLog.isTracing) {
                TraceLog.exit();
            }
        }
        return string;
    }

    public static final String attributeOf(Node node, String string) {
        String string2 = null;
        Node node2 = null;
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        boolean bl = false;
        if (node != null) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                node2 = namedNodeMap.item(i);
                if (!node2.getLocalName().equals(string)) continue;
                string2 = ParserUtils.valueOf(node2);
                bl = true;
                break;
            }
            if (TraceLog.isTracing) {
                if (bl) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Parsing XML message: attribute " + node2.getLocalName() + "=\"" + string2 + "\""));
                } else {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Parsing XML message: attribute " + string + " not found"));
                }
            }
            if (TraceLog.isTracing) {
                TraceLog.exit();
            }
        }
        return string2;
    }

    public static final String[] getValuesOfValueCondition(Node node) {
        int n = 0;
        String[] stringArray = null;
        List list = ParserUtils.childElementsOf(node, "value");
        if (list != null) {
            stringArray = new String[list.size()];
            Iterator iterator = list.iterator();
            n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = ParserUtils.valueOf((Node)iterator.next());
                ++n;
            }
        }
        return stringArray;
    }

    public static final String xmlEncodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            char[] cArray = string.toCharArray();
            block8: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block8;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        continue block8;
                    }
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block8;
                    }
                    case '\r': {
                        stringBuffer.append("&#xd;");
                        continue block8;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block8;
                    }
                    default: {
                        stringBuffer.append(cArray[i]);
                    }
                }
            }
        }
        return stringBuffer.toString();
    }
}

