/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.converter.TimezoneConverter;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.GregorianCalendar;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class LocaleUtils {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";
    static String MODEL_RESOURCE = new String("com.ibm.bpc.clientcore.resources.bpcclientcorePIINonMessages");
    static Map<Locale, String> DATETIME_PATTERNS = new HashMap<Locale, String>();
    static Map<Locale, String> DATE_PATTERNS = new HashMap<Locale, String>();
    static SimpleDateFormat ISODATEFORMAT = null;
    public static final String ISO_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static Map RESOURCE_BUNDLE_CACHE = new HashMap();

    private static String getLabel(ResourceBundle resourceBundle, Locale locale, String string) {
        String string2 = null;
        try {
            if (resourceBundle == null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.entry(string);
                    BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "No resource bundle provided for " + string);
                }
                return string;
            }
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (BPCClientTrace.isTracing && string2 == null) {
            BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "No localized string found for key " + string);
        }
        return string2 != null ? string2 : string;
    }

    public static String getLocalizedString(String string, Locale locale) {
        return LocaleUtils.getLocalizedString(MODEL_RESOURCE, locale, string);
    }

    public static String getLocalizedString(String string, Locale locale, String string2) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string2, locale.getDisplayName());
        }
        ResourceBundle resourceBundle = LocaleUtils.lookupResourceBundle(string, locale);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string2);
        }
        return LocaleUtils.getLabel(resourceBundle, locale, string2);
    }

    public static String formatDateTime(Calendar calendar, int n, int n2, Locale locale, com.ibm.icu.util.TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Entry formatDateTime for " + calendar.toString() + " using dateStyle " + n + " using timeStyle " + n2 + " using Locale " + locale.getDisplayName() + " timeZone " + timeZone);
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance((int)n, (int)n2, (Locale)locale);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        ((SimpleDateFormat)dateFormat).applyPattern(LocaleUtils.getAdjustedYearPattern(n, n2, locale));
        String string = dateFormat.format(calendar.getTime());
        if ("ar".equals(locale.getLanguage())) {
            string = "&lrm; ".concat(string).concat(" &#x202C; ");
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> formatted date is " + string);
        }
        return string;
    }

    public static Calendar parseDateTime(String string, int n, int n2, Locale locale, com.ibm.icu.util.TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Entry parseDate for " + string + " using dateStyle " + n + " using timeStyle " + n2 + " using Locale " + locale.getDisplayName() + " timeZone " + timeZone);
        }
        try {
            SimpleDateFormat simpleDateFormat = LocaleUtils.getISODateFormat();
            if (timeZone != null) {
                simpleDateFormat.setTimeZone(timeZone);
            }
            simpleDateFormat.setLenient(false);
            Date date = simpleDateFormat.parse(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> parsed date is " + calendar.toString());
            }
            return calendar;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String getLocalizedLabel(ColumnInfo columnInfo, Locale locale) {
        String string;
        String string2 = columnInfo.getLabel();
        if (string2 == null && (string2 = LocaleUtils.getLocalizedString(string = columnInfo.getLabelKey(), locale)) == null) {
            string2 = columnInfo.getPropertyName();
        }
        return string2;
    }

    public static String getSortedPropertiesMap(Map map, Locale locale) {
        return LocaleUtils.getSortedPropertiesMap(map, null, locale, null);
    }

    public static String getSortedPropertiesMap(Map map, SimpleConverter simpleConverter, Locale locale, TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList, Collator.getInstance((Locale)locale));
        Iterator iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object v;
            Object e = iterator.next();
            Object object = v = map.get(e);
            if (simpleConverter != null) {
                object = simpleConverter instanceof TimezoneConverter ? ((TimezoneConverter)simpleConverter).getAsString(v, locale, timeZone) : simpleConverter.getAsString(v, locale);
            }
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(e);
            stringBuffer.append("=");
            stringBuffer.append(object);
        }
        stringBuffer.append("}");
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public static Locale getSupportedLocale(Locale locale, List list) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "locale: " + locale + " - supported locales: " + list);
        }
        String string = locale.toString().toLowerCase();
        Iterator iterator = list.iterator();
        Locale locale2 = null;
        while (iterator.hasNext()) {
            Locale locale3 = (Locale)iterator.next();
            String string2 = locale3.toString().toLowerCase();
            if (string2.equals("default")) {
                if (locale2 != null) continue;
                locale2 = locale3;
                continue;
            }
            if (string2.equalsIgnoreCase(string.substring(0, 2))) {
                if (locale2 != null && !locale2.toString().equals("default")) continue;
                locale2 = locale3;
                continue;
            }
            if (!string2.equalsIgnoreCase(string)) continue;
            locale2 = locale3;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "best match: " + locale2);
        }
        return locale2;
    }

    static ResourceBundle lookupResourceBundle(String string, Locale locale) {
        String string2 = locale.toString() + "#" + string;
        ResourceBundle resourceBundle = (ResourceBundle)RESOURCE_BUNDLE_CACHE.get(string2);
        if (resourceBundle == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = LocaleUtils.class.getClassLoader();
            }
            resourceBundle = ResourceBundle.getBundle(string, locale, classLoader);
            RESOURCE_BUNDLE_CACHE.put(string2, resourceBundle);
        }
        return resourceBundle;
    }

    public static synchronized String getAdjustedYearPattern(Integer n, Integer n2, Locale locale) {
        String string = null;
        if (n != null && n2 != null) {
            if (DATETIME_PATTERNS.containsKey(locale)) {
                string = DATETIME_PATTERNS.get(locale);
            } else {
                string = ((SimpleDateFormat)DateFormat.getDateTimeInstance((int)n, (int)n2, (Locale)locale)).toPattern();
                if (!string.contains("yyyy")) {
                    string = string.replaceFirst("yy", "yyyy");
                }
                if ("ar".equals(locale.getLanguage())) {
                    string = "yyyy/MM/dd hh:mm:ss";
                }
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Creating formatting pattern for locale " + locale.toString() + ": " + string);
                }
                DATETIME_PATTERNS.put(locale, string);
            }
        }
        if (n != null && n2 == null) {
            if (DATE_PATTERNS.containsKey(locale)) {
                string = DATE_PATTERNS.get(locale);
            } else {
                string = ((SimpleDateFormat)DateFormat.getDateInstance((int)n, (Locale)locale)).toPattern();
                if (!string.contains("yyyy")) {
                    string = string.replaceFirst("yy", "yyyy");
                }
                if ("ar".equals(locale.getLanguage())) {
                    string = "yyyy/MM/dd";
                }
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Creating formatting pattern for locale " + locale.getLanguage() + ": " + string);
                }
                DATE_PATTERNS.put(locale, string);
            }
        }
        return string;
    }

    public static synchronized SimpleDateFormat getISODateFormat() {
        if (ISODATEFORMAT == null) {
            ISODATEFORMAT = (SimpleDateFormat)DateFormat.getDateTimeInstance((int)1, (int)1, (Locale)Locale.US);
            ISODATEFORMAT.applyPattern(ISO_PATTERN);
        }
        return ISODATEFORMAT;
    }

    public static String getLocalizedDate(int n, int n2, com.ibm.icu.util.Calendar calendar, Locale locale, com.ibm.icu.util.TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(com.ibm.icu.util.TimeZone.getTimeZone((String)"UTC"), locale);
        com.ibm.icu.util.TimeZone timeZone2 = com.ibm.icu.util.TimeZone.getTimeZone((String)timeZone.getID());
        timeZone2.setRawOffset(timeZone.getRawOffset());
        return LocaleUtils.getLocalizedDate(n, n2, calendar, locale, timeZone2);
    }

    public static String getLocalizedDate(int n, int n2, Calendar calendar, Locale locale, com.ibm.icu.util.TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Entry formatDateTime for " + calendar.toString() + " using dateStyle " + n + " using timeStyle " + n2);
        }
        String string = LocaleUtils.formatDateTime(calendar, 3, 1, locale, timeZone);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> formatted date is " + string);
        }
        return string;
    }

    public static String getISODate(Calendar calendar, Locale locale, com.ibm.icu.util.TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("Entry getISODate for " + calendar.toString());
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(com.ibm.icu.util.TimeZone.getTimeZone((String)"UTC"), locale);
        com.ibm.icu.util.TimeZone timeZone2 = com.ibm.icu.util.TimeZone.getTimeZone((String)timeZone.getID());
        timeZone2.setRawOffset(timeZone.getRawOffset());
        gregorianCalendar.setTimeZone(timeZone2);
        gregorianCalendar.setTime(calendar.getTime());
        SimpleDateFormat simpleDateFormat = LocaleUtils.getISODateFormat();
        simpleDateFormat.setCalendar((com.ibm.icu.util.Calendar)gregorianCalendar);
        simpleDateFormat.setLenient(false);
        String string = null;
        try {
            string = simpleDateFormat.format((Object)gregorianCalendar);
        }
        catch (Exception exception) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, exception.getMessage());
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Calender = " + calendar.toString() + " locale = " + locale + " Tz = " + timeZone.getDisplayName());
            }
            string = "????-??-?? ??:??:??";
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> formatted date is " + string);
        }
        return string;
    }
}

