/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMapCreator {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public static HashMap<Integer, String> createKeyMap(Class clazz, String string, String string2) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Entry createKeyMap for " + clazz.getName() + ", " + string + ", " + string2);
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            int n = fieldArray[i].getModifiers();
            if (!fieldArray[i].getName().startsWith(string) || !Modifier.isStatic(n) || !Modifier.isFinal(n) || !Modifier.isPublic(n)) continue;
            try {
                if (fieldArray[i].getType().equals(Integer.TYPE)) {
                    hashMap.put(fieldArray[i].getInt(clazz), string2 + fieldArray[i].getName().replace('_', '.'));
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> added " + fieldArray[i].getInt(clazz) + ", " + hashMap.get(fieldArray[i].getInt(clazz)));
                    continue;
                }
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> Field " + fieldArray[i].getName() + " not added. Type is " + fieldArray[i].getType() + ". Value " + hashMap.get(fieldArray[i].get(clazz)));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Assert.assertion((boolean)false, (String)"IllegalAccess on Field array");
            }
        }
        return hashMap;
    }
}

