/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpc.clientcore.util.ErrorBean;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;

public class ErrorBeanImpl
implements ErrorBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    private Exception exception;
    private Locale locale = new Locale("en", "us");
    protected static final String NO_NESTED_EXCEPTION_KEY = "ERROR.NO_NESTED_EXCEPTION";
    protected static final String NO_EXCEPTION_SET_KEY = "ERROR.NO_EXCEPTION_SET";
    protected static final String NO_NESTED_STACK_KEY = "ERROR.NO_NESTED_STACK";
    protected static final String NO_EXCEPTION_MESSAGE_KEY = "ERROR.NO_EXCEPTION_MESSAGE";
    private static final String SEPARATOR_LINE = "--------------------------------------------------------\n";

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.exception = exception;
    }

    public void setException(Exception exception, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        this.setException(exception);
        this.locale = locale;
    }

    public String getExceptionMessage() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(this.exception);
        }
        if (this.exception != null) {
            return this.getExceptionMessage(this.exception);
        }
        return LocaleUtils.getLocalizedString(NO_EXCEPTION_SET_KEY, this.locale);
    }

    public String getNestedExceptionMessage() {
        Throwable throwable;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.exception != null && (throwable = this.getCause(this.exception)) != null) {
            return this.getExceptionMessage(throwable);
        }
        return LocaleUtils.getLocalizedString(NO_NESTED_EXCEPTION_KEY, this.locale);
    }

    public String getRootExceptionMessage() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.exception != null) {
            return this.getExceptionMessage(this.getRootCause(this.exception));
        }
        return LocaleUtils.getLocalizedString(NO_EXCEPTION_SET_KEY, this.locale);
    }

    public String getAllExceptionMessages() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(this.exception);
        }
        if (this.exception != null) {
            String string = this.getExceptionMessage(this.exception);
            Throwable throwable = this.getCause(this.exception);
            while (throwable != null) {
                string = string + "\n" + SEPARATOR_LINE + this.getExceptionMessage(throwable);
                throwable = this.getCause(throwable);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit("Exception Messages:\n" + string);
            }
            return string;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(NO_EXCEPTION_SET_KEY);
        }
        return LocaleUtils.getLocalizedString(NO_EXCEPTION_SET_KEY, this.locale);
    }

    private String getExceptionMessage(Throwable throwable) {
        if (throwable != null) {
            block14: {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.entry(throwable.getClass().getName());
                }
                try {
                    Method method = throwable.getClass().getMethod("getMessage", Locale.class);
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.exit((String)method.invoke((Object)throwable, this.locale));
                    }
                    return (String)method.invoke((Object)throwable, this.locale);
                }
                catch (SecurityException securityException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "No 'getMessage(Locale)' Method found -> localized message not available");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "No 'getMessage(Locale)' Method found -> localized message not available");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "No 'getMessage(Locale)' Method found -> localized message not available");
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (BPCClientTrace.isTracing) {
                        BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "No 'getMessage(Locale)' Method found -> localized message not available");
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!BPCClientTrace.isTracing) break block14;
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "No 'getMessage(Locale)' Method found -> localized message not available");
                }
            }
            String string = throwable.getClass().getName() + " - " + throwable.getMessage();
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit(string);
            }
            return string;
        }
        return LocaleUtils.getLocalizedString(NO_EXCEPTION_MESSAGE_KEY, this.locale);
    }

    public String getExceptionKey(Throwable throwable) {
        String string;
        block5: {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.entry(throwable);
            }
            string = null;
            if (throwable != null) {
                try {
                    Method method = throwable.getClass().getMethod("getMessageID", new Class[]{null});
                    string = (String)method.invoke((Object)throwable, (Object[])null);
                }
                catch (Exception exception) {
                    if (!BPCClientTrace.isTracing) break block5;
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "No message key available.");
                }
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string);
        }
        return string;
    }

    public String getStack() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.exception != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
            return this.getExceptionStack(this.exception);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return LocaleUtils.getLocalizedString(NO_EXCEPTION_SET_KEY, this.locale);
    }

    public String getNestedExceptionStack() {
        Throwable throwable;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.exception != null && (throwable = this.getCause(this.exception)) != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
            return this.getExceptionStack(throwable);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return LocaleUtils.getLocalizedString(NO_NESTED_STACK_KEY, this.locale);
    }

    public String getRootExceptionStack() {
        Throwable throwable;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if ((throwable = this.getRootCause(this.exception)) != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
            return this.getExceptionStack(throwable);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return LocaleUtils.getLocalizedString(NO_EXCEPTION_SET_KEY, this.locale);
    }

    public String getAllExceptionStacks() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (this.exception != null) {
            String string = this.getExceptionStack(this.exception);
            Throwable throwable = this.getCause(this.exception);
            while (throwable != null) {
                string = string + SEPARATOR_LINE + this.getExceptionStack(throwable);
                throwable = this.getCause(throwable);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit();
            }
            return string;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return LocaleUtils.getLocalizedString(NO_EXCEPTION_SET_KEY, this.locale);
    }

    public boolean isNestedExceptionAvailable() {
        if (this.exception != null) {
            return this.getCause(this.exception) != null;
        }
        return false;
    }

    private String getExceptionStack(Throwable throwable) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        if (throwable == null) {
            throw new IllegalArgumentException();
        }
        String string = null;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray != null) {
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                string = string + stackTraceElementArray[i].toString() + "\n";
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string);
        }
        return string;
    }

    public Throwable getRootCause(Throwable throwable) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Throwable throwable2 = throwable;
        Throwable throwable3 = this.getCause(throwable);
        while (throwable3 != null) {
            throwable2 = throwable3;
            throwable3 = this.getCause(throwable3);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(throwable2);
        }
        return throwable2;
    }

    public Throwable getCause(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(throwable.getClass().getName());
        }
        Throwable throwable2 = null;
        throwable2 = throwable instanceof JspException ? ((JspException)throwable).getRootCause() : (throwable instanceof ServletException ? ((ServletException)throwable).getRootCause() : (throwable instanceof NamingException ? ((NamingException)throwable).getRootCause() : throwable.getCause()));
        if (BPCClientTrace.isTracing) {
            if (throwable2 == null) {
                BPCClientTrace.exit(throwable2);
            } else {
                BPCClientTrace.exit(throwable2.getClass().getName());
            }
        }
        return throwable2;
    }
}

