/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.util;

import com.ibm.bpe.api.JspUsageEnum;
import com.ibm.bpe.api.WebClientSetting;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.api.JspApplicableRoleEnum;
import com.ibm.task.api.JspLocation;

public class ClientUIHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    private static final JspApplicableRoleEnum[] ORDER_FOR_ORIGINATING_INTERFACE_HTM = new JspApplicableRoleEnum[]{JspApplicableRoleEnum.ALL, JspApplicableRoleEnum.ADMIN, JspApplicableRoleEnum.ORIGINATOR, JspApplicableRoleEnum.POTENTIAL_STARTER, JspApplicableRoleEnum.READER};
    private static final JspApplicableRoleEnum[] ORDER_FOR_PARTICIPATING_INTERFACE_HTM = new JspApplicableRoleEnum[]{JspApplicableRoleEnum.ALL, JspApplicableRoleEnum.ADMIN, JspApplicableRoleEnum.OWNER, JspApplicableRoleEnum.EDITOR, JspApplicableRoleEnum.POTENTIAL_OWNER, JspApplicableRoleEnum.ESCALATION_RECEIVER, JspApplicableRoleEnum.STARTER, JspApplicableRoleEnum.READER};
    private static final com.ibm.bpe.api.JspApplicableRoleEnum[] ORDER_FOR_ORIGINATING_INTERFACE_BFM = new com.ibm.bpe.api.JspApplicableRoleEnum[]{com.ibm.bpe.api.JspApplicableRoleEnum.ALL, com.ibm.bpe.api.JspApplicableRoleEnum.ADMIN, com.ibm.bpe.api.JspApplicableRoleEnum.ORIGINATOR, com.ibm.bpe.api.JspApplicableRoleEnum.POTENTIAL_STARTER, com.ibm.bpe.api.JspApplicableRoleEnum.READER};
    private static final com.ibm.bpe.api.JspApplicableRoleEnum[] ORDER_FOR_PARTICIPATING_INTERFACE_BFM = new com.ibm.bpe.api.JspApplicableRoleEnum[]{com.ibm.bpe.api.JspApplicableRoleEnum.ALL, com.ibm.bpe.api.JspApplicableRoleEnum.ADMIN, com.ibm.bpe.api.JspApplicableRoleEnum.OWNER, com.ibm.bpe.api.JspApplicableRoleEnum.EDITOR, com.ibm.bpe.api.JspApplicableRoleEnum.POTENTIAL_OWNER, com.ibm.bpe.api.JspApplicableRoleEnum.ESCALATION_RECEIVER, com.ibm.bpe.api.JspApplicableRoleEnum.STARTER, com.ibm.bpe.api.JspApplicableRoleEnum.READER};

    private static boolean contains(Object object, Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return true;
        }
        return false;
    }

    private static JspLocation getHTMJspLocation(com.ibm.task.api.JspUsageEnum jspUsageEnum, com.ibm.task.api.WebClientSetting webClientSetting, JspApplicableRoleEnum[] jspApplicableRoleEnumArray) {
        int n;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        JspLocation jspLocation = null;
        int n2 = jspApplicableRoleEnumArray.length;
        Object[] objectArray = webClientSetting.getApplicableRoles();
        if (BPCClientTrace.isTracing) {
            for (n = 0; n < objectArray.length; ++n) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Applicable role: " + objectArray[n]);
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!ClientUIHelper.contains(jspApplicableRoleEnumArray[n], objectArray) && !JspApplicableRoleEnum.ALL.equals(jspApplicableRoleEnumArray[n])) continue;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Checking " + jspApplicableRoleEnumArray[n]);
            }
            if ((jspLocation = webClientSetting.getJspLocation(jspUsageEnum, jspApplicableRoleEnumArray[n])) == null) continue;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit(jspLocation);
            }
            return jspLocation;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("null");
        }
        return null;
    }

    private static com.ibm.bpe.api.JspLocation getBFMJspLocation(JspUsageEnum jspUsageEnum, WebClientSetting webClientSetting, com.ibm.bpe.api.JspApplicableRoleEnum[] jspApplicableRoleEnumArray) {
        int n;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        com.ibm.bpe.api.JspLocation jspLocation = null;
        int n2 = jspApplicableRoleEnumArray.length;
        Object[] objectArray = webClientSetting.getApplicableRoles();
        if (BPCClientTrace.isTracing) {
            for (n = 0; n < objectArray.length; ++n) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Applicable role: " + objectArray[n]);
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!ClientUIHelper.contains(jspApplicableRoleEnumArray[n], objectArray) && !com.ibm.bpe.api.JspApplicableRoleEnum.ALL.equals(jspApplicableRoleEnumArray[n])) continue;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Checking " + jspApplicableRoleEnumArray[n]);
            }
            if ((jspLocation = webClientSetting.getJspLocation(jspUsageEnum, jspApplicableRoleEnumArray[n])) == null) continue;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit(jspLocation);
            }
            return jspLocation;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("null");
        }
        return null;
    }

    public static JspLocation getJspLocationForOriginatingInterface(com.ibm.task.api.JspUsageEnum jspUsageEnum, com.ibm.task.api.WebClientSetting webClientSetting) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(jspUsageEnum);
        }
        JspLocation jspLocation = ClientUIHelper.getHTMJspLocation(jspUsageEnum, webClientSetting, ORDER_FOR_ORIGINATING_INTERFACE_HTM);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return jspLocation;
    }

    public static JspLocation getJspLocationForParticipatingInterface(com.ibm.task.api.JspUsageEnum jspUsageEnum, com.ibm.task.api.WebClientSetting webClientSetting) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(jspUsageEnum);
        }
        JspLocation jspLocation = ClientUIHelper.getHTMJspLocation(jspUsageEnum, webClientSetting, ORDER_FOR_PARTICIPATING_INTERFACE_HTM);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return jspLocation;
    }

    public static com.ibm.bpe.api.JspLocation getJspLocationForOriginatingInterface(JspUsageEnum jspUsageEnum, WebClientSetting webClientSetting) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(jspUsageEnum);
        }
        com.ibm.bpe.api.JspLocation jspLocation = ClientUIHelper.getBFMJspLocation(jspUsageEnum, webClientSetting, ORDER_FOR_ORIGINATING_INTERFACE_BFM);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return jspLocation;
    }

    public static com.ibm.bpe.api.JspLocation getJspLocationForParticipatingInterface(JspUsageEnum jspUsageEnum, WebClientSetting webClientSetting) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(jspUsageEnum);
        }
        com.ibm.bpe.api.JspLocation jspLocation = ClientUIHelper.getBFMJspLocation(jspUsageEnum, webClientSetting, ORDER_FOR_PARTICIPATING_INTERFACE_BFM);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return jspLocation;
    }

    public static String getWebClientType() {
        return "Web Client V6";
    }
}

