/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.query;

import com.ibm.bpc.clientcore.BPCQueryFilterAttributes;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.api.AIID;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.api.PIID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.query.BFMQueryConstants;
import com.ibm.bpe.util.Assert;
import com.ibm.task.api.TKIID;
import java.util.HashMap;
import java.util.Map;

public class QueryPropertyFilterAttributes
extends BPCQueryFilterAttributes {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008.\n\n";
    public static final String TYPE = BFMQueryConstants.QUERYPROPERTY_ENITITYTYPE;
    public static final String TABLE_NAME = "QUERY_PROPERTY";
    public static final String ID_COLUMN_NAME = "PIID";
    protected static final String ORDER_CLAUSE = "QUERY_PROPERTY.NAME ASC";
    private static Map validAttributes = new HashMap();

    public QueryPropertyFilterAttributes() {
        super(TYPE, validAttributes);
    }

    public BPCQueryFilterAttributes getNewInstance() {
        return new QueryPropertyFilterAttributes();
    }

    protected StringBuffer getWhereFilterCondition() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.getAttribute("piid") != null) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", "QUERY_PROPERTY.PIID = " + this.getAttribute("piid"));
        }
        if (this.getAttribute("aiid") != null) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", "ACTIVITY.AIID = " + this.getAttribute("aiid"));
        }
        if (this.getAttribute("tkiid") != null) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", "TASK.TKIID = " + this.getAttribute("tkiid"));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("where " + stringBuffer);
        }
        return stringBuffer;
    }

    public void setOid(OID oID) {
        Assert.assertion((oID instanceof PIID || oID instanceof AIID || oID instanceof TKIID ? 1 : 0) != 0, (String)"OID must be PIID, AIID or TKIID!");
        String string = null;
        if (oID instanceof PIID) {
            string = "piid";
        } else if (oID instanceof AIID) {
            string = "aiid";
        } else if (oID instanceof TKIID) {
            string = "tkiid";
        }
        this.getQueryAttributes().setFilterAttribute(TYPE, string, QueryUtils.convertToIDStringList(oID.toString()));
    }

    static {
        QueryPropertyFilterAttributes.addValidAttribute(TYPE, validAttributes, "piid", "");
        QueryPropertyFilterAttributes.addValidAttribute(TYPE, validAttributes, "aiid", "");
        QueryPropertyFilterAttributes.addValidAttribute(TYPE, validAttributes, "tkiid", "");
    }
}

