/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.query;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.bean.PropertyBean;
import com.ibm.bpc.clientcore.bean.QueryPropertyBean;
import com.ibm.bpc.clientcore.exception.TooManyQueryPropertiesInQueryException;
import com.ibm.bpc.clientcore.query.BPCQueryPropertyHelper;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.bpe.util.UnicodeUtilities;
import java.util.ArrayList;
import java.util.List;

public class BPCQueryQueryPropertyHelper
extends BPCQueryPropertyHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008.\n\n";

    protected List getProperties(BPCQueryAttributes bPCQueryAttributes) {
        return bPCQueryAttributes.getQueryProperties();
    }

    protected void throwTooManyPropertiesException() throws ClientException {
        throw new TooManyQueryPropertiesInQueryException(null);
    }

    protected String getPropertyMapName() {
        return "queryProperties";
    }

    protected String getTableName(String string) {
        return "QUERY_PROPERTY";
    }

    protected String getSelectForProperty(String string, String string2, boolean bl) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer(150);
        QueryPropertyBean queryPropertyBean = new QueryPropertyBean(string);
        String string4 = "QUERY_PROPERTY" + string2;
        if (!bl) {
            stringBuffer.append(string4).append(".STRING_VALUE as STRING_VALUE" + string2);
            stringBuffer.append(", ").append(string4).append(".GENERIC_VALUE as GENERIC_VALUE" + string2);
            stringBuffer.append(", ").append(string4).append(".NUMBER_VALUE as NUMBER_VALUE" + string2);
            stringBuffer.append(", ").append(string4).append(".DECIMAL_VALUE as DECIMAL_VALUE" + string2);
            stringBuffer.append(", ").append(string4).append(".TIMESTAMP_VALUE as TIMESTAMP_VALUE" + string2);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        String string5 = queryPropertyBean.getName();
        String string6 = queryPropertyBean.getVariableName();
        if (string5 != null && !"".equals(string5)) {
            stringBuffer2.append(QueryUtils.getStringCondition(string4 + ".NAME", string5));
        }
        if (string6 != null && !"".equals(string6)) {
            QueryUtils.addConditionToWhereClause(stringBuffer2, "AND", QueryUtils.getStringCondition(string4 + ".VARIABLE_NAME", string6));
        }
        if ((string3 = UnicodeUtilities.namespaceEncode((String)queryPropertyBean.getNamespace())) != null && !"".equals(string3)) {
            QueryUtils.addConditionToWhereClause(stringBuffer2, "AND", QueryUtils.getEqualStringCondition(string4 + ".NAMESPACE", string3));
        }
        if (stringBuffer2 != null) {
            stringBuffer.append(" [AOJP:").append(stringBuffer2.toString()).append("]");
        }
        return stringBuffer.toString();
    }

    protected List getValueColumnNamesForProperty(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        String string3 = "QUERY_PROPERTY" + string2;
        arrayList.add(string3 + ".STRING_VALUE");
        arrayList.add(string3 + ".GENERIC_VALUE");
        arrayList.add(string3 + ".NUMBER_VALUE");
        arrayList.add(string3 + ".DECIMAL_VALUE");
        arrayList.add(string3 + ".TIMESTAMP_VALUE");
        return arrayList;
    }

    protected List getValueColumnAliasesForProperty(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add("STRING_VALUE" + string2);
        arrayList.add("GENERIC_VALUE" + string2);
        arrayList.add("NUMBER_VALUE" + string2);
        arrayList.add("DECIMAL_VALUE" + string2);
        arrayList.add("TIMESTAMP_VALUE" + string2);
        return arrayList;
    }

    protected String getWhereClauseKeyCondition(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(75);
        QueryPropertyBean queryPropertyBean = new QueryPropertyBean(string);
        String string3 = "QUERY_PROPERTY" + string2;
        String string4 = queryPropertyBean.getName();
        if (string4 != null && !"".equals(string4)) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getStringCondition(string3 + ".NAME", string4));
        }
        if ((string4 = queryPropertyBean.getVariableName()) != null && !"".equals(string4)) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getStringCondition(string3 + ".VARIABLE_NAME", string4));
        }
        if ((string4 = queryPropertyBean.getNamespace()) != null && !"".equals(string4)) {
            String string5 = UnicodeUtilities.namespaceEncode((String)string4);
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getEqualStringCondition(string3 + ".NAMESPACE", string5));
        }
        return stringBuffer.toString();
    }

    protected String getWhereClauseValueCondition(PropertyBean propertyBean, String string) {
        String string2;
        QueryPropertyBean queryPropertyBean = (QueryPropertyBean)propertyBean;
        StringBuffer stringBuffer = new StringBuffer(75);
        String string3 = "QUERY_PROPERTY" + string;
        if (queryPropertyBean.getMappedType() == 2) {
            Long l = queryPropertyBean.getNumberValue();
            if (l != null) {
                String string4 = l.toString();
                QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getCondition(string3 + ".NUMBER_VALUE", "=", string4));
            }
        } else if (queryPropertyBean.getMappedType() == 3) {
            Double d = queryPropertyBean.getDecimalValue();
            if (d != null) {
                String string5 = d.toString();
                QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getCondition(string3 + ".DECIMAL_VALUE", "=", string5));
            }
        } else if (queryPropertyBean.getMappedType() == 1 && (string2 = queryPropertyBean.getStringValue()) != null && !"".equals(string2)) {
            StringBuffer stringBuffer2 = new StringBuffer(75);
            stringBuffer2.append(QueryUtils.getStringCondition(string3 + ".STRING_VALUE", string2));
            QueryUtils.addConditionToWhereClause(stringBuffer2, "OR", QueryUtils.getStringCondition(string3 + ".GENERIC_VALUE", string2));
            QueryUtils.encloseCondition(stringBuffer2);
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", stringBuffer2.toString());
        }
        return stringBuffer.toString();
    }

    public PropertyBean createPropertyBeanFromResult(String string, String string2, Object object) {
        String string3;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "table: " + string + ", column: " + string2 + ", value: " + object.toString());
        }
        QueryPropertyBean queryPropertyBean = null;
        if (object != null && this.hasSelectProperties() && BPCQueryQueryPropertyHelper.isPropertyTableName(string, string3 = this.getTableName(null))) {
            int n = Integer.parseInt(string2.substring(string2.length() - 1));
            String string4 = this.getPropertyKey(string3, n);
            queryPropertyBean = new QueryPropertyBean(string4);
            queryPropertyBean.setValueFromResultSet(string2.substring(0, string2.length() - 1), object);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "propertyBean: " + ((Object)queryPropertyBean).toString());
            }
        }
        return queryPropertyBean;
    }
}

