/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.query;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.ColumnInfo;
import com.ibm.bpc.clientcore.OrderInfo;
import com.ibm.bpc.clientcore.bean.PropertyBean;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BPCQueryPropertyHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";
    boolean initialized = false;
    private List propertiesInWhere = null;
    private List propertiesInOrder = null;
    private List propertyKeysInSelect = null;
    private List propertyKeysInOrder = null;
    private Map propertiesByKey = null;
    private Map propertyIndexByTableName = null;

    BPCQueryPropertyHelper() {
    }

    public void reset() {
        this.initialized = false;
        this.propertiesInWhere = null;
        this.propertiesInOrder = null;
        this.propertyKeysInSelect = null;
        this.propertyKeysInOrder = null;
        this.propertiesByKey = null;
        this.propertyIndexByTableName = null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initializeProperties(BPCQueryAttributes bPCQueryAttributes) throws ClientException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, this.getClass().getName());
        }
        this.reset();
        this.propertiesInWhere = this.getProperties(bPCQueryAttributes);
        this.initializePropertyKeysInSelect(bPCQueryAttributes);
        this.initializeOrderProperties(bPCQueryAttributes);
        this.initializePropertiesByKey();
        this.initializePropertyIndexByTableName();
        boolean bl = false;
        for (Map.Entry entry : this.propertyIndexByTableName.entrySet()) {
            List list = (List)entry.getValue();
            int n = list.size();
            if (n <= 10) continue;
            bl = true;
            if (!BPCClientTrace.isTracing) continue;
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Too many property columns for table " + entry.getKey() + ": " + list);
        }
        if (bl) {
            this.throwTooManyPropertiesException();
        }
        this.initialized = true;
    }

    protected abstract List getProperties(BPCQueryAttributes var1);

    protected abstract void throwTooManyPropertiesException() throws ClientException;

    private void initializePropertyKeysInSelect(BPCQueryAttributes bPCQueryAttributes) {
        this.propertyKeysInSelect = new ArrayList();
        List<ColumnInfo> list = bPCQueryAttributes.getColumnInfoList();
        if (list != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "List columns...");
            }
            for (ColumnInfo columnInfo : list) {
                String string = this.getPropertyKey(columnInfo.getPropertyName());
                if (string == null) continue;
                if (!this.propertyKeysInSelect.contains(string)) {
                    this.propertyKeysInSelect.add(string);
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Added property key: " + string);
                    continue;
                }
                if (!BPCClientTrace.isTracing) continue;
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Duplicate property key: " + string);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "All property list column keys: " + this.propertyKeysInSelect);
            }
        }
    }

    private String getPropertyKey(String string) {
        String string2;
        String string3 = null;
        if (string != null && string.contains("[") && (string2 = this.getPropertyMapName()).equals(string.substring(0, string2.length()))) {
            int n = string.indexOf("[");
            string3 = string.substring(n + 2, string.length() - 2);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Property key: " + string3);
            }
        }
        return string3;
    }

    protected abstract String getPropertyMapName();

    private void initializeOrderProperties(BPCQueryAttributes bPCQueryAttributes) {
        this.propertiesInOrder = new ArrayList();
        this.propertyKeysInOrder = new ArrayList();
        List<OrderInfo> list = bPCQueryAttributes.getOrderInfoList();
        if (list != null) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Order columns...");
            }
            for (OrderInfo orderInfo : list) {
                String string = this.getPropertyKey(orderInfo.getPropertyName());
                if (string == null) continue;
                this.propertiesInOrder.add(orderInfo);
                this.propertyKeysInOrder.add(string);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "All property order keys: " + this.propertyKeysInOrder);
            }
        }
    }

    private void initializePropertiesByKey() {
        int n;
        this.propertiesByKey = new HashMap();
        if (this.propertyKeysInSelect != null) {
            for (n = 0; n < this.propertyKeysInSelect.size(); ++n) {
                this.propertiesByKey.put(this.propertyKeysInSelect.get(n).toString(), null);
            }
        }
        if (this.propertyKeysInOrder != null) {
            for (n = 0; n < this.propertyKeysInOrder.size(); ++n) {
                this.propertiesByKey.put(this.propertyKeysInOrder.get(n).toString(), null);
            }
        }
        if (this.propertiesInWhere != null) {
            for (n = 0; n < this.propertiesInWhere.size(); ++n) {
                PropertyBean propertyBean = (PropertyBean)this.propertiesInWhere.get(n);
                String string = propertyBean.getKey();
                ArrayList<PropertyBean> arrayList = null;
                if (this.propertiesByKey.containsKey(string)) {
                    arrayList = (List)this.propertiesByKey.get(string);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<PropertyBean>();
                }
                arrayList.add(propertyBean);
                this.propertiesByKey.put(string, arrayList);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "All properties for query: " + this.propertiesByKey);
        }
    }

    private void initializePropertyIndexByTableName() {
        this.propertyIndexByTableName = new HashMap();
        Iterator iterator = this.propertiesByKey.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = this.getTableName(string);
            ArrayList<String> arrayList = (ArrayList<String>)this.propertyIndexByTableName.get(string2);
            if (arrayList != null) {
                arrayList.add(string);
                continue;
            }
            arrayList = new ArrayList<String>();
            this.propertyIndexByTableName.put(string2, arrayList);
            arrayList.add(string);
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Property Index: " + this.propertyIndexByTableName);
        }
    }

    protected abstract String getTableName(String var1);

    private String getPropertyIndex(String string) {
        String string2 = null;
        if (string != null && this.propertiesByKey.containsKey(string)) {
            for (Map.Entry entry : this.propertyIndexByTableName.entrySet()) {
                List list = (List)entry.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    String string3 = list.get(i).toString();
                    if (!string.equals(string3)) continue;
                    string2 = Integer.toString(i);
                }
            }
        }
        return string2;
    }

    public boolean hasSelectProperties() {
        boolean bl;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(this.getClass().getName());
        }
        Assert.assertion((boolean)this.initialized, (String)"BPCQueryPropertyHelper must be initialized before use!");
        boolean bl2 = bl = this.propertyKeysInSelect != null && this.propertyKeysInSelect.size() > 0 || this.propertyKeysInOrder != null && this.propertyKeysInOrder.size() > 0;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(Boolean.toString(bl));
        }
        return bl;
    }

    public StringBuffer addSelectProperties(StringBuffer stringBuffer) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(this.getClass().getName());
        }
        Assert.assertion((boolean)this.initialized, (String)"BPCQueryPropertyHelper must be initialized before use!");
        if (this.hasSelectProperties() || this.hasOrderProperties()) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Add select for property columns. Select property keys: " + this.propertyKeysInSelect);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Add join for order properties. Order property keys: " + this.propertyKeysInOrder);
            }
            for (Map.Entry entry : this.propertyIndexByTableName.entrySet()) {
                List list = (List)entry.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i).toString();
                    if (this.propertyKeysInSelect != null && this.propertyKeysInSelect.contains(string)) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(this.getSelectForProperty(string, Integer.toString(i), false));
                        continue;
                    }
                    if (this.propertyKeysInOrder == null || !this.propertyKeysInOrder.contains(string)) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.getSelectForProperty(string, Integer.toString(i), false));
                }
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("select: " + stringBuffer.toString());
        }
        return stringBuffer;
    }

    protected abstract String getSelectForProperty(String var1, String var2, boolean var3);

    private boolean hasOrderProperties() {
        boolean bl;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(this.getClass().getName());
        }
        Assert.assertion((boolean)this.initialized, (String)"BPCQueryPropertyHelper must be initialized before use!");
        boolean bl2 = bl = this.propertyKeysInOrder != null && this.propertyKeysInOrder.size() > 0;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(Boolean.toString(bl));
        }
        return bl;
    }

    public List getOrderValueColumnNames(OrderInfo orderInfo) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(this.getClass().getName());
        }
        Assert.assertion((boolean)this.initialized, (String)"BPCQueryPropertyHelper must be initialized before use!");
        List list = null;
        if (this.hasOrderProperties()) {
            String string;
            String string2 = this.getPropertyKey(orderInfo.getPropertyName());
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Order info key: " + string2);
            }
            if ((string = this.getPropertyIndex(string2)) != null) {
                list = this.getValueColumnNamesForProperty(string2, string);
            }
        }
        return list;
    }

    protected abstract List getValueColumnNamesForProperty(String var1, String var2);

    public boolean hasWhereProperties() {
        boolean bl;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(this.getClass().getName());
        }
        Assert.assertion((boolean)this.initialized, (String)"BPCQueryPropertyHelper must be initialized before use!");
        boolean bl2 = bl = this.propertiesInWhere != null;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(Boolean.toString(bl));
        }
        return bl;
    }

    public String getWhereClauseProperties() {
        if (BPCClientTrace.isTracing) {
            // empty if block
        }
        Assert.assertion((boolean)this.initialized, (String)"BPCQueryPropertyHelper must be initialized before use!");
        StringBuffer stringBuffer = new StringBuffer(75);
        if (this.propertiesInWhere != null) {
            for (Map.Entry entry : this.propertyIndexByTableName.entrySet()) {
                List list = (List)entry.getValue();
                for (int i = 0; i < list.size(); ++i) {
                    String string = list.get(i).toString();
                    List list2 = (List)this.propertiesByKey.get(string);
                    if (list2 != null) {
                        QueryUtils.addConditionToWhereClause(stringBuffer, "AND", this.getWhereClauseForIndex(string, Integer.toString(i), list2));
                        continue;
                    }
                    if (!BPCClientTrace.isTracing) continue;
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "index '" + i + "' only used in select/order for key '" + string + "'");
                }
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("where: " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String getWhereClauseForIndex(String string, String string2, List list) {
        StringBuffer stringBuffer = new StringBuffer(75);
        if (!this.propertyKeysInSelect.contains(string)) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", this.getWhereClauseKeyCondition(string, string2));
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "where properties for key '" + string + "': " + list);
        }
        for (PropertyBean propertyBean : list) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", this.getWhereClauseValueCondition(propertyBean, string2));
        }
        if (stringBuffer.length() > 0 && BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "where clause for key '" + string + "': " + stringBuffer);
        }
        QueryUtils.encloseCondition(stringBuffer);
        return stringBuffer.toString();
    }

    protected abstract String getWhereClauseKeyCondition(String var1, String var2);

    protected abstract String getWhereClauseValueCondition(PropertyBean var1, String var2);

    public String getPropertyKey(String string, int n) {
        List list = (List)this.propertyIndexByTableName.get(string);
        return list.get(n).toString();
    }

    public abstract PropertyBean createPropertyBeanFromResult(String var1, String var2, Object var3);

    public static boolean isPropertyTableName(String string, String string2) {
        return string2.length() <= string.length() && string2.equalsIgnoreCase(string.substring(0, string2.length()));
    }
}

