/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.query;

import com.ibm.bpc.clientcore.BPCQueryAttributes;
import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.bean.CustomPropertyBean;
import com.ibm.bpc.clientcore.bean.PropertyBean;
import com.ibm.bpc.clientcore.exception.TooManyCustomPropertiesInQueryException;
import com.ibm.bpc.clientcore.query.BPCQueryPropertyHelper;
import com.ibm.bpc.clientcore.util.QueryUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPCQueryCustomPropertyHelper
extends BPCQueryPropertyHelper {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2008, 2009.\n\n";

    @Override
    protected List<? extends PropertyBean> getProperties(BPCQueryAttributes bPCQueryAttributes) {
        return bPCQueryAttributes.getCustomProperties();
    }

    @Override
    protected void throwTooManyPropertiesException() throws ClientException {
        throw new TooManyCustomPropertiesInQueryException(null);
    }

    @Override
    protected String getPropertyMapName() {
        return "customProperties";
    }

    @Override
    protected String getTableName(String string) {
        return CustomPropertyBean.getTableName(CustomPropertyBean.getEntityType(string));
    }

    @Override
    protected String getSelectForProperty(String string, String string2, boolean bl) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer(150);
        CustomPropertyBean customPropertyBean = this.getCustomPropertyBean(string);
        String string4 = customPropertyBean.getTableName() + string2;
        if (!bl) {
            string3 = customPropertyBean.getColumnNameValue();
            String string5 = customPropertyBean.getColumnAliasValue() + string2;
            stringBuffer.append(string4).append("." + string3 + " as " + string5);
        }
        string3 = QueryUtils.getStringCondition(string4 + ".NAME", customPropertyBean.getName());
        stringBuffer.append(" [AOJP:").append(string3).append("]");
        return stringBuffer.toString();
    }

    @Override
    protected List<String> getValueColumnNamesForProperty(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        CustomPropertyBean customPropertyBean = this.getCustomPropertyBean(string);
        String string3 = customPropertyBean.getTableName() + string2;
        String string4 = customPropertyBean.getColumnNameValue();
        arrayList.add(string3 + "." + string4);
        return arrayList;
    }

    protected List<String> getValueColumnAliasesForProperty(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        CustomPropertyBean customPropertyBean = this.getCustomPropertyBean(string);
        String string3 = customPropertyBean.getColumnAliasValue() + string2;
        arrayList.add(string3);
        return arrayList;
    }

    @Override
    protected String getWhereClauseKeyCondition(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(75);
        CustomPropertyBean customPropertyBean = this.getCustomPropertyBean(string);
        String string3 = customPropertyBean.getTableName() + string2;
        String string4 = customPropertyBean.getName();
        if (string4 != null && !"".equals(string4)) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getStringCondition(string3 + ".NAME", string4));
        }
        return stringBuffer.toString();
    }

    @Override
    protected String getWhereClauseValueCondition(PropertyBean propertyBean, String string) {
        CustomPropertyBean customPropertyBean = (CustomPropertyBean)propertyBean;
        StringBuffer stringBuffer = new StringBuffer(75);
        String string2 = customPropertyBean.getTableName() + string;
        String string3 = customPropertyBean.getValue();
        if (string3 != null && !"".equals(string3)) {
            QueryUtils.addConditionToWhereClause(stringBuffer, "AND", QueryUtils.getStringCondition(string2 + "." + customPropertyBean.getColumnNameValue(), string3));
        }
        return stringBuffer.toString();
    }

    private CustomPropertyBean getCustomPropertyBean(String string) {
        return new CustomPropertyBean(CustomPropertyBean.getEntityType(string), CustomPropertyBean.getName(string), null);
    }

    @Override
    public PropertyBean createPropertyBeanFromResult(String string, String string2, Object object) {
        String string3;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "table: " + string + ", column: " + string2 + ", value: " + object.toString());
        }
        CustomPropertyBean customPropertyBean = null;
        if (object != null && this.hasSelectProperties() && (string3 = CustomPropertyBean.getEntityTypeFromTableName(string)) != null) {
            int n = Integer.parseInt(string2.substring(string2.length() - 1));
            String string4 = this.getPropertyKey(string, n);
            if ((CustomPropertyBean.getColumnAliasValue(string3) + n).equalsIgnoreCase(string2)) {
                customPropertyBean = this.getCustomPropertyBean(string4);
                customPropertyBean.setValue(object.toString());
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "propertyBean: " + ((Object)customPropertyBean).toString());
                }
            }
        }
        return customPropertyBean;
    }
}

