/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.exception;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpe.api.OID;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import java.util.Map;
import java.util.Set;

public class ErrorsInCommandException
extends ClientException {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2007.\n\n";
    private static final long serialVersionUID = 1L;
    private Map errormap;

    public ErrorsInCommandException(Map map) {
        super(ErrorsInCommandException.class.getName(), null, null);
        this.setErrors(map);
    }

    private void setErrors(Map map) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            Object object;
            Object k = entry.getKey();
            if (!(k instanceof OID) && !(k instanceof String)) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Error map key is not of type " + OID.class + " or " + String.class + "!");
                }
                object = new IllegalArgumentException("Expected type for error map keys is " + OID.class + " or " + String.class + ". Actual type is: " + k.getClass());
                throw object;
            }
            object = entry.getValue();
            if (object instanceof Exception) continue;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Error map value is not of type " + Exception.class + "!");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Expected type for error map values is " + Exception.class + ". Actual type is: " + object.getClass());
            throw illegalArgumentException;
        }
        this.errormap = map;
    }

    public Map getErrors() {
        return this.errormap;
    }
}

