/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.converter;

import com.ibm.bpc.clientcore.converter.TimezoneConverter;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class TimeStampConverter
implements TimezoneConverter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2009.\n\n";

    public String getAsString(Object object, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        return this.getAsString(object, locale, null);
    }

    public Object getAsObject(String string, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        return this.getAsObject(string, locale, null);
    }

    public String getAsString(Object object, Locale locale, java.util.TimeZone timeZone) {
        if (!(object instanceof Timestamp)) {
            String string;
            String string2;
            if (object instanceof String && (string2 = (String)object).equalsIgnoreCase(string = string2.substring(string2.indexOf("-"), string2.lastIndexOf("-") + 1))) {
                return string2;
            }
            throw new IllegalArgumentException("TimeStampConverter expects a java.sql.Timestamp object. Object passed is of type " + object.getClass());
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(((Timestamp)object).toGMTString());
        }
        if (timeZone == null) {
            timeZone = java.util.TimeZone.getDefault();
        }
        String string = "";
        TimeZone timeZone2 = TimeZone.getTimeZone((String)timeZone.getID());
        timeZone2.setRawOffset(timeZone.getRawOffset());
        Date date = new Date(((Timestamp)object).getTime());
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone((String)"UTC"), locale);
        gregorianCalendar.setTime(date);
        gregorianCalendar.setTimeZone(timeZone2);
        SimpleDateFormat simpleDateFormat = LocaleUtils.getISODateFormat();
        simpleDateFormat.setCalendar((Calendar)gregorianCalendar);
        try {
            string = simpleDateFormat.format(gregorianCalendar.getTime());
        }
        catch (Exception exception) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, exception.getMessage());
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "value = " + ((Timestamp)object).toGMTString());
            }
            string = "????-??-?? ??:??:??";
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit(string);
        }
        return string;
    }

    public Object getAsObject(String string, Locale locale, java.util.TimeZone timeZone) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        SimpleDateFormat simpleDateFormat = LocaleUtils.getISODateFormat();
        try {
            Date date = simpleDateFormat.parse(string);
            java.util.TimeZone timeZone2 = java.util.TimeZone.getDefault();
            long l = 0L;
            l = timeZone == null ? (long)timeZone2.getRawOffset() : (long)(timeZone.getRawOffset() - timeZone2.getRawOffset());
            return new Timestamp(date.getTime() - l);
        }
        catch (ParseException parseException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, parseException.getMessage());
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "value = " + string + " locale = " + locale.toString() + " Tz = " + timeZone.getDisplayName());
            }
            if (string.equals(string.substring(string.indexOf("-"), string.lastIndexOf("-") + 1))) {
                return null;
            }
            throw new IllegalArgumentException("The String " + string + " could not be parsed as a valid date");
        }
    }
}

