/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.converter;

import com.ibm.bpc.clientcore.converter.XConverter;
import com.ibm.bpc.clientcore.exception.InvalidNumberInputException;
import com.ibm.bpc.clientcore.exception.NumberOverflowException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;

public class NumberUtils
implements XConverter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2008.\n\n";
    static final BigInteger MIN_BYTE_VALUE = new BigInteger(Byte.toString((byte)-128));
    static final BigInteger MAX_BYTE_VALUE = new BigInteger(Byte.toString((byte)127));
    static final BigInteger MIN_SHORT_VALUE = new BigInteger(Short.toString((short)Short.MIN_VALUE));
    static final BigInteger MAX_SHORT_VALUE = new BigInteger(Short.toString((short)Short.MAX_VALUE));
    static final BigInteger MIN_INTEGER_VALUE = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    static final BigInteger MAX_INTEGER_VALUE = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    static final BigInteger MIN_LONG_VALUE = new BigInteger(Long.toString(Long.MIN_VALUE));
    static final BigInteger MAX_LONG_VALUE = new BigInteger(Long.toString(Long.MAX_VALUE));
    public static final Float FLOAT_NAN = new Float(Float.NaN);
    public static final Float FLOAT_POSITIVE_INFINITY = new Float(Float.POSITIVE_INFINITY);
    public static final Float FLOAT_NEGATIVE_INFINITY = new Float(Float.NEGATIVE_INFINITY);
    public static final Double DOUBLE_NAN = new Double(Double.NaN);
    public static final Double DOUBLE_POSITIVE_INFINITY = new Double(Double.POSITIVE_INFINITY);
    public static final Double DOUBLE_NEGATIVE_INFINITY = new Double(Double.NEGATIVE_INFINITY);
    public static final QName TYPE_XSD_BYTE = new QName("http://www.w3.org/2001/XMLSchema", "byte");
    public static final QName TYPE_XSD_UNSIGNED_BYTE = new QName("http://www.w3.org/2001/XMLSchema", "unsignedByte");
    public static final QName TYPE_XSD_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "short");
    public static final QName TYPE_XSD_INT = new QName("http://www.w3.org/2001/XMLSchema", "int");
    public static final QName TYPE_XSD_UNSIGNED_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort");
    public static final QName TYPE_XSD_INTEGER = new QName("http://www.w3.org/2001/XMLSchema", "integer");
    public static final QName TYPE_XSD_NEGATIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "negativeInteger");
    public static final QName TYPE_XSD_NONNEGATIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger");
    public static final QName TYPE_XSD_NONPOSITIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger");
    public static final QName TYPE_XSD_POSITIVEINTEGER = new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger");
    public static final QName TYPE_XSD_UNSIGNED_LONG = new QName("http://www.w3.org/2001/XMLSchema", "unsignedLong");
    public static final QName TYPE_XSD_LONG = new QName("http://www.w3.org/2001/XMLSchema", "long");
    public static final QName TYPE_XSD_UNSIGNED_INT = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
    public static final QName TYPE_XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float");
    public static final QName TYPE_XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double");
    public static final QName TYPE_XSD_DECIMAL = new QName("http://www.w3.org/2001/XMLSchema", "decimal");
    static Set NUMBER_TYPES = new HashSet();
    static Set INTEGER_TYPES = new HashSet();
    static Set DECIMAL_TYPES = new HashSet();

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object createFrom(Locale locale, QName qName, String string) throws InvalidNumberInputException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string);
        }
        NumberFormat numberFormat = NumberUtils.getNumberFormat(qName, locale);
        try {
            void var5_17;
            void var5_8;
            Object var5_5 = null;
            string = string.trim();
            if (TYPE_XSD_FLOAT.equals(qName)) {
                Float f = NumberUtils.createFromSpecialFloatLiteral(string);
            } else if (TYPE_XSD_DOUBLE.equals(qName)) {
                Double d = NumberUtils.createFromSpecialDoubleLiteral(string);
            }
            if (var5_8 != null) {
                if (!BPCClientTrace.isTracing) return var5_8;
                BPCClientTrace.exit(var5_8);
                return var5_8;
            }
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = numberFormat.parse(string, parsePosition);
            if (number == null || parsePosition.getIndex() != string.length()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Number parse error! Literal = " + string + " position = " + parsePosition.getIndex());
                }
                if (parsePosition.getIndex() == string.length()) throw new InvalidNumberInputException(new Object[]{string, NumberUtils.getExample(numberFormat, qName)});
                String string2 = string.substring(parsePosition.getIndex());
                if (!(numberFormat instanceof DecimalFormat)) throw new InvalidNumberInputException(new Object[]{string, NumberUtils.getExample(numberFormat, qName)});
                char c = ((DecimalFormat)numberFormat).getDecimalFormatSymbols().getDecimalSeparator();
                if (!(c + "0").equals(string2)) {
                    throw new InvalidNumberInputException(new Object[]{string, NumberUtils.getExample(numberFormat, qName)});
                }
            }
            if (TYPE_XSD_BYTE.equals(qName)) {
                Byte by = NumberUtils.createByte(number, locale);
            } else if (TYPE_XSD_SHORT.equals(qName) || TYPE_XSD_UNSIGNED_BYTE.equals(qName)) {
                Short s = NumberUtils.createShort(number, locale);
            } else if (TYPE_XSD_INT.equals(qName) || TYPE_XSD_UNSIGNED_SHORT.equals(qName)) {
                Integer n = NumberUtils.createInteger(number, locale);
            } else if (TYPE_XSD_INTEGER.equals(qName) || TYPE_XSD_NEGATIVEINTEGER.equals(qName) || TYPE_XSD_NONNEGATIVEINTEGER.equals(qName) || TYPE_XSD_NONPOSITIVEINTEGER.equals(qName) || TYPE_XSD_POSITIVEINTEGER.equals(qName) || TYPE_XSD_UNSIGNED_LONG.equals(qName)) {
                BigInteger bigInteger = NumberUtils.createBigInteger(number);
            } else if (TYPE_XSD_LONG.equals(qName) || TYPE_XSD_UNSIGNED_INT.equals(qName)) {
                Long l = NumberUtils.createLong(number, locale);
            } else if (TYPE_XSD_FLOAT.equals(qName)) {
                Float f = new Float(number.doubleValue());
            } else if (TYPE_XSD_DOUBLE.equals(qName)) {
                Double d = new Double(number.doubleValue());
            } else if (TYPE_XSD_DECIMAL.equals(qName)) {
                BigDecimal bigDecimal = NumberUtils.createMathBigDecimal(number);
            }
            if (!BPCClientTrace.isTracing) return var5_17;
            BPCClientTrace.exit(var5_17);
            return var5_17;
        }
        catch (NumberFormatException numberFormatException) {
            if (!BPCClientTrace.isTracing) throw new InvalidNumberInputException(new Object[]{string, NumberUtils.getExample(numberFormat, qName)}, numberFormatException);
            BPCClientTrace.trace(TraceLogger.TYPE_EVENT, numberFormatException.getMessage());
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "type = " + qName.toString() + " literal = " + string);
            throw new InvalidNumberInputException(new Object[]{string, NumberUtils.getExample(numberFormat, qName)}, numberFormatException);
        }
    }

    public String convertTo(Locale locale, QName qName, Object object) {
        String string = null;
        if (object instanceof String) {
            return (String)object;
        }
        NumberFormat numberFormat = NumberUtils.getNumberFormat(qName, locale);
        if (TYPE_XSD_BYTE.equals(qName)) {
            Byte by = (Byte)object;
            string = numberFormat.format((Object)by);
        } else if (TYPE_XSD_SHORT.equals(qName) || TYPE_XSD_UNSIGNED_BYTE.equals(qName)) {
            Short s = (Short)object;
            string = numberFormat.format((Object)s);
        } else if (TYPE_XSD_INT.equals(qName) || TYPE_XSD_UNSIGNED_SHORT.equals(qName)) {
            Integer n = (Integer)object;
            string = numberFormat.format((Object)n);
        } else if (TYPE_XSD_INTEGER.equals(qName) || TYPE_XSD_NEGATIVEINTEGER.equals(qName) || TYPE_XSD_NONNEGATIVEINTEGER.equals(qName) || TYPE_XSD_NONPOSITIVEINTEGER.equals(qName) || TYPE_XSD_POSITIVEINTEGER.equals(qName) || TYPE_XSD_UNSIGNED_LONG.equals(qName)) {
            long l;
            BigInteger bigInteger = (BigInteger)object;
            string = bigInteger != null ? (bigInteger.equals(BigInteger.valueOf(l = bigInteger.longValue())) ? numberFormat.format(l) : numberFormat.format(bigInteger)) : numberFormat.format(bigInteger);
        } else if (TYPE_XSD_LONG.equals(qName) || TYPE_XSD_UNSIGNED_INT.equals(qName)) {
            Long l = (Long)object;
            string = numberFormat.format((Object)l);
        } else if (TYPE_XSD_FLOAT.equals(qName)) {
            Float f = (Float)object;
            string = NumberUtils.convertToSpecialFloatValue(f);
            string = string != null ? string : numberFormat.format((Object)NumberUtils.convertFloat2Double(f));
        } else if (TYPE_XSD_DOUBLE.equals(qName)) {
            Double d = (Double)object;
            string = NumberUtils.convertToSpecialDoubleValue(d);
            string = string != null ? string : numberFormat.format((Object)d);
        } else if (TYPE_XSD_DECIMAL.equals(qName)) {
            BigDecimal bigDecimal = (BigDecimal)object;
            string = NumberUtils.renderICUDecimal(numberFormat, NumberUtils.createICUBigDecimal(bigDecimal));
        }
        return string;
    }

    public boolean isSupported(QName qName) {
        return NumberUtils.isNumberType(qName);
    }

    public static boolean isNumberType(String string) {
        return NUMBER_TYPES.contains(string);
    }

    public static Object getAsObject(String string, String string2, Locale locale) throws InvalidNumberInputException {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(string2);
        }
        NumberFormat numberFormat = NumberUtils.getNumberFormat(string, locale);
        try {
            ParsePosition parsePosition;
            Number number;
            Number number2 = null;
            string2 = string2.trim();
            boolean bl = string2.startsWith("-");
            String string3 = locale.getLanguage();
            String string4 = string2;
            if (Float.class.getName().equals(string)) {
                number2 = NumberUtils.createFromSpecialFloatLiteral(string2);
            } else if (Double.class.getName().equals(string)) {
                number2 = NumberUtils.createFromSpecialDoubleLiteral(string2);
            }
            if (number2 != null) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.exit(number2);
                }
                return number2;
            }
            if (bl) {
                string4 = string2.substring(1, string2.length());
                if ("ar".equals(string3) || "iw".equals(string3) || "he".equals(string3)) {
                    string2 = string4 + "-";
                }
            }
            if ((number = numberFormat.parse(string2, parsePosition = new ParsePosition(0))) == null || parsePosition.getIndex() != string2.length()) {
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Number parse error! literal = " + string2 + " position = " + parsePosition.getIndex());
                }
                throw new InvalidNumberInputException(new Object[]{string2, NumberUtils.getExample(numberFormat, string)});
            }
            if (Byte.class.getName().equals(string)) {
                number2 = NumberUtils.createByte(number, locale);
            } else if (Short.class.getName().equals(string)) {
                number2 = NumberUtils.createShort(number, locale);
            } else if (Integer.class.getName().equals(string)) {
                number2 = NumberUtils.createInteger(number, locale);
            } else if (BigInteger.class.getName().equals(string)) {
                number2 = NumberUtils.createBigInteger(number);
            } else if (Long.class.getName().equals(string)) {
                number2 = NumberUtils.createLong(number, locale);
            } else if (Float.class.getName().equals(string)) {
                number2 = new Float(number.doubleValue());
            } else if (Double.class.getName().equals(string)) {
                number2 = new Double(number.doubleValue());
            } else if (BigDecimal.class.getName().equals(string)) {
                number2 = NumberUtils.createMathBigDecimal(number);
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.exit(number2);
            }
            return number2;
        }
        catch (NumberFormatException numberFormatException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, numberFormatException.getMessage());
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "javaType = " + string + " literal = " + string2 + " locale = " + locale.getDisplayName());
            }
            throw new InvalidNumberInputException(new Object[]{string2, NumberUtils.getExample(numberFormat, string)}, numberFormatException);
        }
    }

    private static String getExample(NumberFormat numberFormat, String string) {
        String string2 = null;
        string2 = DECIMAL_TYPES.contains(string) ? numberFormat.format((Object)new Double("12345.67")) : numberFormat.format((Object)new Integer("12"));
        return string2;
    }

    public static String getAsString(String string, Object object, Locale locale) {
        String string2 = null;
        if (object instanceof String) {
            return (String)object;
        }
        NumberFormat numberFormat = NumberUtils.getNumberFormat(string, locale);
        if (Byte.class.getName().equals(string)) {
            Byte by = (Byte)object;
            string2 = numberFormat.format((Object)by);
        } else if (Short.class.getName().equals(string)) {
            Short s = (Short)object;
            string2 = numberFormat.format((Object)s);
        } else if (Integer.class.getName().equals(string)) {
            Integer n = (Integer)object;
            string2 = numberFormat.format((Object)n);
        } else if (BigInteger.class.getName().equals(string)) {
            long l;
            BigInteger bigInteger = (BigInteger)object;
            string2 = bigInteger != null ? (bigInteger.equals(BigInteger.valueOf(l = bigInteger.longValue())) ? numberFormat.format(l) : numberFormat.format(bigInteger)) : numberFormat.format(bigInteger);
        } else if (Long.class.getName().equals(string)) {
            Long l = (Long)object;
            string2 = numberFormat.format((Object)l);
        } else if (Float.class.getName().equals(string)) {
            Float f = (Float)object;
            string2 = NumberUtils.convertToSpecialFloatValue(f);
            string2 = string2 != null ? string2 : numberFormat.format((Object)NumberUtils.convertFloat2Double(f));
        } else if (Double.class.getName().equals(string)) {
            Double d = (Double)object;
            string2 = NumberUtils.convertToSpecialDoubleValue(d);
            string2 = string2 != null ? string2 : numberFormat.format((Object)d);
        } else if (BigDecimal.class.getName().equals(string)) {
            BigDecimal bigDecimal = (BigDecimal)object;
            string2 = NumberUtils.renderICUDecimal(numberFormat, NumberUtils.createICUBigDecimal(bigDecimal));
        }
        return string2;
    }

    public static boolean isNumberType(QName qName) {
        return NUMBER_TYPES.contains(qName);
    }

    private static String getExample(NumberFormat numberFormat, QName qName) {
        String string = null;
        string = DECIMAL_TYPES.contains(qName) ? numberFormat.format((Object)new Double("12345.67")) : numberFormat.format((Object)new Integer("12"));
        return string;
    }

    private static NumberFormat getNumberFormat(String string, Locale locale) {
        NumberFormat numberFormat = null;
        if (INTEGER_TYPES.contains(string)) {
            numberFormat = NumberFormat.getIntegerInstance((Locale)locale);
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(false);
            }
            numberFormat.setParseIntegerOnly(true);
        } else {
            numberFormat = NumberFormat.getInstance((Locale)locale);
            numberFormat.setMinimumFractionDigits(1);
        }
        numberFormat.setGroupingUsed(false);
        if (Float.class.getName().equals(string)) {
            numberFormat.setMaximumFractionDigits(6);
        } else {
            numberFormat.setMaximumFractionDigits(16);
        }
        return numberFormat;
    }

    private static NumberFormat getNumberFormat(QName qName, Locale locale) {
        NumberFormat numberFormat = null;
        if (INTEGER_TYPES.contains(qName)) {
            numberFormat = NumberFormat.getIntegerInstance((Locale)locale);
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(false);
            }
            numberFormat.setParseIntegerOnly(true);
        } else {
            numberFormat = NumberFormat.getInstance((Locale)locale);
            numberFormat.setMinimumFractionDigits(1);
        }
        numberFormat.setGroupingUsed(false);
        if (TYPE_XSD_FLOAT.equals(qName)) {
            numberFormat.setMaximumFractionDigits(6);
        } else {
            numberFormat.setMaximumFractionDigits(16);
        }
        return numberFormat;
    }

    private static Double convertFloat2Double(Float f) {
        return new Double(f.toString());
    }

    private static Float createFromSpecialFloatLiteral(String string) {
        if (string == null) {
            return null;
        }
        Float f = null;
        f = "NaN".equals(string) ? FLOAT_NAN : ("INF".equals(string) || "+INF".equals(string) ? FLOAT_POSITIVE_INFINITY : ("-INF".equals(string) ? FLOAT_NEGATIVE_INFINITY : null));
        return f;
    }

    private static String convertToSpecialFloatValue(Float f) {
        String string = null;
        string = FLOAT_NAN.equals(f) ? "NaN" : (FLOAT_POSITIVE_INFINITY.equals(f) ? "INF" : (FLOAT_NEGATIVE_INFINITY.equals(f) ? "-INF" : null));
        return string;
    }

    private static Double createFromSpecialDoubleLiteral(String string) {
        if (string == null) {
            return null;
        }
        Double d = null;
        d = "NaN".equals(string) ? DOUBLE_NAN : ("INF".equals(string) || "+INF".equals(string) ? DOUBLE_POSITIVE_INFINITY : ("-INF".equals(string) ? DOUBLE_NEGATIVE_INFINITY : null));
        return d;
    }

    private static String convertToSpecialDoubleValue(Double d) {
        String string = null;
        string = DOUBLE_NAN.equals(d) ? "NaN" : (DOUBLE_POSITIVE_INFINITY.equals(d) ? "INF" : (DOUBLE_NEGATIVE_INFINITY.equals(d) ? "-INF" : null));
        return string;
    }

    private static Byte createByte(Number number, Locale locale) throws NumberOverflowException {
        if (number instanceof Byte) {
            return (Byte)number;
        }
        BigInteger bigInteger = new BigInteger(number.toString());
        if (bigInteger.compareTo(MIN_BYTE_VALUE) == -1 || bigInteger.compareTo(MAX_BYTE_VALUE) == 1) {
            throw new NumberOverflowException(new Object[]{NumberUtils.getAsString("java.math.BigInteger", MIN_BYTE_VALUE, locale), NumberUtils.getAsString("java.math.BigInteger", MAX_BYTE_VALUE, locale)});
        }
        return new Byte(number.byteValue());
    }

    private static Short createShort(Number number, Locale locale) throws NumberOverflowException {
        if (number instanceof Byte) {
            return new Short(number.shortValue());
        }
        if (number instanceof Short) {
            return (Short)number;
        }
        BigInteger bigInteger = new BigInteger(number.toString());
        if (bigInteger.compareTo(MIN_SHORT_VALUE) == -1 || bigInteger.compareTo(MAX_SHORT_VALUE) == 1) {
            throw new NumberOverflowException(new Object[]{NumberUtils.getAsString("java.math.BigInteger", MIN_SHORT_VALUE, locale), NumberUtils.getAsString("java.math.BigInteger", MAX_SHORT_VALUE, locale)});
        }
        return new Short(number.shortValue());
    }

    private static Integer createInteger(Number number, Locale locale) throws NumberOverflowException {
        if (number instanceof Byte || number instanceof Short) {
            return new Integer(number.intValue());
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        BigInteger bigInteger = new BigInteger(number.toString());
        if (bigInteger.compareTo(MIN_INTEGER_VALUE) == -1 || bigInteger.compareTo(MAX_INTEGER_VALUE) == 1) {
            throw new NumberOverflowException(new Object[]{NumberUtils.getAsString("java.math.BigInteger", MIN_INTEGER_VALUE, locale), NumberUtils.getAsString("java.math.BigInteger", MAX_INTEGER_VALUE, locale)});
        }
        return new Integer(number.intValue());
    }

    private static Long createLong(Number number, Locale locale) throws NumberOverflowException {
        if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            return new Long(number.longValue());
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        BigInteger bigInteger = new BigInteger(number.toString());
        if (bigInteger.compareTo(MIN_LONG_VALUE) == -1 || bigInteger.compareTo(MAX_LONG_VALUE) == 1) {
            throw new NumberOverflowException(new Object[]{NumberUtils.getAsString("java.math.BigInteger", MIN_LONG_VALUE, locale), NumberUtils.getAsString("java.math.BigInteger", MAX_LONG_VALUE, locale)});
        }
        return new Long(number.longValue());
    }

    private static BigInteger createBigInteger(Number number) {
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    private static BigDecimal createMathBigDecimal(Number number) {
        String string = number.toString();
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal;
    }

    private static com.ibm.icu.math.BigDecimal createICUBigDecimal(BigDecimal bigDecimal) {
        String string = bigDecimal.toString();
        com.ibm.icu.math.BigDecimal bigDecimal2 = new com.ibm.icu.math.BigDecimal(string);
        return bigDecimal2;
    }

    private static String renderICUDecimal(NumberFormat numberFormat, com.ibm.icu.math.BigDecimal bigDecimal) {
        int n = bigDecimal.toString().length();
        if (n > 16) {
            numberFormat.setMaximumFractionDigits(n);
        } else {
            numberFormat.setMaximumFractionDigits(16);
        }
        return numberFormat.format(bigDecimal);
    }

    static {
        NUMBER_TYPES.add(Byte.class.getName());
        NUMBER_TYPES.add(Integer.class.getName());
        NUMBER_TYPES.add(BigInteger.class.getName());
        NUMBER_TYPES.add(Long.class.getName());
        NUMBER_TYPES.add(Short.class.getName());
        NUMBER_TYPES.add(BigDecimal.class.getName());
        NUMBER_TYPES.add(Double.class.getName());
        NUMBER_TYPES.add(Float.class.getName());
        NUMBER_TYPES.add(TYPE_XSD_BYTE);
        NUMBER_TYPES.add(TYPE_XSD_DECIMAL);
        NUMBER_TYPES.add(TYPE_XSD_DOUBLE);
        NUMBER_TYPES.add(TYPE_XSD_FLOAT);
        NUMBER_TYPES.add(TYPE_XSD_INT);
        NUMBER_TYPES.add(TYPE_XSD_INTEGER);
        NUMBER_TYPES.add(TYPE_XSD_LONG);
        NUMBER_TYPES.add(TYPE_XSD_NEGATIVEINTEGER);
        NUMBER_TYPES.add(TYPE_XSD_NONNEGATIVEINTEGER);
        NUMBER_TYPES.add(TYPE_XSD_NONPOSITIVEINTEGER);
        NUMBER_TYPES.add(TYPE_XSD_POSITIVEINTEGER);
        NUMBER_TYPES.add(TYPE_XSD_SHORT);
        NUMBER_TYPES.add(TYPE_XSD_UNSIGNED_BYTE);
        NUMBER_TYPES.add(TYPE_XSD_UNSIGNED_INT);
        NUMBER_TYPES.add(TYPE_XSD_UNSIGNED_LONG);
        NUMBER_TYPES.add(TYPE_XSD_UNSIGNED_SHORT);
        INTEGER_TYPES.add(Byte.class.getName());
        INTEGER_TYPES.add(Integer.class.getName());
        INTEGER_TYPES.add(BigInteger.class.getName());
        INTEGER_TYPES.add(Long.class.getName());
        INTEGER_TYPES.add(Short.class.getName());
        INTEGER_TYPES.add(TYPE_XSD_BYTE);
        INTEGER_TYPES.add(TYPE_XSD_INT);
        INTEGER_TYPES.add(TYPE_XSD_INTEGER);
        INTEGER_TYPES.add(TYPE_XSD_LONG);
        INTEGER_TYPES.add(TYPE_XSD_NEGATIVEINTEGER);
        INTEGER_TYPES.add(TYPE_XSD_NONNEGATIVEINTEGER);
        INTEGER_TYPES.add(TYPE_XSD_NONPOSITIVEINTEGER);
        INTEGER_TYPES.add(TYPE_XSD_POSITIVEINTEGER);
        INTEGER_TYPES.add(TYPE_XSD_SHORT);
        INTEGER_TYPES.add(TYPE_XSD_UNSIGNED_BYTE);
        INTEGER_TYPES.add(TYPE_XSD_UNSIGNED_INT);
        INTEGER_TYPES.add(TYPE_XSD_UNSIGNED_LONG);
        INTEGER_TYPES.add(TYPE_XSD_UNSIGNED_SHORT);
        DECIMAL_TYPES.add(BigDecimal.class.getName());
        DECIMAL_TYPES.add(Double.class.getName());
        DECIMAL_TYPES.add(Float.class.getName());
        DECIMAL_TYPES.add(TYPE_XSD_DECIMAL);
        DECIMAL_TYPES.add(TYPE_XSD_DOUBLE);
        DECIMAL_TYPES.add(TYPE_XSD_FLOAT);
    }
}

