/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.converter;

import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.util.FieldMapper;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import java.util.Locale;

public abstract class FieldConverter
implements SimpleConverter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";

    public Object getAsObject(String string, Locale locale) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("getAsObject(String value, Locale l) for value " + string + " using locale " + locale.getDisplayName());
        }
        this.errorNoModification();
        return null;
    }

    public String getAsString(Object object, Locale locale) {
        String string;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("getAsString(Object obj, Locale l) using locale " + locale.getDisplayName());
        }
        if ((string = this.getAsString(object)) != null) {
            String string2 = LocaleUtils.getLocalizedString(string, locale);
            return string2 != null ? string2 : string;
        }
        return null;
    }

    public String getAsString(Object object) {
        FieldMapper fieldMapper;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(object);
        }
        if ((fieldMapper = this.getFieldMapper(object)) == null) {
            this.errorNoMapper();
            return object.toString();
        }
        Integer n = this.getIntegerValue(object);
        if (n == null) {
            n = this.getValueFromModel(object, fieldMapper);
        }
        String string = null;
        if (n == null) {
            this.errorWrongObjectType();
        } else {
            string = (String)fieldMapper.getMapping().get(n);
            if (string == null) {
                this.errorNoKey(n);
                string = n.toString();
            } else if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> nlsKey for value " + n + " is " + string);
            }
        }
        return string;
    }

    protected abstract FieldMapper getFieldMapper(Object var1);

    protected Integer getIntegerValue(Object object) {
        Integer n = null;
        if (object instanceof Integer) {
            n = (Integer)object;
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> Value passed as Integer is " + n);
            }
        }
        if (object instanceof String) {
            n = Integer.valueOf((String)object);
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, ">>> Value passed as String is " + n);
            }
        }
        return n;
    }

    protected Integer getValueFromModel(Object object, FieldMapper fieldMapper) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        Integer n = null;
        n = fieldMapper.getFieldValue(object);
        return n;
    }

    protected boolean getLocalize() {
        return true;
    }

    protected void errorNoModification() {
        BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Field cannot be modified!");
    }

    protected void errorWrongObjectType() {
        BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Invalid object type.");
    }

    protected void errorNoKey(Object object) {
        BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "No key found for value " + object.toString());
    }

    protected void errorNoMapper() {
        BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "No mapping found.");
    }
}

