/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.converter;

import com.ibm.bpc.clientcore.converter.XConverter;
import com.ibm.bpc.clientcore.exception.InvalidDateInputException;
import com.ibm.bpc.clientcore.exception.InvalidDateTimeInputException;
import com.ibm.bpc.clientcore.exception.InvalidTimeInputException;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;

public class DateTimeUtils
implements XConverter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    static TimeZone UTC = TimeZone.getTimeZone((String)"UTC");
    static DateFormat serverDateFormatterOld = new SimpleDateFormat("'T'HH:mm:ss");
    static DateFormat serverDateFormatter = new SimpleDateFormat("HH:mm:ss");
    static DateFormat gDayFormatter = new SimpleDateFormat("---dd");
    static DateFormat gMonthFormatter = new SimpleDateFormat("--MM");
    static DateFormat gMonthDayFormatter = new SimpleDateFormat("--MM-dd");
    private static final QName DATETIME;
    private static final QName TIME;
    private static final QName DATE;
    static Set<QName> DATE_TIME_TYPES;

    public Object createFrom(Locale locale, QName qName, String string) throws ProcessException {
        Object object = null;
        if (DATE.equals(qName)) {
            object = DateTimeUtils.createFrom4Date(locale, string);
        } else if (DATETIME.equals(qName)) {
            object = DateTimeUtils.createFrom4DateTime(locale, string);
        } else if (TIME.equals(qName)) {
            object = DateTimeUtils.createFrom4Time(locale, string);
        }
        return object;
    }

    public String convertTo(Locale locale, QName qName, Object object) {
        String string = null;
        if (DATE.equals(qName)) {
            string = DateTimeUtils.convertTo4Date(locale, object);
        } else if (DATETIME.equals(qName)) {
            string = DateTimeUtils.convertTo4DateTime(locale, object);
        } else if (TIME.equals(qName)) {
            string = DateTimeUtils.convertTo4Time(locale, object);
        }
        return string;
    }

    public boolean isSupported(QName qName) {
        return DATE_TIME_TYPES.contains(qName);
    }

    private static Date createFrom4Date(Locale locale, String string) throws InvalidDateInputException {
        Date date = null;
        try {
            DateFormat dateFormat = DateFormat.getDateInstance((int)3, (Locale)locale);
            dateFormat.setLenient(false);
            dateFormat.setTimeZone(TimeZone.getDefault());
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            String string2 = DateTimeUtils.convertTo4Date(locale, new Date());
            throw new InvalidDateInputException(new Object[]{string, string2}, parseException);
        }
        return date;
    }

    private static Date createFrom4DateTime(Locale locale, String string) throws InvalidDateTimeInputException {
        Date date = null;
        try {
            date = DateTimeUtils.createFrom4DateTime(locale, string, 1);
        }
        catch (InvalidDateTimeInputException invalidDateTimeInputException) {
            // empty catch block
        }
        if (date == null) {
            try {
                date = DateTimeUtils.createFrom4DateTime(locale, string, 2);
            }
            catch (InvalidDateTimeInputException invalidDateTimeInputException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                date = DateTimeUtils.createFrom4DateTime(locale, string, 3);
            }
            catch (InvalidDateTimeInputException invalidDateTimeInputException) {
                // empty catch block
            }
        }
        if (date == null) {
            date = DateTimeUtils.createFrom4DateTime(locale, string, null);
        }
        return date;
    }

    private static Date createFrom4DateTime(Locale locale, String string, Integer n) throws InvalidDateTimeInputException {
        Date date = null;
        try {
            DateFormat dateFormat = null;
            dateFormat = n != null ? DateFormat.getDateTimeInstance((int)3, (int)n, (Locale)locale) : DateFormat.getDateInstance((int)3, (Locale)locale);
            dateFormat.setLenient(false);
            dateFormat.setTimeZone(UTC);
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            String string2 = DateTimeUtils.convertTo4DateTime(locale, new Date());
            throw new InvalidDateTimeInputException(new Object[]{string, string2}, parseException);
        }
        return date;
    }

    private static String createFrom4Time(Locale locale, String string) throws InvalidTimeInputException {
        String string2 = null;
        try {
            string2 = DateTimeUtils.createFrom4Time(locale, string, 1);
        }
        catch (InvalidTimeInputException invalidTimeInputException) {
            // empty catch block
        }
        if (string2 == null) {
            try {
                string2 = DateTimeUtils.createFrom4Time(locale, string, 2);
            }
            catch (InvalidTimeInputException invalidTimeInputException) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = DateTimeUtils.createFrom4Time(locale, string, 3);
        }
        return string2;
    }

    private static String createFrom4Time(Locale locale, String string, int n) throws InvalidTimeInputException {
        DateFormat dateFormat = DateFormat.getTimeInstance((int)n, (Locale)locale);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(UTC);
        String string2 = null;
        try {
            Date date = dateFormat.parse(string);
            string2 = serverDateFormatter.format(date);
        }
        catch (ParseException parseException) {
            String string3 = dateFormat.format(new Date());
            throw new InvalidTimeInputException(new Object[]{string, string3}, parseException);
        }
        return string2;
    }

    private static String convertTo4Time(Locale locale, Object object) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("\"" + object + "\"");
        }
        DateFormat dateFormat = DateFormat.getTimeInstance((int)1, (Locale)locale);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(UTC);
        String string = null;
        try {
            Date date;
            ParseException parseException = null;
            try {
                date = serverDateFormatter.parse((String)object);
            }
            catch (ParseException parseException2) {
                parseException = parseException2;
                try {
                    date = serverDateFormatterOld.parse((String)object);
                }
                catch (ParseException parseException3) {
                    throw parseException;
                }
            }
            string = dateFormat.format(date);
        }
        catch (ParseException parseException) {
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, parseException);
            }
            string = (String)object;
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("\"" + string + "\"");
        }
        return string;
    }

    private static String convertTo4DateTime(Locale locale, Object object) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance((int)3, (int)1, (Locale)locale);
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(UTC);
        ((SimpleDateFormat)dateFormat).applyPattern(LocaleUtils.getAdjustedYearPattern(3, 1, locale));
        String string = dateFormat.format((Date)object);
        if ("ar".equals(locale.getLanguage())) {
            string = "&lrm; ".concat(string).concat(" &#x202C; ");
        }
        return string;
    }

    private static String convertTo4Date(Locale locale, Object object) {
        DateFormat dateFormat = DateFormat.getDateInstance((int)3, (Locale)locale);
        dateFormat.setTimeZone(TimeZone.getDefault());
        dateFormat.setLenient(false);
        ((SimpleDateFormat)dateFormat).applyPattern(LocaleUtils.getAdjustedYearPattern(3, null, locale));
        String string = dateFormat.format((Date)object);
        if ("ar".equals(locale.getLanguage())) {
            string = "&lrm; ".concat(string).concat(" &#x202C; ");
        }
        return string;
    }

    public static String createGDaySample(Date date) {
        return gDayFormatter.format(date);
    }

    public static String createGMonthSample(Date date) {
        return gMonthFormatter.format(date);
    }

    public static String createGMonthDaySample(Date date) {
        return gMonthDayFormatter.format(date);
    }

    static {
        serverDateFormatter.setTimeZone(UTC);
        serverDateFormatterOld.setTimeZone(UTC);
        gDayFormatter.setTimeZone(UTC);
        gMonthFormatter.setTimeZone(UTC);
        gMonthDayFormatter.setTimeZone(UTC);
        DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
        TIME = new QName("http://www.w3.org/2001/XMLSchema", "time");
        DATE = new QName("http://www.w3.org/2001/XMLSchema", "date");
        DATE_TIME_TYPES = new HashSet<QName>();
        DATE_TIME_TYPES.add(DATETIME);
        DATE_TIME_TYPES.add(DATE);
        DATE_TIME_TYPES.add(TIME);
    }
}

