/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.converter;

import com.ibm.bpc.clientcore.converter.DateTimeUtils;
import com.ibm.bpc.clientcore.converter.NumberOutOfBoundsException;
import com.ibm.bpc.clientcore.converter.NumberUtils;
import com.ibm.bpc.clientcore.converter.XConverter;
import com.ibm.bpc.clientcore.exception.InvalidExpressionException;
import com.ibm.bpc.clientcore.exception.InvalidQNameException;
import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.Assert;
import com.ibm.bpe.util.Base16;
import com.ibm.bpe.util.Base64;
import com.ibm.bpe.util.DataConversionException;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.bpe.util.XSDJavaConverter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class ConverterUtils
implements XConverter {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2009.\n\n";
    private NumberUtils numberUtils = new NumberUtils();
    private DateTimeUtils dateTimeUtils = new DateTimeUtils();
    private static XConverter INSTANCE = null;
    private static String durationPatternString = "-?P(\\d+Y)?(\\d+M)?(\\d+D)?(T(\\d+H)?(\\d+M)?(\\d*\\.?\\d*S)?)?";
    private static final Pattern moreThanOneWhiteSpace = Pattern.compile("(\\s)(\\s{1,})");
    private static final Pattern durationPattern = Pattern.compile(durationPatternString);
    private static final QName BASE64BIN = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
    private static final QName HEXBINARY = new QName("http://www.w3.org/2001/XMLSchema", "hexBinary");
    private static final QName QNAME = new QName("http://www.w3.org/2001/XMLSchema", "QName");
    private static final QName NORMALIZED_STRING = new QName("http://www.w3.org/2001/XMLSchema", "normalizedString");
    private static final QName DURATION = new QName("http://www.w3.org/2001/XMLSchema", "duration");
    static Set SUPPORTED_TYPES = new HashSet();

    public static synchronized XConverter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConverterUtils();
        }
        return INSTANCE;
    }

    public Object createFrom(Locale locale, QName qName, String string) throws ProcessException {
        String string2 = string = string != null ? string.trim() : null;
        if (this.numberUtils.isSupported(qName)) {
            Object object = this.numberUtils.createFrom(locale, qName, string);
            String string3 = this.numberUtils.convertTo(locale, qName, object);
            if (string3 != null && !string3.equals(string)) {
                if (string3.startsWith(string)) {
                    String string4 = string3.substring(string.length());
                    if (!".0".equals(string4) && !"0,".equals(string4)) {
                        throw new NumberOutOfBoundsException(new Object[]{string, qName.getLocalPart(), string3});
                    }
                } else {
                    throw new NumberOutOfBoundsException(new Object[]{string, qName.getLocalPart(), string3});
                }
            }
            return object;
        }
        if (this.dateTimeUtils.isSupported(qName)) {
            return this.dateTimeUtils.createFrom(locale, qName, string);
        }
        if (QNAME.equals(qName)) {
            if (string.indexOf("#") == -1) {
                throw new InvalidQNameException(new Object[]{string});
            }
            return string;
        }
        if (BASE64BIN.equals(qName)) {
            try {
                byte[] byArray = Base64.decode((String)string);
                if (!this.checkBaseEncoding(string, this.convertTo(locale, BASE64BIN, byArray))) {
                    String string5 = BASE64BIN.toString();
                    throw new DataConversionException(new Object[]{string5});
                }
                return byArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidExpressionException(new Object[]{string, "[A-Za-z0-9+/]*={0,2}", qName.getLocalPart()}, illegalArgumentException);
            }
        }
        if (HEXBINARY.equals(qName)) {
            try {
                byte[] byArray = Base16.decode((String)string);
                if (!this.checkBaseEncoding(string, this.convertTo(locale, HEXBINARY, byArray))) {
                    String string6 = HEXBINARY.toString();
                    throw new DataConversionException(new Object[]{string6});
                }
                return byArray;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidExpressionException(new Object[]{string, "[0-9A-F]*", qName.getLocalPart()}, illegalArgumentException);
            }
        }
        if (NORMALIZED_STRING.equals(qName)) {
            Matcher matcher = moreThanOneWhiteSpace.matcher(string);
            return matcher.replaceAll(" ");
        }
        if (DURATION.equals(qName)) {
            Matcher matcher = durationPattern.matcher(string);
            if (matcher.matches()) {
                return string;
            }
            throw new InvalidExpressionException(new Object[]{string, durationPatternString, qName.getLocalPart()});
        }
        Assert.assertion((boolean)true, (String)(qName + " not supported"));
        return null;
    }

    private boolean checkBaseEncoding(String string, String string2) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "literal='" + string + "' expectedLiteral='" + string2 + "'");
        }
        return string2 != null && string2.startsWith(string);
    }

    public String convertTo(Locale locale, QName qName, Object object) {
        if (this.numberUtils.isSupported(qName)) {
            return this.numberUtils.convertTo(locale, qName, object);
        }
        if (this.dateTimeUtils.isSupported(qName)) {
            return this.dateTimeUtils.convertTo(locale, qName, object);
        }
        if (QNAME.equals(qName)) {
            return (String)object;
        }
        if (BASE64BIN.equals(qName)) {
            return Base64.encode((byte[])((byte[])object));
        }
        if (HEXBINARY.equals(qName)) {
            return Base16.encode((byte[])((byte[])object));
        }
        if (NORMALIZED_STRING.equals(qName)) {
            return (String)object;
        }
        if (DURATION.equals(qName)) {
            return (String)object;
        }
        Assert.assertion((boolean)true, (String)(qName + " not supported"));
        return null;
    }

    public boolean isSupported(QName qName) {
        if (this.numberUtils.isSupported(qName)) {
            return true;
        }
        if (this.dateTimeUtils.isSupported(qName)) {
            return true;
        }
        return SUPPORTED_TYPES.contains(qName);
    }

    public static QName getXSDTypeForClazz(Class clazz) {
        if (byte[].class.equals((Object)clazz)) {
            return HEXBINARY;
        }
        return XSDJavaConverter.getXSDType4JavaType((String)clazz.getName(), (XSDJavaConverter.MapRule)XSDJavaConverter.SDO11_8B);
    }

    static {
        SUPPORTED_TYPES.add(BASE64BIN);
        SUPPORTED_TYPES.add(HEXBINARY);
        SUPPORTED_TYPES.add(NORMALIZED_STRING);
        SUPPORTED_TYPES.add(QNAME);
        SUPPORTED_TYPES.add(DURATION);
    }
}

