/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore.bean;

import com.ibm.bpc.clientcore.bean.PropertyBean;
import com.ibm.bpc.clientcore.converter.CalendarConverter;
import com.ibm.bpc.clientcore.converter.SimpleConverter;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpe.api.QueryProperty;
import com.ibm.bpe.api.UTCDate;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.clientmodel.converter.QueryPropertyConverter;
import com.ibm.bpe.clientmodel.converter.QueryPropertyMappedTypeConverter;
import com.ibm.bpe.util.TraceLogger;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class QueryPropertyBean
extends PropertyBean {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2006, 2009.\n\n";
    private static final long serialVersionUID = 1L;
    public static final String VARIABLENAME_PROPERTY = "variableName";
    public static final String NAMESPACE_PROPERTY = "namespace";
    public static final String MAPPEDTYPE_PROPERTY = "mappedType";
    public static final String VALUE_PROPERTY = "value";
    public static final String STRINGVALUE_PROPERTY = "stringValue";
    public static final String GENERICVALUE_PROPERTY = "genericValue";
    public static final String NUMBERVALUE_PROPERTY = "numberValue";
    public static final String DECIMALVALUE_PROPERTY = "decimalValue";
    public static final String TIMESTAMPVALUE_PROPERTY = "timestampValue";
    private String variableName = null;
    private String namespace = null;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_GENERIC = 0;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_TIMESTAMP = 4;
    int mappedType = 1;
    private String stringValue = null;
    private String genericValue = null;
    private Long numberValue = null;
    private Double decimalValue = null;
    private Long timestampValue;
    public static final String SEPARATOR = "@";
    protected static final String IDENT = "    ";
    private static final TimeZone UTC_TIMEZONE;
    public static final String TABLE_NAME = "QUERY_PROPERTY";

    public static SimpleConverter getConverter(String string) {
        SimpleConverter simpleConverter = (SimpleConverter)converters.get(string);
        return simpleConverter;
    }

    public static String getLabel(String string) {
        String string2 = (String)labels.get(string);
        return string2;
    }

    public static String getLabel(String string, Locale locale) {
        String string2 = LocaleUtils.getLocalizedString((String)labels.get(string), locale);
        return string2;
    }

    public static boolean isValid(String string) {
        boolean bl = labels.get(string) != null;
        return bl;
    }

    public QueryPropertyBean() {
    }

    public QueryPropertyBean(String string, String string2, String string3, int n) {
        super(string);
        this.variableName = string2;
        this.namespace = string3;
        this.mappedType = n;
    }

    public QueryPropertyBean(String string, String string2, String string3) {
        super(string);
        this.variableName = string2;
        this.namespace = string3;
        this.mappedType = 1;
    }

    public QueryPropertyBean(String string, String string2, String string3, String string4) {
        this(string, string2, string3);
        this.stringValue = string4;
    }

    public QueryPropertyBean(QueryProperty queryProperty) {
        this(queryProperty.getName(), queryProperty.getVariableName(), queryProperty.getNamespace(), queryProperty.getMappedType());
    }

    public QueryPropertyBean(String string) {
        this(QueryPropertyBean.getName(string), QueryPropertyBean.getVariableName(string), QueryPropertyBean.getNamespace(string));
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public int getMappedType() {
        return this.mappedType;
    }

    public void setMappedType(int n) {
        this.mappedType = n;
        if (n != 1) {
            this.setStringValue(null);
        }
        if (n != 0) {
            this.setGenericValue(null);
        }
        if (n != 2) {
            this.setNumberValue(null);
        }
        if (n != 3) {
            this.setDecimalValue(null);
        }
        if (n != 4) {
            this.setTimestampValue((Calendar)null);
        }
    }

    public void setValue(int n, String string) {
        if (n == 1) {
            this.setStringValue(string);
        } else if (n == 0) {
            this.setGenericValue(string);
        } else if (n == 2) {
            if (string != null) {
                this.setNumberValue(Long.valueOf(string));
            } else {
                this.setNumberValue(null);
            }
        } else if (n == 3) {
            if (string != null) {
                this.setDecimalValue(Double.valueOf(string));
            } else {
                this.setDecimalValue(null);
            }
        } else if (n == 4) {
            if (string != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(Long.valueOf(string));
                this.setTimestampValue(calendar);
            } else {
                this.setTimestampValue((Calendar)null);
            }
        }
    }

    public void setValue(Object object) {
    }

    public Object getValue() {
        if (this.mappedType == 1) {
            return this.getStringValue();
        }
        if (this.mappedType == 0) {
            return this.getGenericValue();
        }
        if (this.mappedType == 2) {
            return this.getNumberValue();
        }
        if (this.mappedType == 3) {
            return this.getDecimalValue();
        }
        if (this.mappedType == 4) {
            return this.getTimestampValue();
        }
        return null;
    }

    public String getValueAsString() {
        String string = null;
        if (this.mappedType == 4 && this.getTimestampValue() != null) {
            Calendar calendar = this.getTimestampValue();
            string = Long.toString(calendar.getTimeInMillis());
        } else {
            string = this.getValue(null, null);
        }
        return string;
    }

    private String getValue(Locale locale, TimeZone timeZone) {
        String string = null;
        if (this.mappedType == 1) {
            string = this.getStringValue();
        } else if (this.mappedType == 0) {
            string = this.getGenericValue();
        } else if (this.mappedType == 2 && this.getNumberValue() != null) {
            string = this.getNumberValue().toString();
        } else if (this.mappedType == 3 && this.getDecimalValue() != null) {
            string = this.getDecimalValue().toString();
        } else if (this.mappedType == 4 && this.getTimestampValue() != null) {
            TimeZone timeZone2;
            CalendarConverter calendarConverter = new CalendarConverter();
            Locale locale2 = locale;
            if (locale2 == null) {
                locale2 = Locale.getDefault();
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Locale not set using default!");
                }
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "Locale: " + locale2.toString());
            }
            if ((timeZone2 = timeZone) == null) {
                timeZone2 = TimeZone.getDefault();
                if (BPCClientTrace.isTracing) {
                    BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "TimeZone not set using default!");
                }
            }
            if (BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "TimeZone: " + timeZone2.toString());
            }
            string = calendarConverter.getAsString(this.getTimestampValue(), locale2, timeZone2);
        }
        return string;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String string) {
        this.stringValue = string;
        if (string != null) {
            this.setMappedType(1);
        }
    }

    public String getGenericValue() {
        return this.genericValue;
    }

    public void setGenericValue(String string) {
        this.genericValue = string;
        if (string != null) {
            this.setMappedType(0);
        }
    }

    public Long getNumberValue() {
        return this.numberValue;
    }

    public void setNumberValue(Long l) {
        this.numberValue = l;
        if (l != null) {
            this.setMappedType(2);
        }
    }

    public Double getDecimalValue() {
        return this.decimalValue;
    }

    public void setDecimalValue(Double d) {
        this.decimalValue = d;
        if (d != null) {
            this.setMappedType(3);
        }
    }

    public Calendar getTimestampValue() {
        Calendar calendar = null;
        if (this.timestampValue != null) {
            calendar = Calendar.getInstance(UTC_TIMEZONE);
            calendar.setTimeInMillis(this.timestampValue);
        }
        return calendar;
    }

    public void setTimestampValue(Calendar calendar) {
        if (calendar == null) {
            return;
        }
        this.timestampValue = new Long(calendar.getTimeInMillis());
        if (this.timestampValue != null) {
            this.setMappedType(4);
        }
    }

    private void setTimestampValue(UTCDate uTCDate) {
        if (uTCDate == null) {
            return;
        }
        this.timestampValue = new Long(uTCDate.getTime());
        if (this.timestampValue != null) {
            this.setMappedType(4);
        }
    }

    public String getKey() {
        return QueryPropertyBean.getKey(this.getName(), this.getVariableName(), this.getNamespace());
    }

    public static String getKey(String string, String string2, String string3) {
        return string + SEPARATOR + string2 + SEPARATOR + string3;
    }

    private static String getName(String string) {
        return string.substring(0, string.indexOf(SEPARATOR));
    }

    private static String getVariableName(String string) {
        return string.substring(string.indexOf(SEPARATOR) + 1, string.lastIndexOf(SEPARATOR));
    }

    private static String getNamespace(String string) {
        return string.substring(string.lastIndexOf(SEPARATOR) + 1);
    }

    public String toString() {
        return this.getKey() + SEPARATOR + "type:" + new QueryPropertyMappedTypeConverter().getAsString((Object)new Integer(this.getMappedType())) + "=" + this.getValue(null, null);
    }

    public StringBuffer toXML(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("serialize QueryPropertyBean");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    <valueCondition>" + this.eol);
        stringBuffer.append(this.toXMLQueryProperty(string));
        stringBuffer.append(this.toXMLValue());
        stringBuffer.append("    </valueCondition>" + this.eol);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("serialize QueryPropertyBean finished...");
        }
        return stringBuffer;
    }

    protected StringBuffer toXMLQueryProperty(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(" ... key     : " + this.getKey());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("      <queryProperty entityType=\"" + string + "\" name=\"" + this.getName() + "\"");
        stringBuffer.append(" mappedType=\"" + this.mappedType + "\"");
        if (this.namespace != null && !this.namespace.equals("")) {
            stringBuffer.append(" namespace=\"" + this.namespace + "\"");
        }
        if (this.variableName != null && !this.variableName.equals("")) {
            stringBuffer.append(" nameVariable=\"" + this.variableName + "\"");
        }
        stringBuffer.append("/>" + this.eol);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return stringBuffer;
    }

    protected StringBuffer toXMLValue() {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry(" ... value     : " + this.getValue());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("      <value>" + this.getValueAsString() + "</value>" + this.eol);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return stringBuffer;
    }

    public void setValueFromResultSet(String string, Object object) {
        if (object != null) {
            if ("STRING_VALUE".equals(string)) {
                this.setStringValue((String)object);
            } else if ("GENERIC_VALUE".equals(string)) {
                this.setGenericValue((String)object);
            } else if ("NUMBER_VALUE".equals(string)) {
                this.setNumberValue((Long)object);
            } else if ("DECIMAL_VALUE".equals(string)) {
                this.setDecimalValue((Double)object);
            } else if ("TIMESTAMP_VALUE".equals(string)) {
                this.setTimestampValue((UTCDate)object);
            } else if ("NAME".equals(string)) {
                this.setName((String)object);
            } else if ("VARIABLE_NAME".equals(string)) {
                this.setVariableName((String)object);
            } else if ("NAMESPACE".equals(string)) {
                this.setNamespace((String)object);
            } else if (!"PIID".equals(string) && BPCClientTrace.isTracing) {
                BPCClientTrace.trace(TraceLogger.TYPE_EVENT, "Invalid column: " + string);
            }
        }
    }

    static {
        labels.put(VARIABLENAME_PROPERTY, "QUERY.PROPERTY.VARIABLE.NAME");
        labels.put(NAMESPACE_PROPERTY, "QUERY.PROPERTY.NAMESPACE");
        labels.put(MAPPEDTYPE_PROPERTY, "QUERY.PROPERTY.MAPPED.TYPE");
        labels.put(VALUE_PROPERTY, "QUERY.PROPERTY.VALUE");
        labels.put(STRINGVALUE_PROPERTY, "QUERY.PROPERTY.STRING.VALUE");
        labels.put(GENERICVALUE_PROPERTY, "QUERY.PROPERTY.GENERIC.VALUE");
        labels.put(NUMBERVALUE_PROPERTY, "QUERY.PROPERTY.NUMBER.VALUE");
        labels.put(DECIMALVALUE_PROPERTY, "QUERY.PROPERTY.DECIMAL.VALUE");
        labels.put(TIMESTAMPVALUE_PROPERTY, "QUERY.PROPERTY.TIMESTAMP.VALUE");
        converters.put(MAPPEDTYPE_PROPERTY, new QueryPropertyMappedTypeConverter());
        converters.put(TIMESTAMPVALUE_PROPERTY, new CalendarConverter());
        converters.put(VALUE_PROPERTY, new QueryPropertyConverter());
        UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    }
}

