/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore;

import com.ibm.bpc.clientcore.XMLSerializable;
import com.ibm.bpc.clientcore.util.LocaleUtils;
import com.ibm.bpc.clientcore.util.ParserUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.TraceLogger;
import java.util.Locale;
import org.w3c.dom.Node;

public class OrderInfo
implements XMLSerializable {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2007, 2008.\n\n";
    public final String eol = System.getProperty("line.separator");
    public static final String ORDER_ASCENDING = "ASC";
    public static final String ORDER_DESCENDING = "DESC";
    public static final String KEY_ORDER_ASCENDING = "ORDER.ASCENDING";
    public static final String KEY_ORDER_DESCENDING = "ORDER.DESCENDING";
    private String propertyName = null;
    private boolean isDescending = false;

    public OrderInfo(String string) {
        this.propertyName = string;
    }

    public OrderInfo(String string, String string2) {
        this.propertyName = string;
        this.isDescending = ORDER_DESCENDING.equals(string2);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public boolean isDescending() {
        return this.isDescending;
    }

    public void setDescending(boolean bl) {
        this.isDescending = bl;
    }

    public String getDirection() {
        return this.isDescending() ? ORDER_DESCENDING : ORDER_ASCENDING;
    }

    public String getDirectionDescending() {
        return this.isDescending() ? ORDER_DESCENDING : null;
    }

    public String getLabelDirection(Locale locale) {
        return this.isDescending() ? OrderInfo.getLabelDescending(locale) : OrderInfo.getLabelAscending(locale);
    }

    public static String getLabelAscending(Locale locale) {
        return LocaleUtils.getLocalizedString(KEY_ORDER_ASCENDING, locale);
    }

    public static String getLabelDescending(Locale locale) {
        return LocaleUtils.getLocalizedString(KEY_ORDER_DESCENDING, locale);
    }

    public String toString() {
        return "propertyName=" + this.propertyName + ", dir=" + this.getDirection();
    }

    public static OrderInfo fromXML(Node node) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        String string = ParserUtils.attributeOf(node, "name");
        String string2 = ParserUtils.attributeOf(node, "dir");
        OrderInfo orderInfo = new OrderInfo(string, string2);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "deserialize OrderInfo: " + orderInfo.toString());
            BPCClientTrace.exit();
        }
        return orderInfo;
    }

    public StringBuffer toXML(String string) {
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("serialize OrderInfo name    : " + this.getPropertyName());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("      <order name=\"" + this.getPropertyName() + "\"");
        String string2 = this.getDirectionDescending();
        if (string2 != null) {
            stringBuffer.append(" dir=\"" + string2 + "\"");
        }
        stringBuffer.append("/>" + this.eol);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit("serialize OrderInfo finished...");
        }
        return stringBuffer;
    }
}

