/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpc.clientcore;

import com.ibm.bpc.clientcore.XMLSerializable;
import com.ibm.bpc.clientcore.util.ParserUtils;
import com.ibm.bpe.client.BPCClientTrace;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceLogger;
import org.w3c.dom.Node;

public class ColumnInfo
implements XMLSerializable {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corporation 2005, 2008.\n\n";
    public final String eol = System.getProperty("line.separator");
    private String propertyName;
    private String action;
    private String label = null;
    private String labelKey = null;
    private Object propertyConverter = null;

    public ColumnInfo(String string, String string2, Object object, String string3) {
        this.propertyName = string;
        this.labelKey = string2;
        this.propertyConverter = object;
        this.action = string3;
    }

    public ColumnInfo(String string, String string2, Object object) {
        this.propertyName = string;
        this.labelKey = string2;
        this.propertyConverter = object;
        this.action = null;
    }

    public ColumnInfo() {
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public String getAction() {
        return this.action;
    }

    public Object getPropertyConverter() {
        return this.propertyConverter;
    }

    public void setPropertyConverter(Object object) {
        this.propertyConverter = object;
    }

    public String toString() {
        return "propertyName=" + this.propertyName + ", action=" + this.action + ", label=" + this.label + ", labelKey=" + this.labelKey + ", converter=" + this.propertyConverter;
    }

    public static ColumnInfo fromXML(Node node) {
        String string;
        Object object;
        ColumnInfo columnInfo = new ColumnInfo();
        Class<?> clazz = null;
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry();
        }
        columnInfo.propertyName = ParserUtils.attributeOf(node, "name");
        columnInfo.action = ParserUtils.attributeOf(node, "action");
        Node node2 = ParserUtils.childElementOf(node, "label");
        if (node2 != null) {
            object = ParserUtils.attributeOf(node2, "value");
            if (object != null) {
                columnInfo.label = object;
            } else {
                columnInfo.labelKey = ParserUtils.attributeOf(node2, "key");
            }
        }
        if ((object = ParserUtils.childElementOf(node, "converter")) != null && (string = ParserUtils.attributeOf((Node)object, "name")) != null) {
            try {
                clazz = Class.forName(string);
                columnInfo.propertyConverter = clazz.newInstance();
            }
            catch (Exception exception) {
                MessageLogger messageLogger = MessageLogger.newMessageLogger((String)BPCClientTrace.class.getName());
                messageLogger.exception(MessageLogger.TYPE_ERROR, (Throwable)exception);
            }
        }
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "deserialize ColumnInfo: found ColumnInfo with following values:");
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "deserialize ColumnInfo: name     : " + columnInfo.propertyName);
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "deserialize ColumnInfo: label    : " + columnInfo.label);
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "deserialize ColumnInfo: labelkey : " + columnInfo.labelKey);
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "deserialize ColumnInfo: action   : " + columnInfo.action);
            BPCClientTrace.trace(TraceLogger.TYPE_DEBUG, "deserialize ColumnInfo: converter: " + columnInfo.propertyConverter);
            BPCClientTrace.exit();
        }
        return columnInfo;
    }

    public StringBuffer toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "      ";
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.entry("serialize ColumnInfo name    : " + this.propertyName);
        }
        stringBuffer.append(string2 + "<column name=\"" + this.propertyName + "\"");
        if (this.action != null && !this.action.equals("")) {
            stringBuffer.append(" action=\"" + this.action + "\"");
        }
        stringBuffer.append(">" + this.eol);
        if (this.labelKey != null && !this.labelKey.equals("")) {
            stringBuffer.append(string2 + "  <label");
            stringBuffer.append(" key=\"" + this.labelKey + "\"/>" + this.eol);
        } else if (this.label != null && !this.label.equals("")) {
            stringBuffer.append(string2 + "  <label");
            stringBuffer.append(" value=\"" + this.label + "\"/>" + this.eol);
        }
        if (this.propertyConverter != null && !this.propertyConverter.equals("")) {
            stringBuffer.append(string2 + "  <converter name=\"" + this.propertyConverter.getClass().getName() + "\" />" + this.eol);
        }
        stringBuffer.append(string2 + "</column>" + this.eol);
        if (BPCClientTrace.isTracing) {
            BPCClientTrace.exit();
        }
        return stringBuffer;
    }
}

